/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.values.virtual.NodeValue;
import org.neo4j.values.virtual.PathValue;
import org.neo4j.values.virtual.RelationshipValue;

public class PathWrappingPathValue
extends PathValue {
    private final Path path;

    PathWrappingPathValue(Path path) {
        this.path = path;
    }

    @Override
    public NodeValue startNode() {
        return ValueUtils.fromNodeProxy(this.path.startNode());
    }

    @Override
    public NodeValue endNode() {
        return ValueUtils.fromNodeProxy(this.path.endNode());
    }

    @Override
    public RelationshipValue lastRelationship() {
        return ValueUtils.fromRelationshipProxy(this.path.lastRelationship());
    }

    @Override
    public NodeValue[] nodes() {
        int length2 = this.path.length() + 1;
        NodeValue[] values2 = new NodeValue[length2];
        int i = 0;
        for (Node node : this.path.nodes()) {
            values2[i++] = ValueUtils.fromNodeProxy(node);
        }
        return values2;
    }

    @Override
    public RelationshipValue[] relationships() {
        int length2 = this.path.length();
        RelationshipValue[] values2 = new RelationshipValue[length2];
        int i = 0;
        for (Relationship relationship : this.path.relationships()) {
            values2[i++] = ValueUtils.fromRelationshipProxy(relationship);
        }
        return values2;
    }

    public Path path() {
        return this.path;
    }
}

