/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.util.Comparator;
import java.util.Iterator;
import org.neo4j.helpers.collection.PrefetchingIterator;

public class NumberAwareStringComparator
implements Comparator<String> {
    public static final Comparator<String> INSTANCE = new NumberAwareStringComparator();

    @Override
    public int compare(String o1, String o2) {
        boolean c2Has;
        boolean c1Has;
        Iterator<Comparable> c1 = this.comparables(o1);
        Iterator<Comparable> c2 = this.comparables(o2);
        while ((c1Has = c1.hasNext()) | (c2Has = c2.hasNext())) {
            if (!c1Has) {
                return -1;
            }
            if (!c2Has) {
                return 1;
            }
            int diff2 = c1.next().compareTo(c2.next());
            if (diff2 == 0) continue;
            return diff2;
        }
        return 0;
    }

    private Iterator<Comparable> comparables(final String string2) {
        return new PrefetchingIterator<Comparable>(){
            private int index;

            protected Comparable fetchNextOrNull() {
                if (this.index >= string2.length()) {
                    return null;
                }
                int startIndex = this.index;
                char ch = string2.charAt(this.index);
                boolean isNumber = Character.isDigit(ch);
                while (Character.isDigit(ch) == isNumber && ++this.index < string2.length()) {
                    ch = string2.charAt(this.index);
                }
                String substring = string2.substring(startIndex, this.index);
                return isNumber ? Long.valueOf(substring) : substring;
            }
        };
    }
}

