/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.participant;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.util.Optional;
import org.neo4j.function.Predicates;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.io.fs.FileHandle;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.kernel.api.labelscan.NodeLabelUpdate;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.scan.FullLabelStream;
import org.neo4j.kernel.impl.index.labelscan.NativeLabelScanStore;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.id.ReadOnlyIdGeneratorFactory;
import org.neo4j.kernel.impl.storemigration.participant.AbstractStoreMigrationParticipant;
import org.neo4j.kernel.impl.transaction.state.storeview.NeoStoreIndexStoreView;
import org.neo4j.kernel.impl.util.monitoring.ProgressReporter;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.Lifespan;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

public class NativeLabelScanStoreMigrator
extends AbstractStoreMigrationParticipant {
    private final FileSystemAbstraction fileSystem;
    private final PageCache pageCache;
    private final Config config;
    private boolean nativeLabelScanStoreMigrated;

    public NativeLabelScanStoreMigrator(FileSystemAbstraction fileSystem, PageCache pageCache, Config config) {
        super("Native label scan index");
        this.fileSystem = fileSystem;
        this.pageCache = pageCache;
        this.config = config;
    }

    @Override
    public void migrate(DatabaseLayout directoryLayout, DatabaseLayout migrationLayout, ProgressReporter progressReporter, String versionToMigrateFrom, String versionToMigrateTo) throws IOException {
        if (this.isNativeLabelScanStoreMigrationRequired(directoryLayout)) {
            StoreFactory storeFactory = this.getStoreFactory(directoryLayout, versionToMigrateFrom);
            try (NeoStores neoStores = storeFactory.openAllNeoStores();
                 Lifespan lifespan = new Lifespan(new Lifecycle[0]);){
                neoStores.verifyStoreOk();
                this.deleteNativeIndexFile(migrationLayout);
                progressReporter.start(neoStores.getNodeStore().getNumberOfIdsInUse());
                NativeLabelScanStore nativeLabelScanStore = this.getNativeLabelScanStore(migrationLayout, progressReporter, neoStores);
                lifespan.add(nativeLabelScanStore);
            }
            this.nativeLabelScanStoreMigrated = true;
        }
    }

    @Override
    public void moveMigratedFiles(DatabaseLayout migrationLayout, DatabaseLayout directoryLayout, String versionToUpgradeFrom, String versionToMigrateTo) throws IOException {
        if (this.nativeLabelScanStoreMigrated) {
            File nativeLabelIndex = migrationLayout.labelScanStore();
            this.moveNativeIndexFile(directoryLayout, nativeLabelIndex);
            this.deleteLuceneLabelIndex(NativeLabelScanStoreMigrator.getLuceneStoreDirectory(directoryLayout));
        }
    }

    private void deleteNativeIndexFile(DatabaseLayout directoryStructure) throws IOException {
        Optional indexFile = this.fileSystem.streamFilesRecursive(NativeLabelScanStore.getLabelScanStoreFile(directoryStructure)).findFirst();
        if (indexFile.isPresent()) {
            try {
                ((FileHandle)indexFile.get()).delete();
            }
            catch (NoSuchFileException noSuchFileException) {
                // empty catch block
            }
        }
    }

    private void moveNativeIndexFile(DatabaseLayout storeStructure, File nativeLabelIndex) throws IOException {
        Optional nativeIndexFileHandle = this.fileSystem.streamFilesRecursive(nativeLabelIndex).findFirst();
        if (nativeIndexFileHandle.isPresent()) {
            ((FileHandle)nativeIndexFileHandle.get()).rename(storeStructure.labelScanStore(), new CopyOption[0]);
        }
    }

    private NativeLabelScanStore getNativeLabelScanStore(DatabaseLayout migrationDirectoryStructure, ProgressReporter progressReporter, NeoStores neoStores) {
        NeoStoreIndexStoreView neoStoreIndexStoreView = new NeoStoreIndexStoreView(LockService.NO_LOCK_SERVICE, neoStores);
        return new NativeLabelScanStore(this.pageCache, migrationDirectoryStructure, this.fileSystem, new MonitoredFullLabelStream(neoStoreIndexStoreView, progressReporter), false, new Monitors(), RecoveryCleanupWorkCollector.immediate());
    }

    private StoreFactory getStoreFactory(DatabaseLayout directoryStructure, String versionToMigrateFrom) {
        NullLogProvider logProvider = NullLogProvider.getInstance();
        RecordFormats recordFormats = RecordFormatSelector.selectForVersion(versionToMigrateFrom);
        ReadOnlyIdGeneratorFactory idGeneratorFactory = new ReadOnlyIdGeneratorFactory(this.fileSystem);
        return new StoreFactory(directoryStructure, this.config, idGeneratorFactory, this.pageCache, this.fileSystem, recordFormats, (LogProvider)logProvider, EmptyVersionContextSupplier.EMPTY, new OpenOption[0]);
    }

    private boolean isNativeLabelScanStoreMigrationRequired(DatabaseLayout directoryStructure) throws IOException {
        return this.fileSystem.streamFilesRecursive(directoryStructure.labelScanStore()).noneMatch(Predicates.alwaysTrue());
    }

    private void deleteLuceneLabelIndex(File indexRootDirectory) throws IOException {
        this.fileSystem.deleteRecursively(indexRootDirectory);
    }

    private static File getLuceneStoreDirectory(DatabaseLayout directoryStructure) {
        return new File(new File(new File(directoryStructure.databaseDirectory(), "schema"), "label"), "lucene");
    }

    private static class MonitoredFullLabelStream
    extends FullLabelStream {
        private final ProgressReporter progressReporter;

        MonitoredFullLabelStream(IndexStoreView indexStoreView, ProgressReporter progressReporter) {
            super(indexStoreView);
            this.progressReporter = progressReporter;
        }

        @Override
        public boolean visit(NodeLabelUpdate update2) throws IOException {
            boolean visit2 = super.visit(update2);
            this.progressReporter.progress(1L);
            return visit2;
        }
    }
}

