/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.kvstore;

import java.io.File;
import java.io.IOException;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.impl.FileIsNotMappedException;
import org.neo4j.io.pagecache.tracing.cursor.context.VersionContextSupplier;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.store.kvstore.BigEndianByteArrayBuffer;
import org.neo4j.kernel.impl.store.kvstore.DataInitializer;
import org.neo4j.kernel.impl.store.kvstore.DataProvider;
import org.neo4j.kernel.impl.store.kvstore.DeadState;
import org.neo4j.kernel.impl.store.kvstore.EntryUpdater;
import org.neo4j.kernel.impl.store.kvstore.EntryVisitor;
import org.neo4j.kernel.impl.store.kvstore.HeaderField;
import org.neo4j.kernel.impl.store.kvstore.Headers;
import org.neo4j.kernel.impl.store.kvstore.KeyFormat;
import org.neo4j.kernel.impl.store.kvstore.KeyValueStoreFile;
import org.neo4j.kernel.impl.store.kvstore.KeyValueVisitor;
import org.neo4j.kernel.impl.store.kvstore.LockWrapper;
import org.neo4j.kernel.impl.store.kvstore.MetadataVisitor;
import org.neo4j.kernel.impl.store.kvstore.PreparedRotation;
import org.neo4j.kernel.impl.store.kvstore.ProgressiveFormat;
import org.neo4j.kernel.impl.store.kvstore.ProgressiveState;
import org.neo4j.kernel.impl.store.kvstore.ReadableBuffer;
import org.neo4j.kernel.impl.store.kvstore.Rotation;
import org.neo4j.kernel.impl.store.kvstore.RotationMonitor;
import org.neo4j.kernel.impl.store.kvstore.RotationState;
import org.neo4j.kernel.impl.store.kvstore.RotationStrategy;
import org.neo4j.kernel.impl.store.kvstore.RotationTimerFactory;
import org.neo4j.kernel.impl.store.kvstore.State;
import org.neo4j.kernel.impl.store.kvstore.UnknownKey;
import org.neo4j.kernel.impl.store.kvstore.UpdateLock;
import org.neo4j.kernel.impl.store.kvstore.ValueLookup;
import org.neo4j.kernel.impl.store.kvstore.WritableBuffer;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Logger;
import org.neo4j.util.FeatureToggles;

@State(value=State.Strategy.CONCURRENT_HASH_MAP)
public abstract class AbstractKeyValueStore<Key>
extends LifecycleAdapter {
    static final long MAX_LOOKUP_RETRY_COUNT = FeatureToggles.getLong(AbstractKeyValueStore.class, "maxLookupRetryCount", 1024L);
    private final UpdateLock updateLock = new UpdateLock();
    private final Format format;
    final RotationStrategy rotationStrategy;
    private final RotationTimerFactory rotationTimerFactory;
    private final Logger logger;
    volatile ProgressiveState<Key> state;
    private DataInitializer<EntryUpdater<Key>> stateInitializer;
    private final FileSystemAbstraction fs;
    final int keySize;
    final int valueSize;
    private volatile boolean stopped;

    public AbstractKeyValueStore(FileSystemAbstraction fs, PageCache pages, DatabaseLayout databaseLayout, RotationMonitor monitor, Logger logger, RotationTimerFactory timerFactory, VersionContextSupplier versionContextSupplier, int keySize, int valueSize, HeaderField<?> ... headerFields) {
        this.fs = fs;
        this.keySize = keySize;
        this.valueSize = valueSize;
        Rotation rotation = this.getClass().getAnnotation(Rotation.class);
        if (monitor == null) {
            monitor = RotationMonitor.NONE;
        }
        this.format = new Format(headerFields);
        this.logger = logger;
        this.rotationStrategy = rotation.value().create(fs, pages, this.format, monitor, databaseLayout);
        this.rotationTimerFactory = timerFactory;
        this.state = new DeadState.Stopped(this.format, this.getClass().getAnnotation(State.class).value(), versionContextSupplier);
    }

    protected final void setEntryUpdaterInitializer(DataInitializer<EntryUpdater<Key>> stateInitializer) {
        this.stateInitializer = stateInitializer;
    }

    public String toString() {
        return String.format("%s[state=%s, hasChanges=%s]", this.getClass().getSimpleName(), this.state, this.state.hasChanges());
    }

    protected final <Value> Value lookup(Key key, Reader<Value> reader) throws IOException {
        ValueLookup<Value> lookup2 = new ValueLookup<Value>(reader);
        for (long retriesLeft = MAX_LOOKUP_RETRY_COUNT; retriesLeft > 0L; --retriesLeft) {
            ProgressiveState<Key> originalState = this.state;
            try {
                return lookup2.value(!originalState.lookup(key, lookup2));
            }
            catch (FileIsNotMappedException e) {
                if (originalState != this.state) continue;
                throw e;
            }
        }
        throw new IOException(String.format("Failed to lookup `%s` in key value store, after %d retries", key, MAX_LOOKUP_RETRY_COUNT));
    }

    protected final void visitAll(Visitor visitor) throws IOException {
        ProgressiveState<Key> state = this.state;
        if (visitor instanceof MetadataVisitor) {
            ((MetadataVisitor)((Object)visitor)).visitMetadata(state.file(), this.headers(), state.storedEntryCount());
        }
        try (DataProvider provider = state.dataProvider();){
            this.transfer(provider, visitor);
        }
    }

    protected final void visitFile(File path, Visitor visitor) throws IOException {
        try (KeyValueStoreFile file = this.rotationStrategy.openStoreFile(path);){
            if (visitor instanceof MetadataVisitor) {
                ((MetadataVisitor)((Object)visitor)).visitMetadata(path, file.headers(), file.entryCount());
            }
            try (DataProvider provider = file.dataProvider();){
                this.transfer(provider, visitor);
            }
        }
    }

    protected abstract Key readKey(ReadableBuffer var1) throws UnknownKey;

    protected abstract void writeKey(Key var1, WritableBuffer var2);

    protected abstract void writeFormatSpecifier(WritableBuffer var1);

    protected abstract Headers initialHeaders(long var1);

    protected abstract int compareHeaders(Headers var1, Headers var2);

    protected boolean include(Key key, ReadableBuffer value2) {
        return true;
    }

    protected final Headers headers() {
        return this.state.headers();
    }

    public int totalEntriesStored() {
        return this.state.storedEntryCount();
    }

    public final File currentFile() {
        return this.state.file();
    }

    @Override
    public final void init() throws IOException {
        try (LockWrapper ignored = LockWrapper.writeLock(this.updateLock, this.logger);){
            this.state = this.state.initialize(this.rotationStrategy);
        }
    }

    @Override
    public final void start() throws IOException {
        try (LockWrapper ignored = LockWrapper.writeLock(this.updateLock, this.logger);){
            this.state = this.state.start(this.stateInitializer);
        }
    }

    protected final Optional<EntryUpdater<Key>> updater(long version) {
        try (LockWrapper lock = LockWrapper.readLock(this.updateLock, this.logger);){
            Optional optional2 = this.state.optionalUpdater(version, lock.get());
            return optional2;
        }
    }

    protected final EntryUpdater<Key> updater() {
        try (LockWrapper lock = LockWrapper.readLock(this.updateLock, this.logger);){
            EntryUpdater entryUpdater = this.state.unsafeUpdater(lock.get());
            return entryUpdater;
        }
    }

    protected final EntryUpdater<Key> resetter(long version) {
        try (LockWrapper lock = LockWrapper.writeLock(this.updateLock, this.logger);){
            ProgressiveState<Key> current = this.state;
            EntryUpdater<Key> entryUpdater = current.resetter(lock.get(), new RotationTask(version));
            return entryUpdater;
        }
    }

    protected final PreparedRotation prepareRotation(long version) {
        try (LockWrapper ignored = LockWrapper.writeLock(this.updateLock, this.logger);){
            ProgressiveState<Key> prior = this.state;
            if (prior.storedVersion() == version && !prior.hasChanges()) {
                PreparedRotation preparedRotation = () -> version;
                return preparedRotation;
            }
            RotationTask rotationTask = new RotationTask(version);
            return rotationTask;
        }
    }

    protected abstract void updateHeaders(Headers.Builder var1, long var2);

    @Override
    public final void shutdown() throws IOException {
        try (LockWrapper ignored = LockWrapper.writeLock(this.updateLock, this.logger);){
            this.stopped = true;
            this.state = this.state.stop();
        }
    }

    private boolean transfer(EntryVisitor<WritableBuffer> producer, EntryVisitor<ReadableBuffer> consumer) throws IOException {
        BigEndianByteArrayBuffer key = new BigEndianByteArrayBuffer(this.keySize);
        BigEndianByteArrayBuffer value2 = new BigEndianByteArrayBuffer(this.valueSize);
        while (producer.visit(key, value2)) {
            if (consumer.visit(key, value2)) continue;
            return false;
        }
        return true;
    }

    public Iterable<File> allFiles() {
        return StreamSupport.stream(this.rotationStrategy.candidateFiles().spliterator(), false).filter(arg_0 -> ((FileSystemAbstraction)this.fs).fileExists(arg_0)).collect(Collectors.toList());
    }

    private HeaderField<?>[] headerFieldsForFormat(ReadableBuffer formatSpecifier) {
        return this.format.defaultHeaderFieldsForFormat(formatSpecifier);
    }

    protected abstract long version(Headers var1);

    private final class Format
    extends ProgressiveFormat
    implements KeyFormat<Key> {
        Format(HeaderField<?> ... headerFields) {
            super(512, headerFields);
        }

        @Override
        protected void writeFormatSpecifier(WritableBuffer formatSpecifier) {
            AbstractKeyValueStore.this.writeFormatSpecifier(formatSpecifier);
        }

        @Override
        protected HeaderField<?>[] headerFieldsForFormat(ReadableBuffer formatSpecifier) {
            return AbstractKeyValueStore.this.headerFieldsForFormat(formatSpecifier);
        }

        HeaderField<?>[] defaultHeaderFieldsForFormat(ReadableBuffer formatSpecifier) {
            return super.headerFieldsForFormat(formatSpecifier);
        }

        @Override
        public void writeKey(Key key, WritableBuffer buffer) {
            AbstractKeyValueStore.this.writeKey(key, buffer);
        }

        @Override
        public int compareHeaders(Headers lhs, Headers rhs) {
            return AbstractKeyValueStore.this.compareHeaders(lhs, rhs);
        }

        @Override
        public Headers initialHeaders(long version) {
            return AbstractKeyValueStore.this.initialHeaders(version);
        }

        @Override
        public int keySize() {
            return AbstractKeyValueStore.this.keySize;
        }

        @Override
        public long version(Headers headers) {
            return AbstractKeyValueStore.this.version(headers);
        }

        @Override
        public DataProvider filter(final DataProvider provider) {
            return new DataProvider(){

                @Override
                public boolean visit(WritableBuffer key, WritableBuffer value2) throws IOException {
                    while (provider.visit(key, value2)) {
                        try {
                            if (!AbstractKeyValueStore.this.include(AbstractKeyValueStore.this.readKey(key), value2)) continue;
                            return true;
                        }
                        catch (UnknownKey e) {
                            throw new IllegalArgumentException(e.getMessage(), e);
                        }
                    }
                    return false;
                }

                @Override
                public void close() throws IOException {
                    provider.close();
                }
            };
        }

        @Override
        public int valueSize() {
            return AbstractKeyValueStore.this.valueSize;
        }
    }

    public abstract class Visitor
    implements KeyValueVisitor {
        @Override
        public boolean visit(ReadableBuffer key, ReadableBuffer value2) {
            try {
                return this.visitKeyValuePair(AbstractKeyValueStore.this.readKey(key), value2);
            }
            catch (UnknownKey e) {
                return this.visitUnknownKey(e, key, value2);
            }
        }

        protected boolean visitUnknownKey(UnknownKey exception, ReadableBuffer key, ReadableBuffer value2) {
            throw new IllegalArgumentException(exception.getMessage(), exception);
        }

        protected abstract boolean visitKeyValuePair(Key var1, ReadableBuffer var2);
    }

    public static abstract class Reader<Value> {
        protected abstract Value parseValue(ReadableBuffer var1);

        protected Value defaultValue() {
            return null;
        }
    }

    private class RotationTask
    implements PreparedRotation,
    Runnable {
        private final RotationState<Key> rotation;

        RotationTask(long version) {
            this.rotation = AbstractKeyValueStore.this.state.prepareRotation(version);
            AbstractKeyValueStore.this.state = this.rotation;
        }

        @Override
        public long rotate() throws IOException {
            return this.rotate(false);
        }

        @Override
        public void run() {
            try (LockWrapper ignored = LockWrapper.writeLock(AbstractKeyValueStore.this.updateLock, AbstractKeyValueStore.this.logger);){
                this.rotate(true);
            }
            catch (IOException e) {
                throw new UnderlyingStorageException(e);
            }
        }

        private long rotate(boolean force) throws IOException {
            Throwable throwable = null;
            try (RotationState rotation = this.rotation;){
                long version = rotation.rotationVersion();
                ProgressiveState next2 = rotation.rotate(force, AbstractKeyValueStore.this.rotationStrategy, AbstractKeyValueStore.this.rotationTimerFactory, value2 -> AbstractKeyValueStore.this.updateHeaders((Headers.Builder)value2, version));
                try (LockWrapper ignored = LockWrapper.writeLock(AbstractKeyValueStore.this.updateLock, AbstractKeyValueStore.this.logger);){
                    AbstractKeyValueStore.this.state = next2;
                }
                long l = version;
                return l;
            }
            catch (Throwable t) {
                try {
                    try (LockWrapper ignored = LockWrapper.writeLock(AbstractKeyValueStore.this.updateLock, AbstractKeyValueStore.this.logger);){
                        if (!AbstractKeyValueStore.this.stopped) {
                            AbstractKeyValueStore.this.state = rotation.markAsFailed();
                        }
                    }
                    throw t;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
    }
}

