/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Arrays;
import java.util.HashSet;
import org.neo4j.internal.kernel.api.IndexCapability;
import org.neo4j.internal.kernel.api.IndexLimitation;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexValueCapability;
import org.neo4j.values.storable.ValueCategory;

public class UnionIndexCapability
implements IndexCapability {
    private final Iterable<IndexCapability> capabilities;
    private final IndexLimitation[] limitationsUnion;

    protected UnionIndexCapability(Iterable<IndexCapability> capabilities) {
        this.capabilities = capabilities;
        this.limitationsUnion = this.limitationsUnion(capabilities);
    }

    public IndexOrder[] orderCapability(ValueCategory ... valueCategories) {
        HashSet<IndexOrder> orderCapability = new HashSet<IndexOrder>();
        for (IndexCapability capability : this.capabilities) {
            orderCapability.addAll(Arrays.asList(capability.orderCapability(valueCategories)));
        }
        return orderCapability.toArray(new IndexOrder[orderCapability.size()]);
    }

    public IndexValueCapability valueCapability(ValueCategory ... valueCategories) {
        IndexValueCapability currentBest = IndexValueCapability.NO;
        for (IndexCapability capability : this.capabilities) {
            IndexValueCapability next2 = capability.valueCapability(valueCategories);
            if (next2.compare(currentBest) <= 0) continue;
            currentBest = next2;
        }
        return currentBest;
    }

    public boolean isFulltextIndex() {
        return false;
    }

    public boolean isEventuallyConsistent() {
        return false;
    }

    public IndexLimitation[] limitations() {
        return this.limitationsUnion;
    }

    private IndexLimitation[] limitationsUnion(Iterable<IndexCapability> capabilities) {
        HashSet<IndexLimitation> union2 = new HashSet<IndexLimitation>();
        for (IndexCapability capability : capabilities) {
            union2.addAll(Arrays.asList(capability.limitations()));
        }
        return union2.toArray(new IndexLimitation[union2.size()]);
    }
}

