/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurveConfiguration;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexConfigProvider;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.index.schema.ConflictDetectingValueMerger;
import org.neo4j.kernel.impl.index.schema.NativeIndexPopulator;
import org.neo4j.kernel.impl.index.schema.NativeIndexReader;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.SpatialIndexCache;
import org.neo4j.kernel.impl.index.schema.SpatialIndexConfig;
import org.neo4j.kernel.impl.index.schema.SpatialIndexFiles;
import org.neo4j.kernel.impl.index.schema.SpatialIndexKey;
import org.neo4j.kernel.impl.index.schema.SpatialIndexPartReader;
import org.neo4j.kernel.impl.index.schema.SpatialIndexPopulatingUpdater;
import org.neo4j.kernel.impl.index.schema.SpatialVerifyDeferredConstraint;
import org.neo4j.kernel.impl.index.schema.ThrowingConflictDetector;
import org.neo4j.kernel.impl.index.schema.WorkSyncedNativeIndexPopulator;
import org.neo4j.kernel.impl.index.schema.config.SpaceFillingCurveSettings;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexBase;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexSampler;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.storageengine.api.schema.IndexSample;
import org.neo4j.storageengine.api.schema.StoreIndexDescriptor;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.Value;

class SpatialIndexPopulator
extends SpatialIndexCache<WorkSyncedNativeIndexPopulator<SpatialIndexKey, NativeIndexValue>>
implements IndexPopulator {
    SpatialIndexPopulator(StoreIndexDescriptor descriptor, SpatialIndexFiles spatialIndexFiles, PageCache pageCache, FileSystemAbstraction fs, IndexProvider.Monitor monitor, SpaceFillingCurveConfiguration configuration) {
        super(new PartFactory(pageCache, fs, spatialIndexFiles, descriptor, monitor, configuration));
    }

    @Override
    public synchronized void create() {
        FusionIndexBase.forAll(p -> p.getActual().clear(), this);
        if (!this.iterator().hasNext()) {
            this.select(CoordinateReferenceSystem.WGS84);
        }
    }

    @Override
    public synchronized void drop() {
        FusionIndexBase.forAll(IndexPopulator::drop, this);
    }

    @Override
    public void add(Collection<? extends IndexEntryUpdate<?>> updates) throws IndexEntryConflictException {
        HashMap<CoordinateReferenceSystem, List> batchMap = new HashMap<CoordinateReferenceSystem, List>();
        for (IndexEntryUpdate<?> indexEntryUpdate : updates) {
            PointValue point = (PointValue)indexEntryUpdate.values()[0];
            List batch = batchMap.computeIfAbsent(point.getCoordinateReferenceSystem(), k -> new ArrayList());
            batch.add(indexEntryUpdate);
        }
        for (Map.Entry entry : batchMap.entrySet()) {
            IndexPopulator partPopulator = (IndexPopulator)this.select((CoordinateReferenceSystem)entry.getKey());
            partPopulator.add((Collection)entry.getValue());
        }
    }

    @Override
    public void verifyDeferredConstraints(NodePropertyAccessor nodePropertyAccessor) throws IndexEntryConflictException {
        for (IndexPopulator part : this) {
            part.verifyDeferredConstraints(nodePropertyAccessor);
        }
    }

    @Override
    public IndexUpdater newPopulatingUpdater(NodePropertyAccessor accessor) {
        return new SpatialIndexPopulatingUpdater(this, accessor);
    }

    @Override
    public synchronized void close(boolean populationCompletedSuccessfully) {
        this.closeInstantiateCloseLock();
        for (IndexPopulator part : this) {
            part.close(populationCompletedSuccessfully);
        }
    }

    @Override
    public synchronized void markAsFailed(String failure) {
        for (IndexPopulator part : this) {
            part.markAsFailed(failure);
        }
    }

    @Override
    public void includeSample(IndexEntryUpdate<?> update2) {
        Value[] values2 = update2.values();
        assert (values2.length == 1);
        ((WorkSyncedNativeIndexPopulator)this.uncheckedSelect(((PointValue)values2[0]).getCoordinateReferenceSystem())).includeSample(update2);
    }

    @Override
    public IndexSample sampleResult() {
        ArrayList<IndexSample> samples = new ArrayList<IndexSample>();
        for (IndexPopulator partPopulator : this) {
            samples.add(partPopulator.sampleResult());
        }
        return FusionIndexSampler.combineSamples(samples);
    }

    @Override
    public Map<String, Value> indexConfig() {
        HashMap<String, Value> indexConfig = new HashMap<String, Value>();
        for (IndexPopulator part : this) {
            IndexConfigProvider.putAllNoOverwrite(indexConfig, part.indexConfig());
        }
        return indexConfig;
    }

    static class PartFactory
    implements SpatialIndexCache.Factory<WorkSyncedNativeIndexPopulator<SpatialIndexKey, NativeIndexValue>> {
        private final PageCache pageCache;
        private final FileSystemAbstraction fs;
        private final SpatialIndexFiles spatialIndexFiles;
        private final StoreIndexDescriptor descriptor;
        private final IndexProvider.Monitor monitor;
        private final SpaceFillingCurveConfiguration configuration;

        PartFactory(PageCache pageCache, FileSystemAbstraction fs, SpatialIndexFiles spatialIndexFiles, StoreIndexDescriptor descriptor, IndexProvider.Monitor monitor, SpaceFillingCurveConfiguration configuration) {
            this.pageCache = pageCache;
            this.fs = fs;
            this.spatialIndexFiles = spatialIndexFiles;
            this.descriptor = descriptor;
            this.monitor = monitor;
            this.configuration = configuration;
        }

        @Override
        public WorkSyncedNativeIndexPopulator<SpatialIndexKey, NativeIndexValue> newSpatial(CoordinateReferenceSystem crs) {
            return this.create(this.spatialIndexFiles.forCrs(crs).getLayoutForNewIndex());
        }

        private WorkSyncedNativeIndexPopulator<SpatialIndexKey, NativeIndexValue> create(SpatialIndexFiles.SpatialFileLayout fileLayout) {
            PartPopulator populator = new PartPopulator(this.pageCache, this.fs, fileLayout, this.monitor, this.descriptor, this.configuration);
            populator.create();
            return new WorkSyncedNativeIndexPopulator<SpatialIndexKey, NativeIndexValue>(populator);
        }
    }

    static class PartPopulator
    extends NativeIndexPopulator<SpatialIndexKey, NativeIndexValue> {
        private final SpaceFillingCurveConfiguration configuration;
        private final SpaceFillingCurveSettings settings;
        private final CoordinateReferenceSystem crs;

        PartPopulator(PageCache pageCache, FileSystemAbstraction fs, SpatialIndexFiles.SpatialFileLayout fileLayout, IndexProvider.Monitor monitor, StoreIndexDescriptor descriptor, SpaceFillingCurveConfiguration configuration) {
            super(pageCache, fs, fileLayout.getIndexFile(), fileLayout.layout, monitor, descriptor, GBPTree.NO_HEADER_WRITER);
            this.configuration = configuration;
            this.settings = fileLayout.settings;
            this.crs = fileLayout.spatialFile.crs;
        }

        @Override
        public void verifyDeferredConstraints(NodePropertyAccessor nodePropertyAccessor) throws IndexEntryConflictException {
            SpatialVerifyDeferredConstraint.verify(nodePropertyAccessor, this.layout, (GBPTree<SpatialIndexKey, NativeIndexValue>)this.tree, this.descriptor);
            super.verifyDeferredConstraints(nodePropertyAccessor);
        }

        @Override
        boolean canCheckConflictsWithoutStoreAccess() {
            return false;
        }

        @Override
        ConflictDetectingValueMerger<SpatialIndexKey, NativeIndexValue, Value[]> getMainConflictDetector() {
            return new ThrowingConflictDetector<SpatialIndexKey, NativeIndexValue>(true);
        }

        @Override
        NativeIndexReader<SpatialIndexKey, NativeIndexValue> newReader() {
            return new SpatialIndexPartReader<NativeIndexValue>(this.tree, this.layout, (IndexDescriptor)this.descriptor, this.configuration);
        }

        @Override
        public synchronized void create() {
            this.create(this.settings.headerWriter((byte)2));
        }

        @Override
        void markTreeAsOnline() {
            this.tree.checkpoint(IOLimiter.UNLIMITED, this.settings.headerWriter((byte)1));
        }

        @Override
        public Map<String, Value> indexConfig() {
            HashMap<String, Value> map2 = new HashMap<String, Value>();
            SpatialIndexConfig.addSpatialConfig(map2, this.crs, this.settings);
            return map2;
        }
    }
}

