/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.neo4j.kernel.impl.api.CommandVisitor;
import org.neo4j.kernel.impl.index.IndexEntityType;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.util.IoPrimitiveUtils;
import org.neo4j.storageengine.api.WritableChannel;

public abstract class IndexCommand
extends Command {
    public static final byte VALUE_TYPE_NULL = 0;
    public static final byte VALUE_TYPE_SHORT = 1;
    public static final byte VALUE_TYPE_INT = 2;
    public static final byte VALUE_TYPE_LONG = 3;
    public static final byte VALUE_TYPE_FLOAT = 4;
    public static final byte VALUE_TYPE_DOUBLE = 5;
    public static final byte VALUE_TYPE_STRING = 6;
    private byte commandType;
    protected int indexNameId;
    protected byte entityType;
    protected long entityId;
    protected int keyId;
    protected byte valueType;
    protected Object value;

    protected void init(byte commandType, int indexNameId, byte entityType, long entityId, int keyId, Object value2) {
        this.commandType = commandType;
        this.indexNameId = indexNameId;
        this.entityType = entityType;
        this.entityId = entityId;
        this.keyId = keyId;
        this.value = value2;
        this.valueType = IndexCommand.valueTypeOf(value2);
    }

    public int getIndexNameId() {
        return this.indexNameId;
    }

    public byte getEntityType() {
        return this.entityType;
    }

    public long getEntityId() {
        return this.entityId;
    }

    public int getKeyId() {
        return this.keyId;
    }

    public Object getValue() {
        return this.value;
    }

    public byte startNodeNeedsLong() {
        return 0;
    }

    public byte endNodeNeedsLong() {
        return 0;
    }

    private static byte valueTypeOf(Object value2) {
        int valueType = 0;
        valueType = value2 == null ? 0 : (value2 instanceof Number ? (value2 instanceof Float ? 4 : (value2 instanceof Double ? 5 : (value2 instanceof Long ? 3 : (value2 instanceof Short ? 1 : 2)))) : 6);
        return (byte)valueType;
    }

    protected void writeToFile(WritableChannel channel) throws IOException {
        this.writeIndexCommandHeader(channel);
        this.putIntOrLong(channel, this.getEntityId());
        Object value2 = this.getValue();
        switch (this.getValueType()) {
            case 6: {
                IoPrimitiveUtils.write3bLengthAndString(channel, value2.toString());
                break;
            }
            case 1: {
                channel.putShort(((Number)value2).shortValue());
                break;
            }
            case 2: {
                channel.putInt(((Number)value2).intValue());
                break;
            }
            case 3: {
                channel.putLong(((Number)value2).longValue());
                break;
            }
            case 4: {
                channel.putFloat(((Number)value2).floatValue());
                break;
            }
            case 5: {
                channel.putDouble(((Number)value2).doubleValue());
                break;
            }
            case 0: {
                break;
            }
            default: {
                throw new RuntimeException("Unknown value type " + this.getValueType());
            }
        }
    }

    protected void writeIndexCommandHeader(WritableChannel channel) throws IOException {
        IndexCommand.writeIndexCommandHeader(channel, this.getValueType(), this.getEntityType(), IndexCommand.needsLong(this.getEntityId()), this.startNodeNeedsLong(), this.endNodeNeedsLong(), this.getIndexNameId(), this.getKeyId());
    }

    protected static void writeIndexCommandHeader(WritableChannel channel, byte valueType, byte entityType, byte entityIdNeedsLong, byte startNodeNeedsLong, byte endNodeNeedsLong, int indexNameId, int keyId) throws IOException {
        channel.put((byte)(valueType << 2 | entityType << 1 | entityIdNeedsLong));
        channel.put((byte)(startNodeNeedsLong << 7 | endNodeNeedsLong << 6));
        channel.putShort((short)indexNameId);
        channel.putShort((short)keyId);
    }

    protected void putIntOrLong(WritableChannel channel, long id2) throws IOException {
        if (IndexCommand.needsLong(id2) == 1) {
            channel.putLong(id2);
        } else {
            channel.putInt((int)id2);
        }
    }

    protected static byte needsLong(long value2) {
        return value2 > Integer.MAX_VALUE ? (byte)1 : 0;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IndexCommand that = (IndexCommand)o;
        return this.commandType == that.commandType && this.indexNameId == that.indexNameId && this.entityType == that.entityType && this.entityId == that.entityId && this.keyId == that.keyId && this.valueType == that.valueType && Objects.equals(this.value, that.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.commandType, this.indexNameId, this.entityType, this.entityId, this.keyId, this.valueType, this.value);
    }

    public byte getCommandType() {
        return this.commandType;
    }

    public byte getValueType() {
        return this.valueType;
    }

    public static class CreateCommand
    extends IndexCommand {
        private Map<String, String> config;

        public void init(int indexNameId, byte entityType, Map<String, String> config) {
            super.init((byte)15, indexNameId, entityType, 0L, 0, null);
            this.config = config;
        }

        public Map<String, String> getConfig() {
            return this.config;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CreateCommand that = (CreateCommand)o;
            return Objects.equals(this.config, that.config);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.config);
        }

        @Override
        public boolean handle(CommandVisitor visitor) throws IOException {
            return visitor.visitIndexCreateCommand(this);
        }

        @Override
        public String toString() {
            return String.format("Create%sIndex[index:%d, config:%s]", IndexEntityType.byId(this.entityType).nameToLowerCase(), this.indexNameId, this.config);
        }

        public void serialize(WritableChannel channel) throws IOException {
            channel.put((byte)15);
            this.writeIndexCommandHeader(channel);
            channel.putShort((short)this.getConfig().size());
            for (Map.Entry<String, String> entry : this.getConfig().entrySet()) {
                IoPrimitiveUtils.write2bLengthAndString(channel, entry.getKey());
                IoPrimitiveUtils.write2bLengthAndString(channel, entry.getValue());
            }
        }
    }

    public static class DeleteCommand
    extends IndexCommand {
        public void init(int indexNameId, byte entityType) {
            super.init((byte)14, indexNameId, entityType, 0L, 0, null);
        }

        @Override
        public boolean handle(CommandVisitor visitor) throws IOException {
            return visitor.visitIndexDeleteCommand(this);
        }

        @Override
        public String toString() {
            return "Delete[index:" + this.indexNameId + ", type:" + IndexEntityType.byId(this.entityType).nameToLowerCase() + "]";
        }

        public void serialize(WritableChannel channel) throws IOException {
            channel.put((byte)14);
            this.writeIndexCommandHeader(channel);
        }
    }

    public static class RemoveCommand
    extends IndexCommand {
        public void init(int indexNameId, byte entityType, long entityId, int keyId, Object value2) {
            super.init((byte)13, indexNameId, entityType, entityId, keyId, value2);
        }

        @Override
        public boolean handle(CommandVisitor visitor) throws IOException {
            return visitor.visitIndexRemoveCommand(this);
        }

        @Override
        public String toString() {
            return String.format("Remove%s[index:%d, id:%d, key:%d, value:%s]", IndexEntityType.byId(this.entityType).nameToLowerCase(), this.indexNameId, this.entityId, this.keyId, this.value);
        }

        public void serialize(WritableChannel channel) throws IOException {
            channel.put((byte)13);
            this.writeToFile(channel);
        }
    }

    public static class AddRelationshipCommand
    extends IndexCommand {
        private long startNode;
        private long endNode;

        public void init(int indexNameId, long entityId, int keyId, Object value2, long startNode, long endNode) {
            super.init((byte)12, indexNameId, IndexEntityType.Relationship.id(), entityId, keyId, value2);
            this.startNode = startNode;
            this.endNode = endNode;
        }

        public long getStartNode() {
            return this.startNode;
        }

        public long getEndNode() {
            return this.endNode;
        }

        @Override
        public byte startNodeNeedsLong() {
            return AddRelationshipCommand.needsLong(this.startNode);
        }

        @Override
        public byte endNodeNeedsLong() {
            return AddRelationshipCommand.needsLong(this.endNode);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            AddRelationshipCommand that = (AddRelationshipCommand)o;
            return this.startNode == that.startNode && this.endNode == that.endNode;
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.startNode, this.endNode);
        }

        @Override
        public boolean handle(CommandVisitor visitor) throws IOException {
            return visitor.visitIndexAddRelationshipCommand(this);
        }

        @Override
        public String toString() {
            return "AddRelationship[index:" + this.indexNameId + ", id:" + this.entityId + ", key:" + this.keyId + ", value:" + this.value + "(" + (this.value != null ? this.value.getClass().getSimpleName() : "null") + "), startNode:" + this.startNode + ", endNode:" + this.endNode + "]";
        }

        public void serialize(WritableChannel channel) throws IOException {
            channel.put((byte)12);
            this.writeToFile(channel);
            this.putIntOrLong(channel, this.getStartNode());
            this.putIntOrLong(channel, this.getEndNode());
        }
    }

    public static class AddNodeCommand
    extends IndexCommand {
        public void init(int indexNameId, long entityId, int keyId, Object value2) {
            super.init((byte)11, indexNameId, IndexEntityType.Node.id(), entityId, keyId, value2);
        }

        @Override
        public boolean handle(CommandVisitor visitor) throws IOException {
            return visitor.visitIndexAddNodeCommand(this);
        }

        @Override
        public String toString() {
            return "AddNode[index:" + this.indexNameId + ", id:" + this.entityId + ", key:" + this.keyId + ", value:" + this.value + "]";
        }

        public void serialize(WritableChannel channel) throws IOException {
            channel.put((byte)11);
            this.writeToFile(channel);
        }
    }
}

