/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.block.function.primitive.LongToObjectFunction;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.map.primitive.MutableLongObjectMap;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.impl.map.mutable.primitive.LongObjectHashMap;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.event.LabelEntry;
import org.neo4j.graphdb.event.PropertyEntry;
import org.neo4j.graphdb.event.TransactionData;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.internal.kernel.api.exceptions.LabelNotFoundKernelException;
import org.neo4j.internal.kernel.api.exceptions.PropertyKeyIdNotFoundKernelException;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.core.EmbeddedProxySPI;
import org.neo4j.kernel.impl.core.NodeProxy;
import org.neo4j.kernel.impl.core.RelationshipProxy;
import org.neo4j.storageengine.api.RelationshipVisitor;
import org.neo4j.storageengine.api.StorageNodeCursor;
import org.neo4j.storageengine.api.StorageProperty;
import org.neo4j.storageengine.api.StoragePropertyCursor;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.StorageRelationshipScanCursor;
import org.neo4j.storageengine.api.txstate.LongDiffSets;
import org.neo4j.storageengine.api.txstate.NodeState;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;
import org.neo4j.storageengine.api.txstate.RelationshipState;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class TxStateTransactionDataSnapshot
implements TransactionData {
    private final ReadableTransactionState state;
    private final EmbeddedProxySPI proxySpi;
    private final StorageReader store;
    private final KernelTransaction transaction;
    private final Collection<PropertyEntry<Node>> assignedNodeProperties = new ArrayList<PropertyEntry<Node>>();
    private final Collection<PropertyEntry<Relationship>> assignedRelationshipProperties = new ArrayList<PropertyEntry<Relationship>>();
    private final Collection<LabelEntry> assignedLabels = new ArrayList<LabelEntry>();
    private final Collection<PropertyEntry<Node>> removedNodeProperties = new ArrayList<PropertyEntry<Node>>();
    private final Collection<PropertyEntry<Relationship>> removedRelationshipProperties = new ArrayList<PropertyEntry<Relationship>>();
    private final Collection<LabelEntry> removedLabels = new ArrayList<LabelEntry>();
    private final MutableLongObjectMap<RelationshipProxy> relationshipsReadFromStore = new LongObjectHashMap(16);

    public TxStateTransactionDataSnapshot(ReadableTransactionState state, EmbeddedProxySPI proxySpi, StorageReader storageReader, KernelTransaction transaction) {
        this.state = state;
        this.proxySpi = proxySpi;
        this.store = storageReader;
        this.transaction = transaction;
        this.takeSnapshot();
    }

    @Override
    public Iterable<Node> createdNodes() {
        return this.map2Nodes((LongIterable)this.state.addedAndRemovedNodes().getAdded());
    }

    @Override
    public Iterable<Node> deletedNodes() {
        return this.map2Nodes((LongIterable)this.state.addedAndRemovedNodes().getRemoved());
    }

    @Override
    public Iterable<Relationship> createdRelationships() {
        return this.map2Rels((LongIterable)this.state.addedAndRemovedRelationships().getAdded());
    }

    @Override
    public Iterable<Relationship> deletedRelationships() {
        return this.map2Rels((LongIterable)this.state.addedAndRemovedRelationships().getRemoved());
    }

    @Override
    public boolean isDeleted(Node node) {
        return this.state.nodeIsDeletedInThisTx(node.getId());
    }

    @Override
    public boolean isDeleted(Relationship relationship) {
        return this.state.relationshipIsDeletedInThisTx(relationship.getId());
    }

    @Override
    public Iterable<PropertyEntry<Node>> assignedNodeProperties() {
        return this.assignedNodeProperties;
    }

    @Override
    public Iterable<PropertyEntry<Node>> removedNodeProperties() {
        return this.removedNodeProperties;
    }

    @Override
    public Iterable<PropertyEntry<Relationship>> assignedRelationshipProperties() {
        return this.assignedRelationshipProperties;
    }

    @Override
    public Iterable<PropertyEntry<Relationship>> removedRelationshipProperties() {
        return this.removedRelationshipProperties;
    }

    @Override
    public String username() {
        return this.transaction.securityContext().subject().username();
    }

    @Override
    public Map<String, Object> metaData() {
        if (this.transaction instanceof KernelTransactionImplementation) {
            return ((KernelTransactionImplementation)this.transaction).getMetaData();
        }
        return Collections.emptyMap();
    }

    @Override
    public Iterable<LabelEntry> removedLabels() {
        return this.removedLabels;
    }

    @Override
    public Iterable<LabelEntry> assignedLabels() {
        return this.assignedLabels;
    }

    @Override
    public long getTransactionId() {
        return this.transaction.getTransactionId();
    }

    @Override
    public long getCommitTime() {
        return this.transaction.getCommitTime();
    }

    private void takeSnapshot() {
        try (StorageNodeCursor node = this.store.allocateNodeCursor();
             StoragePropertyCursor properties = this.store.allocatePropertyCursor();
             StorageRelationshipScanCursor relationship = this.store.allocateRelationshipScanCursor();){
            TokenRead tokenRead = this.transaction.tokenRead();
            this.state.addedAndRemovedNodes().getRemoved().each((LongProcedure & Serializable)nodeId -> {
                node.single(nodeId);
                if (node.next()) {
                    properties.init(node.propertiesReference());
                    while (properties.next()) {
                        try {
                            this.removedNodeProperties.add(new NodePropertyEntryView(nodeId, tokenRead.propertyKeyName(properties.propertyKey()), null, properties.propertyValue()));
                        }
                        catch (PropertyKeyIdNotFoundKernelException e) {
                            throw new IllegalStateException("Nonexisting properties was modified for node " + nodeId, e);
                        }
                    }
                    for (long labelId : node.labels()) {
                        try {
                            this.removedLabels.add(new LabelEntryView(nodeId, tokenRead.nodeLabelName(Math.toIntExact(labelId))));
                        }
                        catch (LabelNotFoundKernelException e) {
                            throw new IllegalStateException("Nonexisting label was modified for node " + nodeId, e);
                        }
                    }
                }
            });
            this.state.addedAndRemovedRelationships().getRemoved().each((LongProcedure & Serializable)relId -> {
                Relationship relationshipProxy = this.relationship(relId);
                relationship.single(relId);
                if (relationship.next()) {
                    properties.init(relationship.propertiesReference());
                    while (properties.next()) {
                        try {
                            this.removedRelationshipProperties.add(new RelationshipPropertyEntryView(relationshipProxy, tokenRead.propertyKeyName(properties.propertyKey()), null, properties.propertyValue()));
                        }
                        catch (PropertyKeyIdNotFoundKernelException e) {
                            throw new IllegalStateException("Nonexisting node properties was modified for relationship " + relId, e);
                        }
                    }
                }
            });
            for (NodeState nodeState : this.state.modifiedNodes()) {
                Iterator added = nodeState.addedAndChangedProperties();
                long nodeId2 = nodeState.getId();
                while (added.hasNext()) {
                    StorageProperty property = (StorageProperty)added.next();
                    this.assignedNodeProperties.add(new NodePropertyEntryView(nodeId2, tokenRead.propertyKeyName(property.propertyKeyId()), property.value(), this.committedValue(nodeState, property.propertyKeyId(), node, properties)));
                }
                nodeState.removedProperties().each((IntProcedure & Serializable)id2 -> {
                    try {
                        NodePropertyEntryView entryView = new NodePropertyEntryView(nodeId2, tokenRead.propertyKeyName(id2), null, this.committedValue(nodeState, id2, node, properties));
                        this.removedNodeProperties.add(entryView);
                    }
                    catch (PropertyKeyIdNotFoundKernelException e) {
                        throw new IllegalStateException("Nonexisting node properties was modified for node " + nodeId2, e);
                    }
                });
                LongDiffSets labels2 = nodeState.labelDiffSets();
                this.addLabelEntriesTo(nodeId2, labels2.getAdded(), this.assignedLabels);
                this.addLabelEntriesTo(nodeId2, labels2.getRemoved(), this.removedLabels);
            }
            for (RelationshipState relState : this.state.modifiedRelationships()) {
                Relationship relationshipProxy = this.relationship(relState.getId());
                Iterator added = relState.addedAndChangedProperties();
                while (added.hasNext()) {
                    StorageProperty property = (StorageProperty)added.next();
                    this.assignedRelationshipProperties.add(new RelationshipPropertyEntryView(relationshipProxy, tokenRead.propertyKeyName(property.propertyKeyId()), property.value(), this.committedValue(relState, property.propertyKeyId(), relationship, properties)));
                }
                relState.removedProperties().each((IntProcedure & Serializable)id2 -> {
                    try {
                        RelationshipPropertyEntryView entryView = new RelationshipPropertyEntryView(relationshipProxy, tokenRead.propertyKeyName(id2), null, this.committedValue(relState, id2, relationship, properties));
                        this.removedRelationshipProperties.add(entryView);
                    }
                    catch (PropertyKeyIdNotFoundKernelException e) {
                        throw new IllegalStateException("Nonexisting properties was modified for relationship " + relState.getId(), e);
                    }
                });
            }
        }
        catch (PropertyKeyIdNotFoundKernelException e) {
            throw new IllegalStateException("An entity that does not exist was modified.", e);
        }
    }

    private void addLabelEntriesTo(long nodeId, LongSet labelIds, Collection<LabelEntry> target) {
        labelIds.each((LongProcedure & Serializable)labelId -> {
            try {
                LabelEntryView labelEntryView = new LabelEntryView(nodeId, this.transaction.tokenRead().nodeLabelName(Math.toIntExact(labelId)));
                target.add(labelEntryView);
            }
            catch (LabelNotFoundKernelException e) {
                throw new IllegalStateException("Nonexisting label was modified for node " + nodeId, e);
            }
        });
    }

    private Relationship relationship(long relId) {
        RelationshipProxy relationship = this.proxySpi.newRelationshipProxy(relId);
        if (!this.state.relationshipVisit(relId, (RelationshipVisitor)relationship)) {
            RelationshipProxy cached = (RelationshipProxy)this.relationshipsReadFromStore.get(relId);
            if (cached != null) {
                return cached;
            }
            try {
                this.store.relationshipVisit(relId, (RelationshipVisitor)relationship);
                this.relationshipsReadFromStore.put(relId, (Object)relationship);
            }
            catch (EntityNotFoundException e) {
                throw new IllegalStateException("Getting deleted relationship data should have been covered by the tx state", e);
            }
        }
        return relationship;
    }

    private Iterable<Node> map2Nodes(LongIterable ids) {
        return ids.asLazy().collect((LongToObjectFunction & Serializable)id2 -> new NodeProxy(this.proxySpi, id2));
    }

    private Iterable<Relationship> map2Rels(LongIterable ids) {
        return ids.asLazy().collect(this::relationship);
    }

    private Value committedValue(NodeState nodeState, int property, StorageNodeCursor node, StoragePropertyCursor properties) {
        if (this.state.nodeIsAddedInThisTx(nodeState.getId())) {
            return Values.NO_VALUE;
        }
        node.single(nodeState.getId());
        if (!node.next()) {
            return Values.NO_VALUE;
        }
        return this.committedValue(properties, node.propertiesReference(), property);
    }

    private Value committedValue(StoragePropertyCursor properties, long propertiesReference, int propertyKey) {
        properties.init(propertiesReference);
        while (properties.next()) {
            if (properties.propertyKey() != propertyKey) continue;
            return properties.propertyValue();
        }
        return Values.NO_VALUE;
    }

    private Value committedValue(RelationshipState relState, int property, StorageRelationshipScanCursor relationship, StoragePropertyCursor properties) {
        if (this.state.relationshipIsAddedInThisTx(relState.getId())) {
            return Values.NO_VALUE;
        }
        relationship.single(relState.getId());
        if (!relationship.next()) {
            return Values.NO_VALUE;
        }
        return this.committedValue(properties, relationship.propertiesReference(), property);
    }

    private class LabelEntryView
    implements LabelEntry {
        private final long nodeId;
        private final Label label;

        LabelEntryView(long nodeId, String labelName) {
            this.nodeId = nodeId;
            this.label = Label.label(labelName);
        }

        @Override
        public Label label() {
            return this.label;
        }

        @Override
        public Node node() {
            return new NodeProxy(TxStateTransactionDataSnapshot.this.proxySpi, this.nodeId);
        }

        public String toString() {
            return "LabelEntryView{nodeId=" + this.nodeId + ", label=" + this.label + '}';
        }
    }

    private static class RelationshipPropertyEntryView
    implements PropertyEntry<Relationship> {
        private final Relationship relationship;
        private final String key;
        private final Value newValue;
        private final Value oldValue;

        RelationshipPropertyEntryView(Relationship relationship, String key, Value newValue, Value oldValue) {
            this.relationship = relationship;
            this.key = key;
            this.newValue = newValue;
            this.oldValue = oldValue;
        }

        @Override
        public Relationship entity() {
            return this.relationship;
        }

        @Override
        public String key() {
            return this.key;
        }

        @Override
        public Object previouslyCommitedValue() {
            return this.oldValue.asObjectCopy();
        }

        @Override
        public Object value() {
            if (this.newValue == null || this.newValue == Values.NO_VALUE) {
                throw new IllegalStateException("This property has been removed, it has no value anymore: " + this);
            }
            return this.newValue.asObjectCopy();
        }

        public String toString() {
            return "RelationshipPropertyEntryView{relId=" + this.relationship.getId() + ", key='" + this.key + '\'' + ", newValue=" + this.newValue + ", oldValue=" + this.oldValue + '}';
        }
    }

    private class NodePropertyEntryView
    implements PropertyEntry<Node> {
        private final long nodeId;
        private final String key;
        private final Value newValue;
        private final Value oldValue;

        NodePropertyEntryView(long nodeId, String key, Value newValue, Value oldValue) {
            this.nodeId = nodeId;
            this.key = key;
            this.newValue = newValue;
            this.oldValue = oldValue;
        }

        @Override
        public Node entity() {
            return new NodeProxy(TxStateTransactionDataSnapshot.this.proxySpi, this.nodeId);
        }

        @Override
        public String key() {
            return this.key;
        }

        @Override
        public Object previouslyCommitedValue() {
            return this.oldValue.asObjectCopy();
        }

        @Override
        public Object value() {
            if (this.newValue == null || this.newValue == Values.NO_VALUE) {
                throw new IllegalStateException("This property has been removed, it has no value anymore: " + this);
            }
            return this.newValue.asObjectCopy();
        }

        public String toString() {
            return "NodePropertyEntryView{nodeId=" + this.nodeId + ", key='" + this.key + '\'' + ", newValue=" + this.newValue + ", oldValue=" + this.oldValue + '}';
        }
    }
}

