/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.dbms;

import org.neo4j.collection.RawIterator;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.api.ResourceTracker;
import org.neo4j.kernel.api.dbms.DbmsOperations;
import org.neo4j.kernel.api.proc.BasicContext;
import org.neo4j.kernel.api.proc.Context;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.kernel.internal.GraphDatabaseAPI;

public class NonTransactionalDbmsOperations
implements DbmsOperations {
    private final Procedures procedures;

    public NonTransactionalDbmsOperations(Procedures procedures) {
        this.procedures = procedures;
    }

    @Override
    public RawIterator<Object[], ProcedureException> procedureCallDbms(QualifiedName name, Object[] input2, DependencyResolver dependencyResolver, SecurityContext securityContext, ResourceTracker resourceTracker, ProcedureCallContext procedureCallContext) throws ProcedureException {
        BasicContext ctx = NonTransactionalDbmsOperations.createContext(securityContext, dependencyResolver, procedureCallContext);
        return this.procedures.callProcedure((Context)ctx, name, input2, resourceTracker);
    }

    @Override
    public RawIterator<Object[], ProcedureException> procedureCallDbms(int id2, Object[] input2, DependencyResolver dependencyResolver, SecurityContext securityContext, ResourceTracker resourceTracker, ProcedureCallContext procedureCallContext) throws ProcedureException {
        BasicContext ctx = NonTransactionalDbmsOperations.createContext(securityContext, dependencyResolver, procedureCallContext);
        return this.procedures.callProcedure((Context)ctx, id2, input2, resourceTracker);
    }

    private static BasicContext createContext(SecurityContext securityContext, DependencyResolver dependencyResolver, ProcedureCallContext procedureCallContext) {
        BasicContext ctx = new BasicContext();
        ctx.put(Context.SECURITY_CONTEXT, securityContext);
        ctx.put(Context.PROCEDURE_CALL_CONTEXT, procedureCallContext);
        ctx.put(Context.DEPENDENCY_RESOLVER, dependencyResolver);
        ctx.put(Context.DATABASE_API, dependencyResolver.resolveDependency(GraphDatabaseAPI.class));
        return ctx;
    }
}

