/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.neo4j.kernel.impl.api.CountsAccessor;
import org.neo4j.kernel.impl.api.CountsVisitor;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordState;
import org.neo4j.kernel.impl.store.counts.keys.CountsKey;
import org.neo4j.kernel.impl.store.counts.keys.CountsKeyFactory;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.register.Register;
import org.neo4j.register.Registers;
import org.neo4j.storageengine.api.StorageCommand;

public class CountsRecordState
implements CountsAccessor,
RecordState,
CountsAccessor.Updater,
CountsAccessor.IndexStatsUpdater {
    private static final long DEFAULT_FIRST_VALUE = 0L;
    private static final long DEFAULT_SECOND_VALUE = 0L;
    private final Map<CountsKey, Register.DoubleLongRegister> counts = new HashMap<CountsKey, Register.DoubleLongRegister>();

    @Override
    public Register.DoubleLongRegister nodeCount(int labelId, Register.DoubleLongRegister target) {
        this.counts(CountsKeyFactory.nodeKey(labelId)).copyTo(target);
        return target;
    }

    @Override
    public void incrementNodeCount(long labelId, long delta) {
        this.counts(CountsKeyFactory.nodeKey(labelId)).increment(0L, delta);
    }

    @Override
    public Register.DoubleLongRegister relationshipCount(int startLabelId, int typeId, int endLabelId, Register.DoubleLongRegister target) {
        this.counts(CountsKeyFactory.relationshipKey(startLabelId, typeId, endLabelId)).copyTo(target);
        return target;
    }

    @Override
    public Register.DoubleLongRegister indexSample(long indexId, Register.DoubleLongRegister target) {
        this.counts(CountsKeyFactory.indexSampleKey(indexId)).copyTo(target);
        return target;
    }

    @Override
    public void incrementRelationshipCount(long startLabelId, int typeId, long endLabelId, long delta) {
        if (delta != 0L) {
            this.counts(CountsKeyFactory.relationshipKey(startLabelId, typeId, endLabelId)).increment(0L, delta);
        }
    }

    @Override
    public Register.DoubleLongRegister indexUpdatesAndSize(long indexId, Register.DoubleLongRegister target) {
        this.counts(CountsKeyFactory.indexStatisticsKey(indexId)).copyTo(target);
        return target;
    }

    @Override
    public void replaceIndexUpdateAndSize(long indexId, long updates, long size2) {
        this.counts(CountsKeyFactory.indexStatisticsKey(indexId)).write(updates, size2);
    }

    @Override
    public void incrementIndexUpdates(long indexId, long delta) {
        this.counts(CountsKeyFactory.indexStatisticsKey(indexId)).increment(delta, 0L);
    }

    @Override
    public void replaceIndexSample(long indexId, long unique, long size2) {
        this.counts(CountsKeyFactory.indexSampleKey(indexId)).write(unique, size2);
    }

    @Override
    public void close() {
    }

    @Override
    public void accept(CountsVisitor visitor) {
        for (Map.Entry<CountsKey, Register.DoubleLongRegister> entry : this.counts.entrySet()) {
            Register.DoubleLongRegister register = entry.getValue();
            entry.getKey().accept(visitor, register.readFirst(), register.readSecond());
        }
    }

    @Override
    public void extractCommands(Collection<StorageCommand> target) {
        this.accept(new CommandCollector(target));
    }

    public List<Difference> verify(CountsVisitor.Visitable visitable) {
        Verifier verifier = new Verifier(this.counts);
        visitable.accept(verifier);
        return verifier.differences();
    }

    @Override
    public boolean hasChanges() {
        return !this.counts.isEmpty();
    }

    public void addNode(long[] labels2) {
        this.incrementNodeCount(-1L, 1L);
        for (long label : labels2) {
            this.incrementNodeCount((int)label, 1L);
        }
    }

    public void addRelationship(long[] startLabels, int type, long[] endLabels) {
        this.incrementRelationshipCount(-1L, -1, -1L, 1L);
        this.incrementRelationshipCount(-1L, type, -1L, 1L);
        for (long startLabelId : startLabels) {
            this.incrementRelationshipCount((int)startLabelId, -1, -1L, 1L);
            this.incrementRelationshipCount((int)startLabelId, type, -1L, 1L);
        }
        for (long endLabelId : endLabels) {
            this.incrementRelationshipCount(-1L, -1, (int)endLabelId, 1L);
            this.incrementRelationshipCount(-1L, type, (int)endLabelId, 1L);
        }
    }

    private Register.DoubleLongRegister counts(CountsKey key) {
        return this.counts.computeIfAbsent(key, k -> Registers.newDoubleLongRegister(0L, 0L));
    }

    private static class Verifier
    implements CountsVisitor {
        private final Map<CountsKey, Register.DoubleLongRegister> counts;
        private final List<Difference> differences = new ArrayList<Difference>();

        Verifier(Map<CountsKey, Register.DoubleLongRegister> counts) {
            this.counts = new HashMap<CountsKey, Register.DoubleLongRegister>(counts);
        }

        @Override
        public void visitNodeCount(int labelId, long count2) {
            this.verify(CountsKeyFactory.nodeKey(labelId), 0L, count2);
        }

        @Override
        public void visitRelationshipCount(int startLabelId, int typeId, int endLabelId, long count2) {
            this.verify(CountsKeyFactory.relationshipKey(startLabelId, typeId, endLabelId), 0L, count2);
        }

        @Override
        public void visitIndexStatistics(long indexId, long updates, long size2) {
            this.verify(CountsKeyFactory.indexStatisticsKey(indexId), updates, size2);
        }

        @Override
        public void visitIndexSample(long indexId, long unique, long size2) {
            this.verify(CountsKeyFactory.indexSampleKey(indexId), unique, size2);
        }

        private void verify(CountsKey key, long actualFirst, long actualSecond) {
            Register.DoubleLongRegister expected = this.counts.remove(key);
            if (expected == null) {
                if (actualFirst != 0L || actualSecond != 0L) {
                    this.differences.add(new Difference(key, 0L, 0L, actualFirst, actualSecond));
                }
            } else {
                long expectedFirst = expected.readFirst();
                long expectedSecond = expected.readSecond();
                if (expectedFirst != actualFirst || expectedSecond != actualSecond) {
                    this.differences.add(new Difference(key, expectedFirst, expectedSecond, actualFirst, actualSecond));
                }
            }
        }

        public List<Difference> differences() {
            for (Map.Entry<CountsKey, Register.DoubleLongRegister> entry : this.counts.entrySet()) {
                Register.DoubleLongRegister value2 = entry.getValue();
                this.differences.add(new Difference(entry.getKey(), value2.readFirst(), value2.readSecond(), 0L, 0L));
            }
            this.counts.clear();
            return this.differences;
        }
    }

    private static class CommandCollector
    extends CountsVisitor.Adapter {
        private final Collection<StorageCommand> commands;

        CommandCollector(Collection<StorageCommand> commands) {
            this.commands = commands;
        }

        @Override
        public void visitNodeCount(int labelId, long count2) {
            if (count2 != 0L) {
                this.commands.add(new Command.NodeCountsCommand(labelId, count2));
            }
        }

        @Override
        public void visitRelationshipCount(int startLabelId, int typeId, int endLabelId, long count2) {
            if (count2 != 0L) {
                this.commands.add(new Command.RelationshipCountsCommand(startLabelId, typeId, endLabelId, count2));
            }
        }
    }

    public static final class Difference {
        private final CountsKey key;
        private final long expectedFirst;
        private final long expectedSecond;
        private final long actualFirst;
        private final long actualSecond;

        public Difference(CountsKey key, long expectedFirst, long expectedSecond, long actualFirst, long actualSecond) {
            this.expectedFirst = expectedFirst;
            this.expectedSecond = expectedSecond;
            this.actualFirst = actualFirst;
            this.actualSecond = actualSecond;
            this.key = Objects.requireNonNull(key, "key");
        }

        public String toString() {
            return String.format("%s[%s expected=%d:%d, actual=%d:%d]", this.getClass().getSimpleName(), this.key, this.expectedFirst, this.expectedSecond, this.actualFirst, this.actualSecond);
        }

        public CountsKey key() {
            return this.key;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Difference) {
                Difference that = (Difference)obj;
                return this.actualFirst == that.actualFirst && this.expectedFirst == that.expectedFirst && this.actualSecond == that.actualSecond && this.expectedSecond == that.expectedSecond && this.key.equals(that.key);
            }
            return false;
        }

        public int hashCode() {
            int result2 = this.key.hashCode();
            result2 = 31 * result2 + (int)(this.expectedFirst ^ this.expectedFirst >>> 32);
            result2 = 31 * result2 + (int)(this.expectedSecond ^ this.expectedSecond >>> 32);
            result2 = 31 * result2 + (int)(this.actualFirst ^ this.actualFirst >>> 32);
            result2 = 31 * result2 + (int)(this.actualSecond ^ this.actualSecond >>> 32);
            return result2;
        }
    }
}

