/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.logging;

import java.util.regex.Pattern;
import org.neo4j.driver.internal.shaded.io.netty.util.internal.logging.AbstractInternalLogger;
import org.neo4j.driver.v1.Logger;

public class NettyLogger
extends AbstractInternalLogger {
    private Logger log;
    private static final Pattern PLACE_HOLDER_PATTERN = Pattern.compile("\\{\\}");

    public NettyLogger(String name, Logger log) {
        super(name);
        this.log = log;
    }

    @Override
    public boolean isTraceEnabled() {
        return this.log.isTraceEnabled();
    }

    @Override
    public void trace(String msg) {
        this.log.trace(msg, new Object[0]);
    }

    @Override
    public void trace(String format2, Object arg) {
        this.log.trace(this.toDriverLoggerFormat(format2), arg);
    }

    @Override
    public void trace(String format2, Object argA, Object argB) {
        this.log.trace(this.toDriverLoggerFormat(format2), argA, argB);
    }

    @Override
    public void trace(String format2, Object ... arguments2) {
        this.log.trace(this.toDriverLoggerFormat(format2), arguments2);
    }

    @Override
    public void trace(String msg, Throwable t) {
        this.log.trace("%s%n%s", msg, t);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    @Override
    public void debug(String msg) {
        this.log.debug(msg, new Object[0]);
    }

    @Override
    public void debug(String format2, Object arg) {
        this.log.debug(this.toDriverLoggerFormat(format2), arg);
    }

    @Override
    public void debug(String format2, Object argA, Object argB) {
        this.log.debug(this.toDriverLoggerFormat(format2), argA, argB);
    }

    @Override
    public void debug(String format2, Object ... arguments2) {
        this.log.debug(this.toDriverLoggerFormat(format2), arguments2);
    }

    @Override
    public void debug(String msg, Throwable t) {
        this.log.debug("%s%n%s", msg, t);
    }

    @Override
    public boolean isInfoEnabled() {
        return true;
    }

    @Override
    public void info(String msg) {
        this.log.info(msg, new Object[0]);
    }

    @Override
    public void info(String format2, Object arg) {
        this.log.info(this.toDriverLoggerFormat(format2), arg);
    }

    @Override
    public void info(String format2, Object argA, Object argB) {
        this.log.info(this.toDriverLoggerFormat(format2), argA, argB);
    }

    @Override
    public void info(String format2, Object ... arguments2) {
        this.log.info(this.toDriverLoggerFormat(format2), arguments2);
    }

    @Override
    public void info(String msg, Throwable t) {
        this.log.info("%s%n%s", msg, t);
    }

    @Override
    public boolean isWarnEnabled() {
        return true;
    }

    @Override
    public void warn(String msg) {
        this.log.warn(msg, new Object[0]);
    }

    @Override
    public void warn(String format2, Object arg) {
        this.log.warn(this.toDriverLoggerFormat(format2), arg);
    }

    @Override
    public void warn(String format2, Object ... arguments2) {
        this.log.warn(this.toDriverLoggerFormat(format2), arguments2);
    }

    @Override
    public void warn(String format2, Object argA, Object argB) {
        this.log.warn(this.toDriverLoggerFormat(format2), argA, argB);
    }

    @Override
    public void warn(String msg, Throwable t) {
        this.log.warn("%s%n%s", msg, t);
    }

    @Override
    public boolean isErrorEnabled() {
        return true;
    }

    @Override
    public void error(String msg) {
        this.log.error(msg, null);
    }

    @Override
    public void error(String format2, Object arg) {
        this.error(format2, new Object[]{arg});
    }

    @Override
    public void error(String format2, Object argA, Object argB) {
        this.error(format2, new Object[]{argA, argB});
    }

    @Override
    public void error(String format2, Object ... arguments2) {
        format2 = this.toDriverLoggerFormat(format2);
        if (arguments2.length == 0) {
            this.log.error(format2, null);
            return;
        }
        Object arg = arguments2[arguments2.length - 1];
        if (arg instanceof Throwable) {
            this.log.error(String.format(format2, arguments2), (Throwable)arg);
        }
    }

    @Override
    public void error(String msg, Throwable t) {
        this.log.error(msg, t);
    }

    private String toDriverLoggerFormat(String format2) {
        return PLACE_HOLDER_PATTERN.matcher(format2).replaceAll("%s");
    }
}

