/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.RelationshipDataAccessor;
import org.neo4j.kernel.impl.api.RelationshipVisitor;
import org.neo4j.kernel.impl.newapi.DefaultCursors;
import org.neo4j.kernel.impl.newapi.Read;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;

abstract class RelationshipCursor
extends RelationshipRecord
implements RelationshipDataAccessor,
RelationshipVisitor<RuntimeException> {
    private boolean hasChanges;
    private boolean checkHasChanges;
    private PropertyCursor propertyCursor;
    final DefaultCursors pool;
    Read read;

    RelationshipCursor(DefaultCursors pool) {
        super(-1L);
        this.pool = pool;
    }

    protected void init(Read read) {
        this.read = read;
        this.checkHasChanges = true;
    }

    public long relationshipReference() {
        return this.getId();
    }

    public int type() {
        return this.getType();
    }

    public boolean hasProperties() {
        if (this.read.hasTxStateWithChanges()) {
            PropertyCursor cursor = this.propertyCursor();
            this.properties(cursor);
            return cursor.next();
        }
        return this.nextProp != -1L;
    }

    public void source(NodeCursor cursor) {
        this.read.singleNode(this.sourceNodeReference(), cursor);
    }

    public void target(NodeCursor cursor) {
        this.read.singleNode(this.targetNodeReference(), cursor);
    }

    public void properties(PropertyCursor cursor) {
        this.read.relationshipProperties(this.relationshipReference(), this.propertiesReference(), cursor);
    }

    public long sourceNodeReference() {
        return this.getFirstNode();
    }

    public long targetNodeReference() {
        return this.getSecondNode();
    }

    public long propertiesReference() {
        return this.getNextProp();
    }

    protected abstract void collectAddedTxStateSnapshot();

    protected boolean hasChanges() {
        if (this.checkHasChanges) {
            this.hasChanges = this.read.hasTxStateWithChanges();
            if (this.hasChanges) {
                this.collectAddedTxStateSnapshot();
            }
            this.checkHasChanges = false;
        }
        return this.hasChanges;
    }

    void loadFromTxState(long reference) {
        this.read.txState().relationshipVisit(reference, this);
    }

    @Override
    public void visit(long relationshipId, int typeId, long startNodeId, long endNodeId) {
        this.setId(relationshipId);
        this.initialize(true, -1L, startNodeId, endNodeId, typeId, -1L, -1L, -1L, -1L, false, false);
    }

    private PropertyCursor propertyCursor() {
        if (this.propertyCursor == null) {
            this.propertyCursor = this.pool.allocatePropertyCursor();
        }
        return this.propertyCursor;
    }

    void close() {
        if (this.propertyCursor != null) {
            this.propertyCursor.close();
            this.propertyCursor = null;
        }
    }
}

