/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.admin.security;

import java.io.File;
import java.nio.file.Path;
import org.neo4j.commandline.admin.AdminCommand;
import org.neo4j.commandline.admin.CommandFailed;
import org.neo4j.commandline.admin.IncorrectUsage;
import org.neo4j.commandline.admin.OutsideWorld;
import org.neo4j.commandline.arguments.Arguments;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.security.Credential;
import org.neo4j.kernel.impl.security.User;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.server.security.auth.CommunitySecurityModule;
import org.neo4j.server.security.auth.FileUserRepository;

public class SetInitialPasswordCommand
implements AdminCommand {
    private static final Arguments arguments = new Arguments().withMandatoryPositionalArgument(0, "password");
    private final Path homeDir;
    private final Path configDir;
    private OutsideWorld outsideWorld;

    SetInitialPasswordCommand(Path homeDir, Path configDir, OutsideWorld outsideWorld) {
        this.homeDir = homeDir;
        this.configDir = configDir;
        this.outsideWorld = outsideWorld;
    }

    public static Arguments arguments() {
        return arguments;
    }

    public void execute(String[] args) throws IncorrectUsage, CommandFailed {
        try {
            this.setPassword(arguments.parse(args).get(0));
        }
        catch (CommandFailed | IncorrectUsage e) {
            throw e;
        }
        catch (Throwable throwable) {
            throw new CommandFailed(throwable.getMessage(), (Throwable)new RuntimeException(throwable));
        }
    }

    private void setPassword(String password) throws Throwable {
        Config config = this.loadNeo4jConfig();
        FileSystemAbstraction fileSystem = this.outsideWorld.fileSystem();
        File authFile = CommunitySecurityModule.getUserRepositoryFile(config);
        if (this.realUsersExist(authFile)) {
            throw new CommandFailed(this.realUsersExistErrorMsg(fileSystem, authFile));
        }
        File file = CommunitySecurityModule.getInitialUserRepositoryFile(config);
        if (fileSystem.fileExists(file)) {
            fileSystem.deleteFile(file);
        }
        FileUserRepository userRepository = new FileUserRepository(fileSystem, file, (LogProvider)NullLogProvider.getInstance());
        userRepository.start();
        userRepository.create(new User.Builder("ongdb", Credential.forPassword((String)password)).withRequiredPasswordChange(false).build());
        userRepository.shutdown();
        this.outsideWorld.stdOutLine("Changed password for user 'ongdb'.");
    }

    private boolean realUsersExist(File authFile) {
        return this.outsideWorld.fileSystem().fileExists(authFile);
    }

    private String realUsersExistErrorMsg(FileSystemAbstraction fileSystem, File authFile) {
        File parentFile = authFile.getParentFile();
        File roles = new File(parentFile, "roles");
        String files = fileSystem.fileExists(roles) ? "`auth` and `roles` files" : "`auth` file";
        return "the provided initial password was not set because existing ONgDB users were detected at `" + authFile.getAbsolutePath() + "`. Please remove the existing " + files + " if you want to reset your database to only have a default user with the provided password.";
    }

    Config loadNeo4jConfig() {
        return Config.fromFile((File)this.configDir.resolve("ongdb.conf").toFile()).withHome(this.homeDir.toFile()).withConnectorsDisabled().build();
    }
}

