/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.admin;

import java.io.Console;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import org.neo4j.commandline.admin.OutsideWorld;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.FileSystemAbstraction;

public class ParameterisedOutsideWorld
implements OutsideWorld {
    private final PrintStream stdout;
    private final PrintStream stderr;
    private final Console console;
    private final InputStream stdin;
    private final FileSystemAbstraction fileSystemAbstraction;

    public ParameterisedOutsideWorld(Console console, OutputStream stdout, OutputStream stderr, InputStream stdin, FileSystemAbstraction fileSystemAbstraction) {
        this.stdout = new PrintStream(stdout);
        this.stderr = new PrintStream(stderr);
        this.stdin = stdin;
        this.fileSystemAbstraction = fileSystemAbstraction;
        this.console = console;
    }

    @Override
    public void stdOutLine(String text) {
        this.stdout.println(text);
    }

    @Override
    public void stdErrLine(String text) {
        this.stderr.println(text);
    }

    @Override
    public String readLine() {
        return this.console.readLine();
    }

    @Override
    public String promptLine(String fmt, Object ... args) {
        return this.console.readLine(fmt, args);
    }

    @Override
    public char[] promptPassword(String fmt, Object ... args) {
        return this.console.readPassword(fmt, args);
    }

    @Override
    public void exit(int status) {
        IOUtils.closeAllSilently((AutoCloseable[])new ParameterisedOutsideWorld[]{this});
    }

    @Override
    public void printStacktrace(Exception exception) {
        exception.printStackTrace(this.stderr);
    }

    @Override
    public FileSystemAbstraction fileSystem() {
        return this.fileSystemAbstraction;
    }

    @Override
    public PrintStream errorStream() {
        return this.stderr;
    }

    @Override
    public PrintStream outStream() {
        return this.stdout;
    }

    @Override
    public InputStream inStream() {
        return this.stdin;
    }

    @Override
    public void close() throws IOException {
        this.fileSystemAbstraction.close();
    }
}

