/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.utils;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import org.neo4j.values.AnyValueWriter;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.TextArray;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.NodeValue;
import org.neo4j.values.virtual.RelationshipValue;

public class PrettyPrinter
implements AnyValueWriter<RuntimeException> {
    private final Deque<Writer> stack = new ArrayDeque<Writer>();
    private final String quoteMark;

    public PrettyPrinter() {
        this("\"");
    }

    public PrettyPrinter(String quoteMark) {
        this.quoteMark = quoteMark;
        this.stack.push(new ValueWriter());
    }

    @Override
    public void writeNodeReference(long nodeId) {
        this.append(String.format("(id=%d)", nodeId));
    }

    @Override
    public void writeNode(long nodeId, TextArray labels2, MapValue properties) {
        this.append(String.format("(id=%d", nodeId));
        String sep = " ";
        for (int i = 0; i < labels2.length(); ++i) {
            this.append(sep);
            this.append(":" + labels2.stringValue(i));
            sep = "";
        }
        if (properties.size() > 0) {
            this.append(" ");
            properties.writeTo(this);
        }
        this.append(")");
    }

    @Override
    public void writeRelationshipReference(long relId) {
        this.append(String.format("-[id=%d]-", relId));
    }

    @Override
    public void writeRelationship(long relId, long startNodeId, long endNodeId, TextValue type, MapValue properties) {
        this.append(String.format("-[id=%d :%s", relId, type.stringValue()));
        if (properties.size() > 0) {
            this.append(" ");
            properties.writeTo(this);
        }
        this.append("]-");
    }

    @Override
    public void beginMap(int size2) {
        this.stack.push(new MapWriter());
    }

    @Override
    public void endMap() {
        assert (!this.stack.isEmpty());
        this.append(this.stack.pop().done());
    }

    @Override
    public void beginList(int size2) {
        this.stack.push(new ListWriter());
    }

    @Override
    public void endList() {
        assert (!this.stack.isEmpty());
        this.append(this.stack.pop().done());
    }

    @Override
    public void writePath(NodeValue[] nodes, RelationshipValue[] relationships) {
        if (nodes.length == 0) {
            return;
        }
        nodes[0].writeTo(this);
        for (int i = 0; i < relationships.length; ++i) {
            relationships[i].writeTo(this);
            this.append(">");
            nodes[i + 1].writeTo(this);
        }
    }

    @Override
    public void writePoint(CoordinateReferenceSystem crs, double[] coordinate) throws RuntimeException {
        this.append("{geometry: {type: \"Point\", coordinates: ");
        this.append(Arrays.toString(coordinate));
        this.append(", crs: {type: link, properties: {href: \"");
        this.append(crs.getHref());
        this.append("\", code: ");
        this.append(Integer.toString(crs.getCode()));
        this.append("}}}}");
    }

    @Override
    public void writeDuration(long months, long days, long seconds, int nanos) throws RuntimeException {
        this.append("{duration: {months: ");
        this.append(Long.toString(months));
        this.append(", days: ");
        this.append(Long.toString(days));
        this.append(", seconds: ");
        this.append(Long.toString(seconds));
        this.append(", nanos: ");
        this.append(Long.toString(nanos));
        this.append("}}");
    }

    @Override
    public void writeDate(LocalDate localDate) throws RuntimeException {
        this.append("{date: ");
        this.append(this.quote(localDate.toString()));
        this.append("}");
    }

    @Override
    public void writeLocalTime(LocalTime localTime) throws RuntimeException {
        this.append("{localTime: ");
        this.append(this.quote(localTime.toString()));
        this.append("}");
    }

    @Override
    public void writeTime(OffsetTime offsetTime) throws RuntimeException {
        this.append("{time: ");
        this.append(this.quote(offsetTime.toString()));
        this.append("}");
    }

    @Override
    public void writeLocalDateTime(LocalDateTime localDateTime) throws RuntimeException {
        this.append("{localDateTime: ");
        this.append(this.quote(localDateTime.toString()));
        this.append("}");
    }

    @Override
    public void writeDateTime(ZonedDateTime zonedDateTime) throws RuntimeException {
        this.append("{datetime: ");
        this.append(this.quote(zonedDateTime.toString()));
        this.append("}");
    }

    @Override
    public void writeNull() {
        this.append("<null>");
    }

    @Override
    public void writeBoolean(boolean value2) {
        this.append(Boolean.toString(value2));
    }

    @Override
    public void writeInteger(byte value2) {
        this.append(Byte.toString(value2));
    }

    @Override
    public void writeInteger(short value2) {
        this.append(Short.toString(value2));
    }

    @Override
    public void writeInteger(int value2) {
        this.append(Integer.toString(value2));
    }

    @Override
    public void writeInteger(long value2) {
        this.append(Long.toString(value2));
    }

    @Override
    public void writeFloatingPoint(float value2) {
        this.append(Float.toString(value2));
    }

    @Override
    public void writeFloatingPoint(double value2) {
        this.append(Double.toString(value2));
    }

    @Override
    public void writeString(String value2) {
        this.append(this.quote(value2));
    }

    @Override
    public void writeString(char value2) {
        this.writeString(Character.toString(value2));
    }

    @Override
    public void beginArray(int size2, ValueWriter.ArrayType arrayType) {
        this.stack.push(new ListWriter());
    }

    @Override
    public void endArray() {
        assert (!this.stack.isEmpty());
        this.append(this.stack.pop().done());
    }

    @Override
    public void writeByteArray(byte[] value2) {
        String sep = "";
        this.append("[");
        for (byte b : value2) {
            this.append(sep);
            this.append(Byte.toString(b));
            sep = ", ";
        }
        this.append("]");
    }

    public String value() {
        assert (this.stack.size() == 1);
        return this.stack.getLast().done();
    }

    private void append(String value2) {
        assert (!this.stack.isEmpty());
        Writer head2 = this.stack.peek();
        head2.append(value2);
    }

    private String quote(String value2) {
        assert (!this.stack.isEmpty());
        Writer head2 = this.stack.peek();
        return head2.quote(value2);
    }

    private class ListWriter
    extends BaseWriter {
        private String sep;

        ListWriter() {
            this.sep = "";
            this.builder.append("[");
        }

        @Override
        public void append(String value2) {
            this.builder.append(this.sep).append(value2);
            this.sep = ", ";
        }

        @Override
        public String done() {
            return this.builder.append("]").toString();
        }
    }

    private class MapWriter
    extends BaseWriter {
        private boolean writeKey;
        private String sep;

        MapWriter() {
            this.writeKey = true;
            this.sep = "";
            this.builder.append("{");
        }

        @Override
        public void append(String value2) {
            if (this.writeKey) {
                this.builder.append(this.sep).append(value2).append(": ");
            } else {
                this.builder.append(value2);
            }
            this.writeKey = !this.writeKey;
            this.sep = ", ";
        }

        @Override
        public String done() {
            return this.builder.append("}").toString();
        }

        @Override
        public String quote(String in2) {
            return this.writeKey ? in2 : super.quote(in2);
        }
    }

    private class ValueWriter
    extends BaseWriter {
        private ValueWriter() {
        }

        @Override
        public void append(String value2) {
            this.builder.append(value2);
        }
    }

    private abstract class BaseWriter
    implements Writer {
        protected final StringBuilder builder = new StringBuilder();

        private BaseWriter() {
        }

        @Override
        public String done() {
            return this.builder.toString();
        }

        @Override
        public String quote(String in2) {
            return PrettyPrinter.this.quoteMark + in2 + PrettyPrinter.this.quoteMark;
        }
    }

    private static interface Writer {
        public void append(String var1);

        public String done();

        public String quote(String var1);
    }
}

