/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.neo4j.hashing.HashFunction;
import org.neo4j.values.AnyValue;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.StringWrappingStringValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.VirtualValues;

public abstract class StringValue
extends TextValue {
    static TextValue EMPTY = new StringValue(){

        @Override
        protected int computeHash() {
            return 0;
        }

        @Override
        public long updateHash(HashFunction hashFunction, long hash) {
            return hashFunction.update(hash, 0L);
        }

        @Override
        public int length() {
            return 0;
        }

        @Override
        public TextValue substring(int start, int end) {
            return this;
        }

        @Override
        public TextValue trim() {
            return this;
        }

        @Override
        public TextValue ltrim() {
            return this;
        }

        @Override
        public TextValue rtrim() {
            return this;
        }

        @Override
        public TextValue reverse() {
            return this;
        }

        @Override
        public TextValue plus(TextValue other2) {
            return other2;
        }

        @Override
        public boolean startsWith(TextValue other2) {
            return other2.length() == 0;
        }

        @Override
        public boolean endsWith(TextValue other2) {
            return other2.length() == 0;
        }

        @Override
        public boolean contains(TextValue other2) {
            return other2.length() == 0;
        }

        @Override
        public TextValue toLower() {
            return this;
        }

        @Override
        public TextValue toUpper() {
            return this;
        }

        @Override
        public TextValue replace(String find2, String replace2) {
            if (find2.isEmpty()) {
                return Values.stringValue(replace2);
            }
            return this;
        }

        @Override
        public int compareTo(TextValue other2) {
            return -other2.length();
        }

        @Override
        Matcher matcher(Pattern pattern) {
            return pattern.matcher("");
        }

        @Override
        String value() {
            return "";
        }
    };

    abstract String value();

    @Override
    public boolean equals(Value value2) {
        return value2.equals(this.value());
    }

    @Override
    public boolean equals(char x) {
        return this.value().length() == 1 && this.value().charAt(0) == x;
    }

    @Override
    public boolean equals(String x) {
        return this.value().equals(x);
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        writer.writeString(this.value());
    }

    @Override
    public TextValue toLower() {
        return new StringWrappingStringValue(this.value().toLowerCase());
    }

    @Override
    public TextValue toUpper() {
        return new StringWrappingStringValue(this.value().toUpperCase());
    }

    @Override
    public ListValue split(String separator) {
        assert (separator != null);
        String asString2 = this.value();
        if (separator.equals(asString2)) {
            return EMPTY_SPLIT;
        }
        if (separator.isEmpty()) {
            return VirtualValues.fromArray(Values.charArray(asString2.toCharArray()));
        }
        List<AnyValue> split2 = StringValue.splitNonRegex(asString2, separator);
        return VirtualValues.fromList(split2);
    }

    private static List<AnyValue> splitNonRegex(String input2, String delim) {
        ArrayList<AnyValue> l = new ArrayList<AnyValue>();
        int offset = 0;
        while (true) {
            String substring;
            int index;
            if ((index = input2.indexOf(delim, offset)) == -1) {
                substring = input2.substring(offset);
                l.add(Values.stringValue(substring));
                return l;
            }
            substring = input2.substring(offset, index);
            l.add(Values.stringValue(substring));
            offset = index + delim.length();
        }
    }

    @Override
    public TextValue replace(String find2, String replace2) {
        assert (find2 != null);
        assert (replace2 != null);
        return Values.stringValue(this.value().replace(find2, replace2));
    }

    @Override
    public Object asObjectCopy() {
        return this.value();
    }

    public String toString() {
        return String.format("%s(\"%s\")", this.getTypeName(), this.value());
    }

    @Override
    public String getTypeName() {
        return "String";
    }

    @Override
    public String stringValue() {
        return this.value();
    }

    @Override
    public String prettyPrint() {
        return String.format("'%s'", this.value());
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapString(this);
    }

    @Override
    public int compareTo(TextValue other2) {
        String thisString = this.value();
        String thatString = other2.stringValue();
        return thisString.compareTo(thatString);
    }
}

