/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.neo4j.graphdb.spatial.Point;
import org.neo4j.values.SequenceValue;
import org.neo4j.values.storable.BooleanArray;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.ByteArray;
import org.neo4j.values.storable.ByteValue;
import org.neo4j.values.storable.CharArray;
import org.neo4j.values.storable.CharValue;
import org.neo4j.values.storable.DateArray;
import org.neo4j.values.storable.DateTimeArray;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.DoubleArray;
import org.neo4j.values.storable.DoubleValue;
import org.neo4j.values.storable.DurationArray;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.FloatArray;
import org.neo4j.values.storable.FloatValue;
import org.neo4j.values.storable.FloatingPointArray;
import org.neo4j.values.storable.FloatingPointValue;
import org.neo4j.values.storable.IntArray;
import org.neo4j.values.storable.IntValue;
import org.neo4j.values.storable.IntegralArray;
import org.neo4j.values.storable.IntegralValue;
import org.neo4j.values.storable.LocalDateTimeArray;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.LocalTimeArray;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.LongArray;
import org.neo4j.values.storable.LongValue;
import org.neo4j.values.storable.NumberArray;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.storable.PointArray;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.ShortArray;
import org.neo4j.values.storable.ShortValue;
import org.neo4j.values.storable.StringArray;
import org.neo4j.values.storable.StringValue;
import org.neo4j.values.storable.TextArray;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.TimeArray;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.PathValue;
import org.neo4j.values.virtual.VirtualNodeValue;
import org.neo4j.values.virtual.VirtualRelationshipValue;

public interface ValueMapper<Base> {
    public Base mapPath(PathValue var1);

    public Base mapNode(VirtualNodeValue var1);

    public Base mapRelationship(VirtualRelationshipValue var1);

    public Base mapMap(MapValue var1);

    public Base mapNoValue();

    public Base mapSequence(SequenceValue var1);

    public Base mapText(TextValue var1);

    default public Base mapString(StringValue value2) {
        return this.mapText(value2);
    }

    default public Base mapTextArray(TextArray value2) {
        return this.mapSequence(value2);
    }

    default public Base mapStringArray(StringArray value2) {
        return this.mapTextArray(value2);
    }

    default public Base mapChar(CharValue value2) {
        return this.mapText(value2);
    }

    default public Base mapCharArray(CharArray value2) {
        return this.mapTextArray(value2);
    }

    public Base mapBoolean(BooleanValue var1);

    default public Base mapBooleanArray(BooleanArray value2) {
        return this.mapSequence(value2);
    }

    public Base mapNumber(NumberValue var1);

    default public Base mapNumberArray(NumberArray value2) {
        return this.mapSequence(value2);
    }

    default public Base mapIntegral(IntegralValue value2) {
        return this.mapNumber(value2);
    }

    default public Base mapIntegralArray(IntegralArray value2) {
        return this.mapNumberArray(value2);
    }

    default public Base mapByte(ByteValue value2) {
        return this.mapIntegral(value2);
    }

    default public Base mapByteArray(ByteArray value2) {
        return this.mapIntegralArray(value2);
    }

    default public Base mapShort(ShortValue value2) {
        return this.mapIntegral(value2);
    }

    default public Base mapShortArray(ShortArray value2) {
        return this.mapIntegralArray(value2);
    }

    default public Base mapInt(IntValue value2) {
        return this.mapIntegral(value2);
    }

    default public Base mapIntArray(IntArray value2) {
        return this.mapIntegralArray(value2);
    }

    default public Base mapLong(LongValue value2) {
        return this.mapIntegral(value2);
    }

    default public Base mapLongArray(LongArray value2) {
        return this.mapIntegralArray(value2);
    }

    default public Base mapFloatingPoint(FloatingPointValue value2) {
        return this.mapNumber(value2);
    }

    default public Base mapFloatingPointArray(FloatingPointArray value2) {
        return this.mapNumberArray(value2);
    }

    default public Base mapDouble(DoubleValue value2) {
        return this.mapFloatingPoint(value2);
    }

    default public Base mapDoubleArray(DoubleArray value2) {
        return this.mapFloatingPointArray(value2);
    }

    default public Base mapFloat(FloatValue value2) {
        return this.mapFloatingPoint(value2);
    }

    default public Base mapFloatArray(FloatArray value2) {
        return this.mapFloatingPointArray(value2);
    }

    public Base mapDateTime(DateTimeValue var1);

    public Base mapLocalDateTime(LocalDateTimeValue var1);

    public Base mapDate(DateValue var1);

    public Base mapTime(TimeValue var1);

    public Base mapLocalTime(LocalTimeValue var1);

    public Base mapDuration(DurationValue var1);

    public Base mapPoint(PointValue var1);

    default public Base mapPointArray(PointArray value2) {
        return this.mapSequence(value2);
    }

    default public Base mapDateTimeArray(DateTimeArray value2) {
        return this.mapSequence(value2);
    }

    default public Base mapLocalDateTimeArray(LocalDateTimeArray value2) {
        return this.mapSequence(value2);
    }

    default public Base mapLocalTimeArray(LocalTimeArray value2) {
        return this.mapSequence(value2);
    }

    default public Base mapTimeArray(TimeArray value2) {
        return this.mapSequence(value2);
    }

    default public Base mapDateArray(DateArray value2) {
        return this.mapSequence(value2);
    }

    default public Base mapDurationArray(DurationArray value2) {
        return this.mapSequence(value2);
    }

    public static abstract class JavaMapper
    implements ValueMapper<Object> {
        @Override
        public Object mapNoValue() {
            return null;
        }

        @Override
        public Object mapMap(MapValue value2) {
            HashMap map2 = new HashMap();
            value2.foreach((k, v) -> map2.put(k, v.map(this)));
            return map2;
        }

        @Override
        public List<?> mapSequence(SequenceValue value2) {
            ArrayList list2 = new ArrayList(value2.length());
            value2.forEach(v -> list2.add(v.map(this)));
            return list2;
        }

        @Override
        public Character mapChar(CharValue value2) {
            return Character.valueOf(value2.value());
        }

        @Override
        public String mapText(TextValue value2) {
            return value2.stringValue();
        }

        @Override
        public String[] mapStringArray(StringArray value2) {
            return value2.asObjectCopy();
        }

        @Override
        public char[] mapCharArray(CharArray value2) {
            return value2.asObjectCopy();
        }

        @Override
        public Boolean mapBoolean(BooleanValue value2) {
            return value2.booleanValue();
        }

        @Override
        public boolean[] mapBooleanArray(BooleanArray value2) {
            return value2.asObjectCopy();
        }

        @Override
        public Number mapNumber(NumberValue value2) {
            return value2.asObject();
        }

        @Override
        public byte[] mapByteArray(ByteArray value2) {
            return value2.asObjectCopy();
        }

        @Override
        public short[] mapShortArray(ShortArray value2) {
            return value2.asObjectCopy();
        }

        @Override
        public int[] mapIntArray(IntArray value2) {
            return value2.asObjectCopy();
        }

        @Override
        public long[] mapLongArray(LongArray value2) {
            return value2.asObjectCopy();
        }

        @Override
        public float[] mapFloatArray(FloatArray value2) {
            return value2.asObjectCopy();
        }

        @Override
        public double[] mapDoubleArray(DoubleArray value2) {
            return value2.asObjectCopy();
        }

        @Override
        public ZonedDateTime mapDateTime(DateTimeValue value2) {
            return (ZonedDateTime)value2.asObjectCopy();
        }

        @Override
        public LocalDateTime mapLocalDateTime(LocalDateTimeValue value2) {
            return (LocalDateTime)value2.asObjectCopy();
        }

        @Override
        public LocalDate mapDate(DateValue value2) {
            return (LocalDate)value2.asObjectCopy();
        }

        @Override
        public OffsetTime mapTime(TimeValue value2) {
            return (OffsetTime)value2.asObjectCopy();
        }

        @Override
        public LocalTime mapLocalTime(LocalTimeValue value2) {
            return (LocalTime)value2.asObjectCopy();
        }

        @Override
        public TemporalAmount mapDuration(DurationValue value2) {
            return value2.asObjectCopy();
        }

        @Override
        public Point mapPoint(PointValue value2) {
            return value2.asObjectCopy();
        }
    }
}

