/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import org.neo4j.memory.MemoryAllocationTracker;
import org.neo4j.unsafe.impl.batchimport.cache.LongArray;
import org.neo4j.unsafe.impl.batchimport.cache.OffHeapRegularNumberArray;
import org.neo4j.unsafe.impl.internal.dragons.UnsafeUtil;

public class OffHeapLongArray
extends OffHeapRegularNumberArray<LongArray>
implements LongArray {
    private final long defaultValue;

    public OffHeapLongArray(long length2, long defaultValue, long base, MemoryAllocationTracker allocationTracker) {
        super(length2, 3, base, allocationTracker);
        this.defaultValue = defaultValue;
        this.clear();
    }

    @Override
    public long get(long index) {
        return UnsafeUtil.getLong((long)this.addressOf(index));
    }

    @Override
    public void set(long index, long value2) {
        UnsafeUtil.putLong((long)this.addressOf(index), (long)value2);
    }

    @Override
    public void clear() {
        if (this.isByteUniform(this.defaultValue)) {
            UnsafeUtil.setMemory((long)this.address, (long)(this.length << this.shift), (byte)((byte)this.defaultValue));
        } else {
            long i = 0L;
            long adr = this.address;
            while (i < this.length) {
                UnsafeUtil.putLong((long)adr, (long)this.defaultValue);
                ++i;
                adr += (long)this.itemSize;
            }
        }
    }
}

