/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.prettyprint;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.neo4j.driver.internal.types.TypeRepresentation;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.Values;
import org.neo4j.driver.v1.summary.Plan;
import org.neo4j.driver.v1.summary.ProfiledPlan;
import org.neo4j.driver.v1.summary.ResultSummary;
import org.neo4j.driver.v1.types.Node;
import org.neo4j.driver.v1.types.Path;
import org.neo4j.driver.v1.types.Point;
import org.neo4j.driver.v1.types.Relationship;
import org.neo4j.shell.prettyprint.CypherVariablesFormatter;
import org.neo4j.shell.prettyprint.LinePrinter;
import org.neo4j.shell.state.BoltResult;

public interface OutputFormatter {
    public static final String COMMA_SEPARATOR = ", ";
    public static final String COLON_SEPARATOR = ": ";
    public static final String COLON = ":";
    public static final String SPACE = " ";
    public static final String NEWLINE = System.getProperty("line.separator");
    public static final List<String> INFO_SUMMARY = Arrays.asList("Version", "Planner", "Runtime");

    public int formatAndCount(@Nonnull BoltResult var1, @Nonnull LinePrinter var2);

    @Nonnull
    default public String formatValue(Value value2) {
        if (value2 == null) {
            return "";
        }
        TypeRepresentation type = (TypeRepresentation)value2.type();
        switch (type.constructor()) {
            case LIST: {
                return OutputFormatter.listAsString(value2.asList(this::formatValue));
            }
            case MAP: {
                return OutputFormatter.mapAsString(value2.asMap(this::formatValue));
            }
            case NODE: {
                return this.nodeAsString(value2.asNode());
            }
            case RELATIONSHIP: {
                return this.relationshipAsString(value2.asRelationship());
            }
            case PATH: {
                return this.pathAsString(value2.asPath());
            }
            case POINT: {
                return this.pointAsString(value2.asPoint());
            }
        }
        return value2.toString();
    }

    @Nonnull
    default public String pointAsString(Point point) {
        StringBuilder stringBuilder = new StringBuilder("point({");
        stringBuilder.append("srid:").append(point.srid()).append(",");
        stringBuilder.append(" x:").append(point.x()).append(",");
        stringBuilder.append(" y:").append(point.y());
        double z = point.z();
        if (!Double.isNaN(z)) {
            stringBuilder.append(", z:").append(z);
        }
        stringBuilder.append("})");
        return stringBuilder.toString();
    }

    @Nonnull
    default public String pathAsString(@Nonnull Path path) {
        ArrayList<String> list2 = new ArrayList<String>(path.length());
        Node lastTraversed = path.start();
        if (lastTraversed != null) {
            list2.add(this.nodeAsString(lastTraversed));
            for (Path.Segment segment : path) {
                Relationship relationship = segment.relationship();
                if (relationship.startNodeId() == lastTraversed.id()) {
                    list2.add("-" + this.relationshipAsString(relationship) + "->");
                } else {
                    list2.add("<-" + this.relationshipAsString(relationship) + "-");
                }
                list2.add(this.nodeAsString(segment.end()));
                lastTraversed = segment.end();
            }
        }
        return String.join((CharSequence)"", list2);
    }

    @Nonnull
    default public String relationshipAsString(@Nonnull Relationship relationship) {
        ArrayList<String> relationshipAsString = new ArrayList<String>();
        relationshipAsString.add(COLON + CypherVariablesFormatter.escape(relationship.type()));
        relationshipAsString.add(OutputFormatter.mapAsStringWithEmpty(relationship.asMap(this::formatValue)));
        return "[" + OutputFormatter.joinWithSpace(relationshipAsString) + "]";
    }

    @Nonnull
    default public String nodeAsString(@Nonnull Node node) {
        ArrayList<String> nodeAsString = new ArrayList<String>();
        nodeAsString.add(OutputFormatter.collectNodeLabels(node));
        nodeAsString.add(OutputFormatter.mapAsStringWithEmpty(node.asMap(this::formatValue)));
        return "(" + OutputFormatter.joinWithSpace(nodeAsString) + ")";
    }

    @Nonnull
    public static String collectNodeLabels(@Nonnull Node node) {
        StringBuilder sb = new StringBuilder();
        node.labels().forEach(label -> sb.append(COLON).append(CypherVariablesFormatter.escape(label)));
        return sb.toString();
    }

    @Nonnull
    public static String listAsString(@Nonnull List<String> list2) {
        return list2.stream().collect(Collectors.joining(COMMA_SEPARATOR, "[", "]"));
    }

    @Nonnull
    public static String mapAsStringWithEmpty(@Nonnull Map<String, Object> map2) {
        return map2.isEmpty() ? "" : OutputFormatter.mapAsString(map2);
    }

    @Nonnull
    public static String mapAsString(@Nonnull Map<String, Object> map2) {
        return map2.entrySet().stream().map(e -> CypherVariablesFormatter.escape((String)e.getKey()) + COLON_SEPARATOR + e.getValue()).collect(Collectors.joining(COMMA_SEPARATOR, "{", "}"));
    }

    @Nonnull
    public static String joinWithSpace(@Nonnull List<String> strings) {
        return strings.stream().filter(OutputFormatter::isNotBlank).collect(Collectors.joining(SPACE));
    }

    @Nonnull
    public static String joinNonBlanks(@Nonnull String delim, @Nonnull List<String> strings) {
        return strings.stream().filter(OutputFormatter::isNotBlank).collect(Collectors.joining(delim));
    }

    public static boolean isNotBlank(String string2) {
        return string2 != null && !string2.trim().isEmpty();
    }

    @Nonnull
    public static String repeat(char c, int times2) {
        char[] chars = new char[times2];
        Arrays.fill(chars, c);
        return String.valueOf(chars);
    }

    @Nonnull
    public static String repeat(@Nonnull String c, int times2) {
        StringBuilder sb = new StringBuilder(times2 * c.length());
        for (int i = 0; i < times2; ++i) {
            sb.append(c);
        }
        return sb.toString();
    }

    @Nonnull
    public static String rightPad(@Nonnull String str2, int width) {
        return OutputFormatter.rightPad(str2, width, ' ');
    }

    @Nonnull
    public static String rightPad(@Nonnull String str2, int width, char c) {
        int actualSize = str2.length();
        if (actualSize > width) {
            return str2.substring(0, width);
        }
        if (actualSize < width) {
            return str2 + OutputFormatter.repeat(c, width - actualSize);
        }
        return str2;
    }

    @Nonnull
    default public String formatPlan(@Nonnull ResultSummary summary) {
        return "";
    }

    @Nonnull
    default public String formatInfo(@Nonnull ResultSummary summary) {
        return "";
    }

    @Nonnull
    default public String formatFooter(@Nonnull BoltResult result2, int numberOfRows) {
        return "";
    }

    public Set<Capabilities> capabilities();

    @Nonnull
    public static Map<String, Value> info(@Nonnull ResultSummary summary) {
        LinkedHashMap<String, Value> result2 = new LinkedHashMap<String, Value>();
        if (!summary.hasPlan()) {
            return result2;
        }
        Plan plan = summary.plan();
        result2.put("Plan", Values.value(summary.hasProfile() ? "PROFILE" : "EXPLAIN"));
        result2.put("Statement", Values.value(summary.statementType().name()));
        Map<String, Value> arguments2 = plan.arguments();
        Value defaultValue = Values.value("");
        for (String key : INFO_SUMMARY) {
            Value value2 = arguments2.getOrDefault(key, arguments2.getOrDefault(key.toLowerCase(), defaultValue));
            result2.put(key, value2);
        }
        result2.put("Time", Values.value(summary.resultAvailableAfter(TimeUnit.MILLISECONDS) + summary.resultConsumedAfter(TimeUnit.MILLISECONDS)));
        if (summary.hasProfile()) {
            result2.put("DbHits", Values.value(OutputFormatter.collectHits(summary.profile())));
        }
        if (summary.hasProfile()) {
            result2.put("Rows", Values.value(summary.profile().records()));
        }
        return result2;
    }

    public static long collectHits(@Nonnull ProfiledPlan operator) {
        long hits = operator.dbHits();
        hits = operator.children().stream().map(OutputFormatter::collectHits).reduce(hits, Long::sum);
        return hits;
    }

    public static enum Capabilities {
        INFO,
        PLAN,
        RESULT,
        FOOTER,
        STATISTICS;

    }
}

