/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.traversal;

import java.util.Iterator;
import java.util.LinkedList;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.traversal.BranchState;
import org.neo4j.graphdb.traversal.Evaluation;
import org.neo4j.graphdb.traversal.Paths;
import org.neo4j.graphdb.traversal.TraversalBranch;
import org.neo4j.graphdb.traversal.TraversalContext;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.PrefetchingIterator;

class TraversalBranchImpl
implements TraversalBranch {
    final TraversalBranch parent;
    private final Relationship howIGotHere;
    private final Node source;
    private ResourceIterator<Relationship> relationships;
    private int depthAndEvaluationBits;
    private int expandedCount;

    TraversalBranchImpl(TraversalBranch parent2, int depth, Node source, Relationship toHere) {
        this.parent = parent2;
        this.source = source;
        this.howIGotHere = toHere;
        this.depthAndEvaluationBits = depth;
    }

    TraversalBranchImpl(TraversalBranch parent2, Node source) {
        this.parent = parent2;
        this.source = source;
        this.howIGotHere = null;
        this.depthAndEvaluationBits = 0;
    }

    protected void setEvaluation(Evaluation evaluation) {
        this.depthAndEvaluationBits &= 0x3FFFFFFF;
        this.depthAndEvaluationBits |= this.bitValue(evaluation.includes(), 30) | this.bitValue(evaluation.continues(), 31);
    }

    private int bitValue(boolean value2, int bit) {
        return (value2 ? 1 : 0) << bit;
    }

    protected void expandRelationships(PathExpander expander) {
        if (this.continues()) {
            this.relationships = this.expandRelationshipsWithoutChecks(expander);
        } else {
            this.resetRelationships();
        }
    }

    protected ResourceIterator expandRelationshipsWithoutChecks(PathExpander expander) {
        return Iterators.asResourceIterator(expander.expand(this, BranchState.NO_STATE).iterator());
    }

    protected boolean hasExpandedRelationships() {
        return this.relationships != null;
    }

    protected void evaluate(TraversalContext context) {
        this.setEvaluation(context.evaluate(this, null));
    }

    @Override
    public void initialize(PathExpander expander, TraversalContext metadata) {
        this.evaluate(metadata);
    }

    @Override
    public TraversalBranch next(PathExpander expander, TraversalContext context) {
        if (this.relationships == null) {
            this.expandRelationships(expander);
        }
        while (this.relationships.hasNext()) {
            Relationship relationship = (Relationship)this.relationships.next();
            if (relationship.equals(this.howIGotHere)) {
                context.unnecessaryRelationshipTraversed();
                continue;
            }
            ++this.expandedCount;
            Node node = relationship.getOtherNode(this.source);
            TraversalBranch next2 = this.newNextBranch(node, relationship);
            if (context.isUnique(next2)) {
                context.relationshipTraversed();
                next2.initialize(expander, context);
                return next2;
            }
            context.unnecessaryRelationshipTraversed();
        }
        this.resetRelationships();
        return null;
    }

    protected TraversalBranch newNextBranch(Node node, Relationship relationship) {
        return new TraversalBranchImpl(this, this.length() + 1, node, relationship);
    }

    @Override
    public void prune() {
        this.resetRelationships();
    }

    private void resetRelationships() {
        if (this.relationships != null) {
            this.relationships.close();
        }
        this.relationships = Iterators.emptyResourceIterator();
    }

    @Override
    public int length() {
        return this.depthAndEvaluationBits & 0x3FFFFFFF;
    }

    @Override
    public TraversalBranch parent() {
        return this.parent;
    }

    @Override
    public int expanded() {
        return this.expandedCount;
    }

    @Override
    public boolean includes() {
        return (this.depthAndEvaluationBits & 0x40000000) != 0;
    }

    @Override
    public boolean continues() {
        return (this.depthAndEvaluationBits & Integer.MIN_VALUE) != 0;
    }

    @Override
    public void evaluation(Evaluation eval) {
        this.setEvaluation(Evaluation.of(this.includes() & eval.includes(), this.continues() & eval.continues()));
    }

    @Override
    public Node startNode() {
        return this.findStartBranch().endNode();
    }

    private TraversalBranch findStartBranch() {
        TraversalBranch branch = this;
        while (branch.length() > 0) {
            branch = branch.parent();
        }
        return branch;
    }

    @Override
    public Node endNode() {
        return this.source;
    }

    @Override
    public Relationship lastRelationship() {
        return this.howIGotHere;
    }

    @Override
    public Iterable<Relationship> relationships() {
        LinkedList<Relationship> relationships = new LinkedList<Relationship>();
        TraversalBranch branch = this;
        while (branch.length() > 0) {
            relationships.addFirst(branch.lastRelationship());
            branch = branch.parent();
        }
        return relationships;
    }

    @Override
    public Iterable<Relationship> reverseRelationships() {
        return () -> new PrefetchingIterator<Relationship>(){
            private TraversalBranch branch;
            {
                this.branch = TraversalBranchImpl.this;
            }

            protected Relationship fetchNextOrNull() {
                Relationship relationship;
                try {
                    relationship = this.branch != null ? this.branch.lastRelationship() : null;
                    this.branch = this.branch != null ? this.branch.parent() : null;
                }
                catch (Throwable throwable) {
                    this.branch = this.branch != null ? this.branch.parent() : null;
                    throw throwable;
                }
                return relationship;
            }
        };
    }

    @Override
    public Iterable<Node> nodes() {
        LinkedList<Node> nodes = new LinkedList<Node>();
        TraversalBranch branch = this;
        while (branch.length() > 0) {
            nodes.addFirst(branch.endNode());
            branch = branch.parent();
        }
        nodes.addFirst(branch.endNode());
        return nodes;
    }

    @Override
    public Iterable<Node> reverseNodes() {
        return () -> new PrefetchingIterator<Node>(){
            private TraversalBranch branch;
            {
                this.branch = TraversalBranchImpl.this;
            }

            protected Node fetchNextOrNull() {
                try {
                    Node node = this.branch.length() >= 0 ? this.branch.endNode() : null;
                    return node;
                }
                finally {
                    this.branch = this.branch.parent();
                }
            }
        };
    }

    @Override
    public Iterator<PropertyContainer> iterator() {
        LinkedList<Entity> entities = new LinkedList<Entity>();
        TraversalBranch branch = this;
        while (branch.length() > 0) {
            entities.addFirst(branch.endNode());
            entities.addFirst(branch.lastRelationship());
            branch = branch.parent();
        }
        entities.addFirst(branch.endNode());
        return entities.iterator();
    }

    public int hashCode() {
        TraversalBranch branch = this;
        int hashCode2 = 1;
        while (branch.length() > 0) {
            Relationship relationship = branch.lastRelationship();
            hashCode2 = 31 * hashCode2 + relationship.hashCode();
            branch = branch.parent();
        }
        if (hashCode2 == 1) {
            hashCode2 = this.endNode().hashCode();
        }
        return hashCode2;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TraversalBranch)) {
            return false;
        }
        TraversalBranch branch = this;
        TraversalBranch other2 = (TraversalBranch)obj;
        if (branch.length() != other2.length()) {
            return false;
        }
        while (branch.length() > 0) {
            if (!branch.lastRelationship().equals(other2.lastRelationship())) {
                return false;
            }
            branch = branch.parent();
            other2 = other2.parent();
        }
        return true;
    }

    @Override
    public String toString() {
        return Paths.defaultPathToString(this);
    }

    @Override
    public Object state() {
        return null;
    }
}

