/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state.storeview;

import java.util.function.IntPredicate;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.impl.api.index.EntityUpdates;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.transaction.state.storeview.PropertyAwareEntityStoreScan;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.StorageRelationshipScanCursor;

public class RelationshipStoreScan<FAILURE extends Exception>
extends PropertyAwareEntityStoreScan<StorageRelationshipScanCursor, FAILURE> {
    private final int[] relationshipTypeIds;
    private final Visitor<EntityUpdates, FAILURE> propertyUpdatesVisitor;

    public RelationshipStoreScan(StorageReader storageReader, LockService locks, Visitor<EntityUpdates, FAILURE> propertyUpdatesVisitor, int[] relationshipTypeIds, IntPredicate propertyKeyIdFilter) {
        super(storageReader, storageReader.relationshipsGetCount(), propertyKeyIdFilter, id2 -> locks.acquireRelationshipLock(id2, LockService.LockType.READ_LOCK));
        this.relationshipTypeIds = relationshipTypeIds;
        this.propertyUpdatesVisitor = propertyUpdatesVisitor;
    }

    @Override
    protected StorageRelationshipScanCursor allocateCursor(StorageReader storageReader) {
        return storageReader.allocateRelationshipScanCursor();
    }

    @Override
    protected boolean process(StorageRelationshipScanCursor cursor) throws FAILURE {
        EntityUpdates.Builder updates;
        int reltype = cursor.type();
        if (this.propertyUpdatesVisitor != null && RelationshipStoreScan.containsAnyEntityToken(this.relationshipTypeIds, reltype) && this.hasRelevantProperty(cursor, updates = EntityUpdates.forEntity(cursor.entityReference(), true).withTokens(reltype))) {
            return this.propertyUpdatesVisitor.visit((Object)updates.build());
        }
        return false;
    }
}

