/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.id.configuration;

import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import org.neo4j.kernel.impl.store.id.IdType;
import org.neo4j.kernel.impl.store.id.configuration.IdTypeConfiguration;
import org.neo4j.kernel.impl.store.id.configuration.IdTypeConfigurationProvider;

public class CommunityIdTypeConfigurationProvider
implements IdTypeConfigurationProvider {
    private static final Set<IdType> TYPES_TO_ALLOW_REUSE = Collections.unmodifiableSet(EnumSet.of(IdType.PROPERTY, IdType.STRING_BLOCK, IdType.ARRAY_BLOCK, IdType.NODE_LABELS));
    private final Map<IdType, IdTypeConfiguration> typeConfigurations = new EnumMap<IdType, IdTypeConfiguration>(IdType.class);

    @Override
    public IdTypeConfiguration getIdTypeConfiguration(IdType idType) {
        return this.typeConfigurations.computeIfAbsent(idType, this::createIdTypeConfiguration);
    }

    private IdTypeConfiguration createIdTypeConfiguration(IdType idType) {
        return new IdTypeConfiguration(this.getTypesToReuse().contains((Object)idType));
    }

    protected Set<IdType> getTypesToReuse() {
        return TYPES_TO_ALLOW_REUSE;
    }
}

