/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.id;

import java.util.Arrays;
import java.util.Deque;
import java.util.LinkedList;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class DelayedBuffer<T> {
    private final Supplier<T> thresholdSupplier;
    private final Predicate<T> safeThreshold;
    private final Consumer<long[]> chunkConsumer;
    private final Deque<Chunk<T>> chunks = new LinkedList<Chunk<T>>();
    private final int chunkSize;
    private final long[] chunk;
    private int chunkCursor;

    public DelayedBuffer(Supplier<T> thresholdSupplier, Predicate<T> safeThreshold, int chunkSize, Consumer<long[]> chunkConsumer) {
        assert (chunkSize > 0);
        this.thresholdSupplier = thresholdSupplier;
        this.safeThreshold = safeThreshold;
        this.chunkSize = chunkSize;
        this.chunkConsumer = chunkConsumer;
        this.chunk = new long[chunkSize];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void maintenance() {
        Object object = this;
        synchronized (object) {
            this.flush();
        }
        if (!this.chunks.isEmpty()) {
            object = this.chunks;
            synchronized (object) {
                Chunk<T> candidate;
                while (!this.chunks.isEmpty() && this.safeThreshold.test(((Chunk)(candidate = this.chunks.peek())).threshold)) {
                    this.chunkConsumer.accept(((Chunk)candidate).values);
                    this.chunks.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush() {
        if (this.chunkCursor > 0) {
            Deque<Chunk<T>> deque = this.chunks;
            synchronized (deque) {
                Chunk<T> chunkToAdd = new Chunk<T>(this.thresholdSupplier.get(), Arrays.copyOf(this.chunk, this.chunkCursor));
                this.chunks.offer(chunkToAdd);
            }
            this.chunkCursor = 0;
        }
    }

    public synchronized void offer(long value2) {
        this.chunk[this.chunkCursor++] = value2;
        if (this.chunkCursor == this.chunkSize) {
            this.flush();
        }
    }

    public synchronized void close() {
        this.flush();
        while (!this.chunks.isEmpty()) {
            this.chunkConsumer.accept(((Chunk)this.chunks.poll()).values);
        }
    }

    public synchronized void clear() {
        this.chunks.clear();
        this.chunkCursor = 0;
    }

    private static class Chunk<T> {
        private final T threshold;
        private final long[] values;

        Chunk(T threshold, long[] values2) {
            this.threshold = threshold;
            this.values = values2;
        }

        public String toString() {
            return Arrays.toString(this.values);
        }
    }
}

