/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.format;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.helpers.ArrayUtil;
import org.neo4j.kernel.impl.store.format.Capability;
import org.neo4j.kernel.impl.store.format.CapabilityType;
import org.neo4j.kernel.impl.store.format.RecordFormat;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.format.standard.MetaDataRecordFormat;
import org.neo4j.kernel.impl.store.record.MetaDataRecord;

public abstract class BaseRecordFormats
implements RecordFormats {
    private final int generation;
    private final Capability[] capabilities;
    private final String storeVersion;
    private final String introductionVersion;

    protected BaseRecordFormats(String storeVersion, String introductionVersion, int generation, Capability ... capabilities) {
        this.storeVersion = storeVersion;
        this.generation = generation;
        this.capabilities = capabilities;
        this.introductionVersion = introductionVersion;
    }

    @Override
    public String storeVersion() {
        return this.storeVersion;
    }

    @Override
    public String introductionVersion() {
        return this.introductionVersion;
    }

    @Override
    public RecordFormat<MetaDataRecord> metaData() {
        return new MetaDataRecordFormat();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RecordFormats)) {
            return false;
        }
        RecordFormats other2 = (RecordFormats)obj;
        return this.node().equals(other2.node()) && this.relationship().equals(other2.relationship()) && this.relationshipGroup().equals(other2.relationshipGroup()) && this.property().equals(other2.property()) && this.labelToken().equals(other2.labelToken()) && this.relationshipTypeToken().equals(other2.relationshipTypeToken()) && this.propertyKeyToken().equals(other2.propertyKeyToken()) && this.dynamic().equals(other2.dynamic());
    }

    public int hashCode() {
        int hashCode2 = 17;
        hashCode2 = 31 * hashCode2 + this.node().hashCode();
        hashCode2 = 31 * hashCode2 + this.relationship().hashCode();
        hashCode2 = 31 * hashCode2 + this.relationshipGroup().hashCode();
        hashCode2 = 31 * hashCode2 + this.property().hashCode();
        hashCode2 = 31 * hashCode2 + this.labelToken().hashCode();
        hashCode2 = 31 * hashCode2 + this.relationshipTypeToken().hashCode();
        hashCode2 = 31 * hashCode2 + this.propertyKeyToken().hashCode();
        hashCode2 = 31 * hashCode2 + this.dynamic().hashCode();
        return hashCode2;
    }

    public String toString() {
        return "RecordFormat:" + this.getClass().getSimpleName() + "[" + this.storeVersion() + "]";
    }

    @Override
    public int generation() {
        return this.generation;
    }

    @Override
    public Capability[] capabilities() {
        return this.capabilities;
    }

    @Override
    public boolean hasCapability(Capability capability) {
        return ArrayUtil.contains(this.capabilities(), capability);
    }

    public static boolean hasCompatibleCapabilities(RecordFormats one, RecordFormats other2, CapabilityType type) {
        Set otherFormatCapabilities;
        Set myFormatCapabilities = Stream.of(one.capabilities()).filter(capability -> capability.isType(type)).collect(Collectors.toSet());
        if (myFormatCapabilities.equals(otherFormatCapabilities = Stream.of(other2.capabilities()).filter(capability -> capability.isType(type)).collect(Collectors.toSet()))) {
            return true;
        }
        boolean capabilitiesNotRemoved = otherFormatCapabilities.containsAll(myFormatCapabilities);
        otherFormatCapabilities.removeAll(myFormatCapabilities);
        boolean allAddedAreAdditive = otherFormatCapabilities.stream().allMatch(Capability::isAdditive);
        return capabilitiesNotRemoved && allAddedAreAdditive;
    }

    @Override
    public boolean hasCompatibleCapabilities(RecordFormats other2, CapabilityType type) {
        return BaseRecordFormats.hasCompatibleCapabilities(this, other2, type);
    }
}

