/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.proc;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ParseUtil {
    private ParseUtil() {
        throw new UnsupportedOperationException("Do not instantiate");
    }

    static Map<String, Object> parseMap(String s2) {
        int pos = 0;
        int braceCounter = 0;
        HashMap<String, Object> map2 = new HashMap<String, Object>();
        StringBuilder builder = new StringBuilder();
        boolean inList = false;
        block8: while (pos < s2.length()) {
            char character = s2.charAt(pos);
            switch (character) {
                case ' ': {
                    ++pos;
                    continue block8;
                }
                case '{': {
                    if (braceCounter++ > 0) {
                        builder.append(s2.charAt(pos));
                    }
                    ++pos;
                    continue block8;
                }
                case ',': {
                    if (!inList && braceCounter == 1) {
                        ParseUtil.addKeyValue(map2, builder.toString().trim());
                        builder = new StringBuilder();
                    } else {
                        builder.append(s2.charAt(pos));
                    }
                    ++pos;
                    continue block8;
                }
                case '}': {
                    if (--braceCounter == 0) {
                        ParseUtil.addKeyValue(map2, builder.toString().trim());
                    } else {
                        builder.append(s2.charAt(pos));
                    }
                    ++pos;
                    continue block8;
                }
                case '[': {
                    inList = true;
                    builder.append(s2.charAt(pos++));
                    continue block8;
                }
                case ']': {
                    inList = false;
                    builder.append(s2.charAt(pos++));
                    continue block8;
                }
            }
            builder.append(s2.charAt(pos++));
        }
        if (braceCounter != 0) {
            throw new IllegalArgumentException(String.format("%s contains unbalanced '{', '}'.", s2));
        }
        return map2;
    }

    private static void addKeyValue(Map<String, Object> map2, String keyValue) {
        if (keyValue.isEmpty()) {
            return;
        }
        int split2 = keyValue.indexOf(58);
        if (split2 < 0) {
            throw new IllegalArgumentException("Keys and values must be separated with ':'");
        }
        String key = ParseUtil.parseKey(keyValue.substring(0, split2).trim());
        Object value2 = ParseUtil.parseValue(keyValue.substring(split2 + 1).trim(), Object.class);
        if (map2.containsKey(key)) {
            throw new IllegalArgumentException(String.format("Multiple occurrences of key '%s'", key));
        }
        map2.put(key, value2);
    }

    private static String parseKey(String s2) {
        block3: for (int pos = 0; pos < s2.length(); ++pos) {
            char c = s2.charAt(pos);
            switch (c) {
                case '\"': 
                case '\'': {
                    continue block3;
                }
            }
            return s2.substring(pos, s2.length() - pos);
        }
        throw new IllegalArgumentException("");
    }

    private static Object parseValue(String s2, Type type) {
        block13: for (int pos = 0; pos < s2.length(); ++pos) {
            char c = s2.charAt(pos);
            switch (c) {
                case ' ': {
                    continue block13;
                }
                case '\'': {
                    int closing2 = s2.lastIndexOf(39);
                    if (closing2 < 0) {
                        throw new IllegalArgumentException("Did not find a matching end quote, '");
                    }
                    return s2.substring(pos + 1, closing2);
                }
                case '\"': {
                    int closing3 = s2.lastIndexOf(34);
                    if (closing3 < 0) {
                        throw new IllegalArgumentException("Did not find a matching end quote, \"");
                    }
                    return s2.substring(pos + 1, closing3);
                }
                case '{': {
                    return ParseUtil.parseMap(s2.substring(pos));
                }
                case '[': {
                    if (type instanceof ParameterizedType) {
                        return ParseUtil.parseList(s2.substring(pos), ((ParameterizedType)type).getActualTypeArguments()[0]);
                    }
                    return ParseUtil.parseList(s2.substring(pos), Object.class);
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    String number = s2.substring(pos);
                    try {
                        return Long.valueOf(number);
                    }
                    catch (NumberFormatException e) {
                        return Double.valueOf(number);
                    }
                }
                case 'n': {
                    if (s2.charAt(pos + 1) == 'u' && s2.charAt(pos + 2) == 'l' && s2.charAt(pos + 3) == 'l') {
                        return null;
                    }
                }
                case 't': {
                    if (s2.charAt(pos + 1) == 'r' && s2.charAt(pos + 2) == 'u' && s2.charAt(pos + 3) == 'e') {
                        return Boolean.TRUE;
                    }
                }
                case 'f': {
                    if (s2.charAt(pos + 1) != 'a' || s2.charAt(pos + 2) != 'l' || s2.charAt(pos + 3) != 's' || s2.charAt(pos + 4) != 'e') break;
                    return Boolean.FALSE;
                }
            }
            throw new IllegalArgumentException(String.format("%s is not a valid value", s2));
        }
        throw new IllegalArgumentException(String.format("%s is not a valid value", s2));
    }

    static <T> List<T> parseList(String s2, Type type) {
        int pos = 0;
        int braceCounter = 0;
        ArrayList<Object> list2 = new ArrayList<Object>();
        StringBuilder builder = new StringBuilder();
        block6: while (pos < s2.length()) {
            char character = s2.charAt(pos);
            switch (character) {
                case ' ': {
                    ++pos;
                    continue block6;
                }
                case '[': {
                    if (braceCounter++ > 0) {
                        builder.append(s2.charAt(pos));
                    }
                    ++pos;
                    continue block6;
                }
                case ',': {
                    if (braceCounter == 1) {
                        Object o = ParseUtil.parseValue(builder.toString().trim(), type);
                        ParseUtil.assertType(o, type);
                        list2.add(o);
                        builder = new StringBuilder();
                    } else {
                        builder.append(s2.charAt(pos));
                    }
                    ++pos;
                    continue block6;
                }
                case ']': {
                    if (--braceCounter == 0) {
                        String value2 = builder.toString().trim();
                        if (!value2.isEmpty()) {
                            Object o = ParseUtil.parseValue(value2, type);
                            ParseUtil.assertType(o, type);
                            list2.add(o);
                        }
                    } else {
                        builder.append(s2.charAt(pos));
                    }
                    ++pos;
                    continue block6;
                }
            }
            builder.append(s2.charAt(pos++));
        }
        if (braceCounter != 0) {
            throw new IllegalArgumentException(String.format("%s contains unbalanced '[', ']'.", s2));
        }
        return list2;
    }

    private static void assertType(Object obj, Type type) {
        Class clazz;
        if (obj == null) {
            return;
        }
        if (type instanceof Class && !(clazz = (Class)type).isAssignableFrom(obj.getClass())) {
            throw new IllegalArgumentException(String.format("Expects a list of %s but got a list of %s", clazz.getSimpleName(), obj.getClass().getSimpleName()));
        }
    }
}

