/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.StringJoiner;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.schema.GenericKey;
import org.neo4j.kernel.impl.index.schema.Type;
import org.neo4j.kernel.impl.index.schema.ZonedDateTimeLayout;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.TimeZones;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.Values;

class ZonedDateTimeType
extends Type {
    ZonedDateTimeType(byte typeId) {
        super(ValueGroup.ZONED_DATE_TIME, typeId, DateTimeValue.MIN_VALUE, DateTimeValue.MAX_VALUE);
    }

    @Override
    int valueSize(GenericKey state) {
        return 16;
    }

    @Override
    void copyValue(GenericKey to2, GenericKey from2) {
        to2.long0 = from2.long0;
        to2.long1 = from2.long1;
        to2.long2 = from2.long2;
        to2.long3 = from2.long3;
    }

    @Override
    Value asValue(GenericKey state) {
        return ZonedDateTimeType.asValue(state.long0, state.long1, state.long2, state.long3);
    }

    @Override
    int compareValue(GenericKey left2, GenericKey right2) {
        return ZonedDateTimeType.compare(left2.long0, left2.long1, left2.long2, left2.long3, right2.long0, right2.long1, right2.long2, right2.long3);
    }

    @Override
    void putValue(PageCursor cursor, GenericKey state) {
        ZonedDateTimeType.put(cursor, state.long0, state.long1, state.long2, state.long3);
    }

    @Override
    boolean readValue(PageCursor cursor, int size2, GenericKey into) {
        return ZonedDateTimeType.read(cursor, into);
    }

    static int compare(long this_long0, long this_long1, long this_long2, long this_long3, long that_long0, long that_long1, long that_long2, long that_long3) {
        int compare = Long.compare(this_long0, that_long0);
        if (compare == 0 && (compare = Integer.compare((int)this_long1, (int)that_long1)) == 0 && TimeZones.validZoneOffset((int)this_long3) && TimeZones.validZoneOffset((int)that_long3)) {
            compare = Values.COMPARATOR.compare(ZonedDateTimeType.asValue(this_long0, this_long1, this_long2, this_long3), ZonedDateTimeType.asValue(that_long0, that_long1, that_long2, that_long3));
        }
        return compare;
    }

    static void put(PageCursor cursor, long long0, long long1, long long2, long long3) {
        cursor.putLong(long0);
        cursor.putInt((int)long1);
        if (long2 >= 0L) {
            cursor.putInt((int)long2 | 0x1000000);
        } else {
            cursor.putInt((int)long3 & 0xFFFFFF);
        }
    }

    static boolean read(PageCursor cursor, GenericKey into) {
        long epochSecondUTC = cursor.getLong();
        int nanoOfSecond = cursor.getInt();
        int encodedZone = cursor.getInt();
        if (ZonedDateTimeLayout.isZoneId(encodedZone)) {
            into.writeDateTime(epochSecondUTC, nanoOfSecond, ZonedDateTimeLayout.asZoneId(encodedZone));
        } else {
            into.writeDateTime(epochSecondUTC, nanoOfSecond, ZonedDateTimeLayout.asZoneOffset(encodedZone));
        }
        return true;
    }

    static DateTimeValue asValue(long long0, long long1, long long2, long long3) {
        return DateTimeValue.datetime(ZonedDateTimeType.asValueRaw(long0, long1, long2, long3));
    }

    static ZonedDateTime asValueRaw(long long0, long long1, long long2, long long3) {
        return TimeZones.validZoneId((short)long2) ? DateTimeValue.datetimeRaw(long0, long1, ZoneId.of(TimeZones.map((short)long2))) : DateTimeValue.datetimeRaw(long0, long1, ZoneOffset.ofTotalSeconds((int)long3));
    }

    void write(GenericKey state, long epochSecondUTC, int nano, short zoneId, int offsetSeconds) {
        state.long0 = epochSecondUTC;
        state.long1 = nano;
        state.long2 = zoneId;
        state.long3 = offsetSeconds;
    }

    @Override
    protected void addTypeSpecificDetails(StringJoiner joiner, GenericKey state) {
        joiner.add("long0=" + state.long0);
        joiner.add("long1=" + state.long1);
        joiner.add("long2=" + state.long2);
        joiner.add("long3=" + state.long3);
    }
}

