/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.NoSuchFileException;
import java.util.Collection;
import java.util.function.Consumer;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.index.internal.gbptree.Writer;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.api.index.sampling.UniqueIndexSampler;
import org.neo4j.kernel.impl.index.schema.CollectingIndexUpdater;
import org.neo4j.kernel.impl.index.schema.ConflictDetectingValueMerger;
import org.neo4j.kernel.impl.index.schema.ConsistencyCheckable;
import org.neo4j.kernel.impl.index.schema.DeferredConflictCheckingIndexUpdater;
import org.neo4j.kernel.impl.index.schema.FailureHeaderWriter;
import org.neo4j.kernel.impl.index.schema.FullScanNonUniqueIndexSampler;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.NativeIndex;
import org.neo4j.kernel.impl.index.schema.NativeIndexHeaderWriter;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexReader;
import org.neo4j.kernel.impl.index.schema.NativeIndexUpdater;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.ThrowingConflictDetector;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.storageengine.api.schema.IndexSample;
import org.neo4j.storageengine.api.schema.StoreIndexDescriptor;
import org.neo4j.util.Preconditions;
import org.neo4j.values.storable.Value;

public abstract class NativeIndexPopulator<KEY extends NativeIndexKey<KEY>, VALUE extends NativeIndexValue>
extends NativeIndex<KEY, VALUE>
implements IndexPopulator,
ConsistencyCheckable {
    public static final byte BYTE_FAILED = 0;
    static final byte BYTE_ONLINE = 1;
    static final byte BYTE_POPULATING = 2;
    private final KEY treeKey;
    private final VALUE treeValue;
    private final UniqueIndexSampler uniqueSampler;
    private final Consumer<PageCursor> additionalHeaderWriter;
    private ConflictDetectingValueMerger<KEY, VALUE, Value[]> mainConflictDetector;
    private ConflictDetectingValueMerger<KEY, VALUE, Value[]> updatesConflictDetector;
    private byte[] failureBytes;
    private boolean dropped;
    private boolean closed;

    NativeIndexPopulator(PageCache pageCache, FileSystemAbstraction fs, File storeFile, IndexLayout<KEY, VALUE> layout, IndexProvider.Monitor monitor, StoreIndexDescriptor descriptor, Consumer<PageCursor> additionalHeaderWriter) {
        super(pageCache, fs, storeFile, layout, monitor, descriptor, false);
        this.treeKey = (NativeIndexKey)layout.newKey();
        this.treeValue = layout.newValue();
        this.additionalHeaderWriter = additionalHeaderWriter;
        switch (descriptor.type()) {
            case GENERAL: {
                this.uniqueSampler = null;
                break;
            }
            case UNIQUE: {
                this.uniqueSampler = new UniqueIndexSampler();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected index type " + descriptor.type());
            }
        }
    }

    public void clear() {
        NativeIndexPopulator.deleteFileIfPresent(this.fileSystem, this.storeFile);
    }

    @Override
    public synchronized void create() {
        this.create(new NativeIndexHeaderWriter(2, this.additionalHeaderWriter));
    }

    protected synchronized void create(Consumer<PageCursor> headerWriter) {
        this.assertNotDropped();
        this.assertNotClosed();
        NativeIndexPopulator.deleteFileIfPresent(this.fileSystem, this.storeFile);
        this.instantiateTree(RecoveryCleanupWorkCollector.immediate(), headerWriter);
        this.mainConflictDetector = this.getMainConflictDetector();
        this.updatesConflictDetector = new ThrowingConflictDetector(true);
    }

    ConflictDetectingValueMerger<KEY, VALUE, Value[]> getMainConflictDetector() {
        return new ThrowingConflictDetector(this.descriptor.type() == IndexDescriptor.Type.GENERAL);
    }

    @Override
    public synchronized void drop() {
        try {
            this.closeTree();
            NativeIndexPopulator.deleteFileIfPresent(this.fileSystem, this.storeFile);
        }
        finally {
            this.dropped = true;
            this.closed = true;
        }
    }

    @Override
    public void add(Collection<? extends IndexEntryUpdate<?>> updates) throws IndexEntryConflictException {
        this.processUpdates(updates, this.mainConflictDetector);
    }

    @Override
    public void verifyDeferredConstraints(NodePropertyAccessor nodePropertyAccessor) throws IndexEntryConflictException {
    }

    @Override
    public IndexUpdater newPopulatingUpdater(NodePropertyAccessor accessor) {
        return this.newPopulatingUpdater();
    }

    IndexUpdater newPopulatingUpdater() {
        IndexUpdater updater = new CollectingIndexUpdater(updates -> this.processUpdates(updates, this.updatesConflictDetector));
        if (this.descriptor.type() == IndexDescriptor.Type.UNIQUE && this.canCheckConflictsWithoutStoreAccess()) {
            updater = new DeferredConflictCheckingIndexUpdater(updater, this::newReader, (IndexDescriptor)this.descriptor);
        }
        return updater;
    }

    boolean canCheckConflictsWithoutStoreAccess() {
        return true;
    }

    abstract NativeIndexReader<KEY, VALUE> newReader();

    @Override
    public synchronized void close(boolean populationCompletedSuccessfully) {
        if (populationCompletedSuccessfully && this.failureBytes != null) {
            throw new IllegalStateException("Can't mark index as online after it has been marked as failure");
        }
        try {
            this.assertNotDropped();
            if (populationCompletedSuccessfully) {
                this.assertPopulatorOpen();
                this.markTreeAsOnline();
            } else if (this.failureBytes != null) {
                this.ensureTreeInstantiated();
                this.markTreeAsFailed();
            }
        }
        finally {
            this.closeTree();
            this.closed = true;
        }
    }

    private void assertNotDropped() {
        if (this.dropped) {
            throw new IllegalStateException("Populator has already been dropped.");
        }
    }

    private void assertNotClosed() {
        if (this.closed) {
            throw new IllegalStateException("Populator has already been closed.");
        }
    }

    @Override
    public void markAsFailed(String failure) {
        this.failureBytes = failure.getBytes(StandardCharsets.UTF_8);
    }

    private void ensureTreeInstantiated() {
        if (this.tree == null) {
            this.instantiateTree(RecoveryCleanupWorkCollector.ignore(), GBPTree.NO_HEADER_WRITER);
        }
    }

    private void assertPopulatorOpen() {
        if (this.tree == null) {
            throw new IllegalStateException("Populator has already been closed.");
        }
    }

    private void markTreeAsFailed() {
        Preconditions.checkState(this.failureBytes != null, "markAsFailed hasn't been called, populator not actually failed?");
        this.tree.checkpoint(IOLimiter.UNLIMITED, (Consumer)new FailureHeaderWriter(this.failureBytes));
    }

    void markTreeAsOnline() {
        this.tree.checkpoint(IOLimiter.UNLIMITED, (Consumer)new NativeIndexHeaderWriter(1, this.additionalHeaderWriter));
    }

    private void processUpdates(Iterable<? extends IndexEntryUpdate<?>> indexEntryUpdates, ConflictDetectingValueMerger<KEY, VALUE, Value[]> conflictDetector) throws IndexEntryConflictException {
        try (Writer writer = this.tree.writer();){
            for (IndexEntryUpdate<?> indexEntryUpdate : indexEntryUpdates) {
                NativeIndexUpdater.processUpdate(this.treeKey, this.treeValue, indexEntryUpdate, writer, conflictDetector);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void includeSample(IndexEntryUpdate<?> update2) {
        switch (this.descriptor.type()) {
            case GENERAL: {
                break;
            }
            case UNIQUE: {
                this.updateUniqueSample(update2);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected index type " + this.descriptor.type());
            }
        }
    }

    private void updateUniqueSample(IndexEntryUpdate<?> update2) {
        switch (update2.updateMode()) {
            case ADDED: {
                this.uniqueSampler.increment(1L);
                break;
            }
            case REMOVED: {
                this.uniqueSampler.increment(-1L);
                break;
            }
            case CHANGED: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported update mode type:" + (Object)((Object)update2.updateMode()));
            }
        }
    }

    @Override
    public IndexSample sampleResult() {
        switch (this.descriptor.type()) {
            case GENERAL: {
                return new FullScanNonUniqueIndexSampler(this.tree, this.layout).result();
            }
            case UNIQUE: {
                return this.uniqueSampler.result();
            }
        }
        throw new IllegalArgumentException("Unexpected index type " + this.descriptor.type());
    }

    private static void deleteFileIfPresent(FileSystemAbstraction fs, File storeFile) {
        try {
            fs.deleteFileOrThrow(storeFile);
        }
        catch (NoSuchFileException noSuchFileException) {
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

