/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.gis.spatial.index.curves.SpaceFillingCurve;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.schema.AbstractArrayType;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.Type;
import org.neo4j.kernel.impl.index.schema.Types;
import org.neo4j.kernel.impl.index.schema.config.IndexSpecificSpaceFillingCurveSettingsCache;
import org.neo4j.string.UTF8;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.PrimitiveArrayWriting;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.TimeZones;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.ValueWriter;

public class GenericKey
extends NativeIndexKey<GenericKey> {
    static final int BIGGEST_STATIC_SIZE = 32;
    public static final int SIZE_GEOMETRY_HEADER = 3;
    public static final int SIZE_GEOMETRY = 8;
    static final int SIZE_GEOMETRY_COORDINATE = 8;
    public static final int SIZE_ZONED_DATE_TIME = 16;
    public static final int SIZE_LOCAL_DATE_TIME = 12;
    public static final int SIZE_DATE = 8;
    public static final int SIZE_ZONED_TIME = 12;
    public static final int SIZE_LOCAL_TIME = 8;
    public static final int SIZE_DURATION = 28;
    public static final int SIZE_STRING_LENGTH = 2;
    public static final int SIZE_BOOLEAN = 1;
    public static final int SIZE_NUMBER_TYPE = 1;
    public static final int SIZE_NUMBER_BYTE = 1;
    public static final int SIZE_NUMBER_SHORT = 2;
    public static final int SIZE_NUMBER_INT = 4;
    public static final int SIZE_NUMBER_LONG = 8;
    public static final int SIZE_NUMBER_FLOAT = 4;
    public static final int SIZE_NUMBER_DOUBLE = 8;
    public static final int SIZE_ARRAY_LENGTH = 2;
    static final int BIGGEST_REASONABLE_ARRAY_LENGTH = 4096;
    static final long TRUE = 1L;
    static final long FALSE = 0L;
    static final int NO_ENTITY_ID = -1;
    private static final int TYPE_ID_SIZE = 1;
    private static final double[] NO_COORDINATES = new double[0];
    private final IndexSpecificSpaceFillingCurveSettingsCache settings;
    Type type;
    NativeIndexKey.Inclusion inclusion;
    boolean isArray;
    long long0;
    long long1;
    long long2;
    long long3;
    byte[] byteArray;
    long[] long0Array;
    long[] long1Array;
    long[] long2Array;
    long[] long3Array;
    byte[][] byteArrayArray;
    boolean isHighestArray;
    int arrayLength;
    int currentArrayOffset;
    SpaceFillingCurve spaceFillingCurve;

    GenericKey(IndexSpecificSpaceFillingCurveSettingsCache settings) {
        this.settings = settings;
    }

    void clear() {
        if (this.type == Types.TEXT && Type.booleanOf(this.long1)) {
            this.byteArray = null;
        }
        this.type = null;
        this.long0 = 0L;
        this.long1 = 0L;
        this.long2 = 0L;
        this.long3 = 0L;
        this.inclusion = NativeIndexKey.Inclusion.NEUTRAL;
        this.isArray = false;
        this.arrayLength = 0;
        this.isHighestArray = false;
        this.currentArrayOffset = 0;
        this.spaceFillingCurve = null;
    }

    void initializeToDummyValue() {
        this.setEntityId(Long.MIN_VALUE);
        this.initializeToDummyValueInternal();
    }

    void initializeToDummyValueInternal() {
        this.clear();
        this.writeInteger(0);
        this.inclusion = NativeIndexKey.Inclusion.NEUTRAL;
    }

    void initValueAsLowest(ValueGroup valueGroup) {
        this.clear();
        this.type = valueGroup == ValueGroup.UNKNOWN ? Types.LOWEST_BY_VALUE_GROUP : Types.BY_GROUP[valueGroup.ordinal()];
        this.type.initializeAsLowest(this);
    }

    void initValueAsHighest(ValueGroup valueGroup) {
        this.clear();
        this.type = valueGroup == ValueGroup.UNKNOWN ? Types.HIGHEST_BY_VALUE_GROUP : Types.BY_GROUP[valueGroup.ordinal()];
        this.type.initializeAsHighest(this);
    }

    void initAsPrefixLow(TextValue prefix) {
        prefix.writeTo(this);
        this.long2 = 0L;
        this.inclusion = NativeIndexKey.Inclusion.LOW;
    }

    void initAsPrefixHigh(TextValue prefix) {
        prefix.writeTo(this);
        this.long2 = 1L;
        this.inclusion = NativeIndexKey.Inclusion.HIGH;
    }

    void copyFrom(GenericKey key) {
        this.setEntityId(key.getEntityId());
        this.setCompareId(key.getCompareId());
        this.copyFromInternal(key);
    }

    void copyFromInternal(GenericKey key) {
        this.copyMetaFrom(key);
        this.type.copyValue(this, key);
    }

    void copyMetaFrom(GenericKey key) {
        this.type = key.type;
        this.inclusion = key.inclusion;
        this.isArray = key.isArray;
        if (key.isArray) {
            this.arrayLength = key.arrayLength;
            this.currentArrayOffset = key.currentArrayOffset;
            this.isHighestArray = key.isHighestArray;
        }
    }

    void writeValue(Value value2, NativeIndexKey.Inclusion inclusion) {
        this.isArray = false;
        value2.writeTo(this);
        this.inclusion = inclusion;
    }

    @Override
    void writeValue(int stateSlot, Value value2, NativeIndexKey.Inclusion inclusion) {
        this.writeValue(value2, inclusion);
    }

    @Override
    void assertValidValue(int stateSlot, Value value2) {
    }

    @Override
    Value[] asValues() {
        return new Value[]{this.asValue()};
    }

    @Override
    void initValueAsLowest(int stateSlot, ValueGroup valueGroup) {
        this.initValueAsLowest(valueGroup);
    }

    @Override
    void initValueAsHighest(int stateSlot, ValueGroup valueGroup) {
        this.initValueAsHighest(valueGroup);
    }

    GenericKey stateSlot(int slot) {
        assert (slot == 0);
        return this;
    }

    @Override
    int numberOfStateSlots() {
        return 1;
    }

    @Override
    int compareValueTo(GenericKey other2) {
        return this.compareValueToInternal(other2);
    }

    int compareValueToInternal(GenericKey other2) {
        if (this.type != other2.type) {
            if (this.type == null) {
                return -1;
            }
            if (other2.type == null) {
                return 1;
            }
            return Type.COMPARATOR.compare(this.type, other2.type);
        }
        int valueComparison = this.type.compareValue(this, other2);
        if (valueComparison != 0) {
            return valueComparison;
        }
        return this.inclusion.compareTo(other2.inclusion);
    }

    void minimalSplitter(GenericKey left2, GenericKey right2, GenericKey into) {
        into.setCompareId(right2.getCompareId());
        if (left2.compareValueTo(right2) != 0) {
            into.setEntityId(-1L);
        } else {
            into.setEntityId(right2.getEntityId());
        }
        this.minimalSplitterInternal(left2, right2, into);
    }

    void minimalSplitterInternal(GenericKey left2, GenericKey right2, GenericKey into) {
        into.clear();
        into.copyMetaFrom(right2);
        right2.type.minimalSplitter(left2, right2, into);
    }

    int size() {
        return 8 + this.sizeInternal();
    }

    int sizeInternal() {
        return this.type.valueSize(this) + 1;
    }

    Value asValue() {
        return this.type.asValue(this);
    }

    void put(PageCursor cursor) {
        cursor.putLong(this.getEntityId());
        this.putInternal(cursor);
    }

    void putInternal(PageCursor cursor) {
        cursor.putByte(this.type.typeId);
        this.type.putValue(cursor, this);
    }

    boolean get(PageCursor cursor, int size2) {
        if (size2 < 8) {
            this.initializeToDummyValue();
            cursor.setCursorException(String.format("Failed to read " + this.getClass().getSimpleName() + " due to keySize < ENTITY_ID_SIZE, more precisely %d", size2));
            return false;
        }
        this.initialize(cursor.getLong());
        if (!this.getInternal(cursor, size2)) {
            this.initializeToDummyValue();
            return false;
        }
        return true;
    }

    boolean getInternal(PageCursor cursor, int size2) {
        if (size2 <= 1) {
            GenericKey.setCursorException(cursor, "slot size less than TYPE_ID_SIZE, " + size2);
            return false;
        }
        byte typeId = cursor.getByte();
        if (typeId < 0 || typeId >= Types.BY_ID.length) {
            GenericKey.setCursorException(cursor, "non-valid typeId, " + typeId);
            return false;
        }
        this.inclusion = NativeIndexKey.Inclusion.NEUTRAL;
        return this.setType(Types.BY_ID[typeId]).readValue(cursor, size2 - 1, this);
    }

    private <T extends Type> T setType(T type) {
        if (this.type != null && type != this.type) {
            this.clear();
        }
        this.type = type;
        return type;
    }

    @Override
    protected void writeDate(long epochDay) {
        if (!this.isArray) {
            this.setType(Types.DATE).write(this, epochDay);
        } else {
            Types.DATE_ARRAY.write(this, this.currentArrayOffset++, epochDay);
        }
    }

    @Override
    protected void writeLocalTime(long nanoOfDay) {
        if (!this.isArray) {
            this.setType(Types.LOCAL_TIME).write(this, nanoOfDay);
        } else {
            Types.LOCAL_TIME_ARRAY.write(this, this.currentArrayOffset++, nanoOfDay);
        }
    }

    @Override
    protected void writeTime(long nanosOfDayUTC, int offsetSeconds) {
        if (!this.isArray) {
            this.setType(Types.ZONED_TIME).write(this, nanosOfDayUTC, offsetSeconds);
        } else {
            Types.ZONED_TIME_ARRAY.write(this, this.currentArrayOffset++, nanosOfDayUTC, offsetSeconds);
        }
    }

    @Override
    protected void writeLocalDateTime(long epochSecond, int nano) {
        if (!this.isArray) {
            this.setType(Types.LOCAL_DATE_TIME).write(this, epochSecond, nano);
        } else {
            Types.LOCAL_DATE_TIME_ARRAY.write(this, this.currentArrayOffset++, epochSecond, nano);
        }
    }

    @Override
    protected void writeDateTime(long epochSecondUTC, int nano, int offsetSeconds) {
        this.writeDateTime(epochSecondUTC, nano, (short)-1, offsetSeconds);
    }

    @Override
    protected void writeDateTime(long epochSecondUTC, int nano, String zoneId) {
        this.writeDateTime(epochSecondUTC, nano, TimeZones.map(zoneId));
    }

    protected void writeDateTime(long epochSecondUTC, int nano, short zoneId) {
        this.writeDateTime(epochSecondUTC, nano, zoneId, 0);
    }

    private void writeDateTime(long epochSecondUTC, int nano, short zoneId, int offsetSeconds) {
        if (!this.isArray) {
            this.setType(Types.ZONED_DATE_TIME).write(this, epochSecondUTC, nano, zoneId, offsetSeconds);
        } else {
            Types.ZONED_DATE_TIME_ARRAY.write(this, this.currentArrayOffset++, epochSecondUTC, nano, zoneId, offsetSeconds);
        }
    }

    @Override
    public void writeBoolean(boolean value2) {
        if (!this.isArray) {
            this.setType(Types.BOOLEAN).write(this, value2);
        } else {
            Types.BOOLEAN_ARRAY.write(this, this.currentArrayOffset++, value2);
        }
    }

    private void writeNumber(long value2, byte numberType) {
        if (!this.isArray) {
            this.setType(Types.NUMBER).write(this, value2, numberType);
        } else {
            Types.NUMBER_ARRAY.write(this, this.currentArrayOffset++, value2);
        }
    }

    @Override
    public void writeInteger(byte value2) {
        this.writeNumber(value2, (byte)0);
    }

    @Override
    public void writeInteger(short value2) {
        this.writeNumber(value2, (byte)1);
    }

    @Override
    public void writeInteger(int value2) {
        this.writeNumber(value2, (byte)2);
    }

    static short toNonNegativeShortExact(long value2) {
        if ((value2 & 0xFFFFFFFFFFFF8000L) != 0L) {
            throw new IllegalArgumentException(value2 + " is bigger than maximum for a signed short (2B) " + Short.MAX_VALUE);
        }
        return (short)value2;
    }

    @Override
    public void writeInteger(long value2) {
        this.writeNumber(value2, (byte)3);
    }

    @Override
    public void writeFloatingPoint(float value2) {
        this.writeNumber(Float.floatToIntBits(value2), (byte)4);
    }

    @Override
    public void writeFloatingPoint(double value2) {
        this.writeNumber(Double.doubleToLongBits(value2), (byte)5);
    }

    @Override
    public void writeString(String value2) {
        this.writeStringBytes(UTF8.encode(value2), false);
    }

    @Override
    public void writeString(char value2) {
        this.writeStringBytes(UTF8.encode(String.valueOf(value2)), true);
    }

    @Override
    public void writeUTF8(byte[] bytes2, int offset, int length2) {
        byte[] dest = new byte[length2];
        System.arraycopy(bytes2, offset, dest, 0, length2);
        this.writeStringBytes(dest, false);
    }

    private void writeStringBytes(byte[] bytes2, boolean isCharType) {
        if (!this.isArray) {
            this.setType(Types.TEXT).write(this, bytes2, isCharType);
        } else {
            Types.TEXT_ARRAY.write(this, this.currentArrayOffset++, bytes2);
        }
        this.long1 = 0L;
    }

    @Override
    public void writeDuration(long months, long days, long seconds, int nanos) {
        long totalAvgSeconds = months * 2629800L + days * 86400L + seconds;
        this.writeDurationWithTotalAvgSeconds(months, days, totalAvgSeconds, nanos);
    }

    @Override
    public void writePoint(CoordinateReferenceSystem crs, double[] coordinate) {
        if (!this.isArray) {
            this.setType(Types.GEOMETRY);
            this.updateCurve(crs.getTable().getTableId(), crs.getCode());
            Types.GEOMETRY.write(this, this.spaceFillingCurve.derivedValueFor(coordinate), coordinate);
        } else {
            if (this.currentArrayOffset == 0) {
                this.updateCurve(crs.getTable().getTableId(), crs.getCode());
            } else if (this.long1 != (long)crs.getTable().getTableId() || this.long2 != (long)crs.getCode()) {
                throw new IllegalStateException(String.format("Tried to assign a geometry array containing different coordinate reference systems, first:%s, violating:%s at array position:%d", CoordinateReferenceSystem.get((int)this.long1, (int)this.long2), crs, this.currentArrayOffset));
            }
            Types.GEOMETRY_ARRAY.write(this, this.currentArrayOffset++, this.spaceFillingCurve.derivedValueFor(coordinate), coordinate);
        }
    }

    void writePointDerived(CoordinateReferenceSystem crs, long derivedValue, NativeIndexKey.Inclusion inclusion) {
        if (this.isArray) {
            throw new IllegalStateException("This method is intended to be called when querying, where one or more sub-ranges are derived from a queried range and each sub-range written to separate keys. As such it's unexpected that this key state thinks that it's holds state for an array");
        }
        this.updateCurve(crs.getTable().getTableId(), crs.getCode());
        this.setType(Types.GEOMETRY).write(this, derivedValue, NO_COORDINATES);
        this.inclusion = inclusion;
    }

    private void updateCurve(int tableId, int code) {
        if (this.long1 != (long)tableId || this.long2 != (long)code) {
            this.long1 = tableId;
            this.long2 = code;
            this.spaceFillingCurve = this.settings.forCrs(tableId, code, true);
        }
    }

    void writeDurationWithTotalAvgSeconds(long months, long days, long totalAvgSeconds, int nanos) {
        if (!this.isArray) {
            this.setType(Types.DURATION).write(this, months, days, totalAvgSeconds, nanos);
        } else {
            Types.DURATION_ARRAY.write(this, this.currentArrayOffset++, months, days, totalAvgSeconds, nanos);
        }
    }

    @Override
    public void writeByteArray(byte[] value2) {
        PrimitiveArrayWriting.writeTo(this, value2);
    }

    @Override
    public void beginArray(int size2, ValueWriter.ArrayType arrayType) {
        AbstractArrayType arrayValueType = Types.BY_ARRAY_TYPE[arrayType.ordinal()];
        this.setType(arrayValueType);
        this.initializeArrayMeta(size2);
        arrayValueType.initializeArray(this, size2, arrayType);
    }

    void initializeArrayMeta(int size2) {
        this.isArray = true;
        this.arrayLength = size2;
        this.currentArrayOffset = 0;
    }

    @Override
    public void endArray() {
    }

    public String toString() {
        return "[" + this.toStringInternal() + "],entityId=" + this.getEntityId();
    }

    String toStringInternal() {
        return this.type.toString(this);
    }

    String toDetailedString() {
        return "[" + this.toDetailedStringInternal() + "],entityId=" + this.getEntityId();
    }

    String toDetailedStringInternal() {
        return this.type.toDetailedString(this);
    }

    static void setCursorException(PageCursor cursor, String reason) {
        cursor.setCursorException(String.format("Unable to read generic key slot due to %s", reason));
    }
}

