/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.kernel.impl.index.schema.NativeIndexSingleValueKey;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;

class DurationIndexKey
extends NativeIndexSingleValueKey<DurationIndexKey> {
    static final long AVG_MONTH_SECONDS = 2629800L;
    static final long AVG_DAY_SECONDS = 86400L;
    static final int SIZE = 36;
    long totalAvgSeconds;
    int nanosOfSecond;
    long months;
    long days;

    DurationIndexKey() {
    }

    @Override
    public Value asValue() {
        long seconds = this.totalAvgSeconds - this.months * 2629800L - this.days * 86400L;
        return DurationValue.duration(this.months, this.days, seconds, this.nanosOfSecond);
    }

    @Override
    public void initValueAsLowest(ValueGroup valueGroups) {
        this.totalAvgSeconds = Long.MIN_VALUE;
        this.nanosOfSecond = Integer.MIN_VALUE;
        this.months = Long.MIN_VALUE;
        this.days = Long.MIN_VALUE;
    }

    @Override
    public void initValueAsHighest(ValueGroup valueGroups) {
        this.totalAvgSeconds = Long.MAX_VALUE;
        this.nanosOfSecond = Integer.MAX_VALUE;
        this.months = Long.MAX_VALUE;
        this.days = Long.MAX_VALUE;
    }

    @Override
    public int compareValueTo(DurationIndexKey other2) {
        int comparison = Long.compare(this.totalAvgSeconds, other2.totalAvgSeconds);
        if (comparison == 0 && (comparison = Integer.compare(this.nanosOfSecond, other2.nanosOfSecond)) == 0 && (comparison = Long.compare(this.months, other2.months)) == 0) {
            comparison = Long.compare(this.days, other2.days);
        }
        return comparison;
    }

    public String toString() {
        return String.format("value=%s,entityId=%d,totalAvgSeconds=%d,nanosOfSecond=%d,months=%d,days=%d", this.asValue(), this.getEntityId(), this.totalAvgSeconds, this.nanosOfSecond, this.months, this.days);
    }

    @Override
    public void writeDuration(long months, long days, long seconds, int nanos) {
        this.totalAvgSeconds = months * 2629800L + days * 86400L + seconds;
        this.nanosOfSecond = nanos;
        this.months = months;
        this.days = days;
    }

    @Override
    protected Value assertCorrectType(Value value2) {
        if (!(value2 instanceof DurationValue)) {
            throw new IllegalArgumentException("Key layout does only support DurationValue, tried to create key from " + value2);
        }
        return value2;
    }
}

