/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.labelscan;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.NoSuchElementException;
import org.neo4j.collection.PrimitiveLongResourceIterator;
import org.neo4j.cursor.RawCursor;
import org.neo4j.index.internal.gbptree.Hit;
import org.neo4j.kernel.impl.index.labelscan.LabelScanKey;
import org.neo4j.kernel.impl.index.labelscan.LabelScanValue;
import org.neo4j.kernel.impl.index.labelscan.LabelScanValueIndexAccessor;
import org.neo4j.kernel.impl.index.labelscan.NativeLabelScanWriter;

class LabelScanValueIterator
extends LabelScanValueIndexAccessor
implements PrimitiveLongResourceIterator {
    private long fromId;
    private boolean hasNextDecided;
    private boolean hasNext;
    protected long next;

    LabelScanValueIterator(RawCursor<Hit<LabelScanKey, LabelScanValue>, IOException> cursor, Collection<RawCursor<Hit<LabelScanKey, LabelScanValue>, IOException>> toRemoveFromWhenClosed, long fromId) {
        super(toRemoveFromWhenClosed, cursor);
        this.fromId = fromId;
    }

    public boolean hasNext() {
        if (!this.hasNextDecided) {
            this.hasNext = this.fetchNext();
            this.hasNextDecided = true;
        }
        return this.hasNext;
    }

    public long next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more elements in " + this);
        }
        this.hasNextDecided = false;
        return this.next;
    }

    protected boolean fetchNext() {
        Hit hit;
        while (true) {
            if (this.bits != 0L) {
                int delta = Long.numberOfTrailingZeros(this.bits);
                this.bits &= this.bits - 1L;
                this.next = this.baseNodeId + (long)delta;
                this.hasNext = true;
                return true;
            }
            try {
                if (!this.cursor.next()) {
                    this.close();
                    return false;
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            hit = (Hit)this.cursor.get();
            this.baseNodeId = ((LabelScanKey)hit.key()).idRange * 64L;
            this.bits = ((LabelScanValue)hit.value()).bits;
            if (this.fromId == -1L) continue;
            long range2 = NativeLabelScanWriter.rangeOf(this.fromId);
            if (range2 == ((LabelScanKey)hit.key()).idRange) {
                long relativeStartId = this.fromId % 64L;
                long mask = relativeStartId == 63L ? -1L : (1L << (int)(relativeStartId + 1L)) - 1L;
                this.bits &= mask ^ 0xFFFFFFFFFFFFFFFFL;
            }
            this.fromId = -1L;
            assert (this.keysInOrder((LabelScanKey)hit.key()));
        }
    }
}

