/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Iterator;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Resource;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.PrefetchingResourceIterator;
import org.neo4j.internal.kernel.api.NamedToken;
import org.neo4j.internal.kernel.api.SchemaReadCore;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.Statement;

public abstract class TokenAccess<R> {
    public static final TokenAccess<RelationshipType> RELATIONSHIP_TYPES = new TokenAccess<RelationshipType>(){

        @Override
        Iterator<NamedToken> tokens(TokenRead read) {
            return read.relationshipTypesGetAllTokens();
        }

        @Override
        RelationshipType token(NamedToken token) {
            return RelationshipType.withName(token.name());
        }

        @Override
        boolean inUse(KernelTransaction transaction, SchemaReadCore schemaReadCore, int tokenId) {
            return TokenAccess.hasAny(schemaReadCore.indexesGetForRelationshipType(tokenId)) || TokenAccess.hasAny(schemaReadCore.constraintsGetForRelationshipType(tokenId)) || transaction.dataRead().countsForRelationship(-1, tokenId, -1) > 0L;
        }
    };
    public static final TokenAccess<Label> LABELS = new TokenAccess<Label>(){

        @Override
        Iterator<NamedToken> tokens(TokenRead read) {
            return read.labelsGetAllTokens();
        }

        @Override
        Label token(NamedToken token) {
            return Label.label(token.name());
        }

        @Override
        boolean inUse(KernelTransaction transaction, SchemaReadCore schemaReadCore, int tokenId) {
            return TokenAccess.hasAny(schemaReadCore.indexesGetForLabel(tokenId)) || TokenAccess.hasAny(schemaReadCore.constraintsGetForLabel(tokenId)) || transaction.dataRead().countsForNode(tokenId) > 0L;
        }
    };
    public static final TokenAccess<String> PROPERTY_KEYS = new TokenAccess<String>(){

        @Override
        Iterator<NamedToken> tokens(TokenRead read) {
            return read.propertyKeyGetAllTokens();
        }

        @Override
        String token(NamedToken token) {
            return token.name();
        }

        @Override
        boolean inUse(KernelTransaction transaction, SchemaReadCore schemaReadCore, int tokenId) {
            return true;
        }
    };

    public final ResourceIterator<R> inUse(KernelTransaction transaction) {
        return TokenIterator.inUse(transaction, this);
    }

    public final ResourceIterator<R> all(KernelTransaction transaction) {
        return TokenIterator.all(transaction, this);
    }

    private static boolean hasAny(Iterator<?> iter2) {
        if (iter2.hasNext()) {
            return true;
        }
        if (iter2 instanceof Resource) {
            ((Resource)iter2).close();
        }
        return false;
    }

    abstract Iterator<NamedToken> tokens(TokenRead var1);

    abstract R token(NamedToken var1);

    abstract boolean inUse(KernelTransaction var1, SchemaReadCore var2, int var3);

    private static abstract class TokenIterator<T>
    extends PrefetchingResourceIterator<T> {
        private Statement statement;
        protected final TokenAccess<T> access;
        protected final Iterator<NamedToken> tokens;

        private TokenIterator(KernelTransaction transaction, TokenAccess<T> access) {
            this.access = access;
            this.statement = transaction.acquireStatement();
            try {
                this.tokens = access.tokens(transaction.tokenRead());
            }
            catch (Exception e) {
                this.close();
                throw e;
            }
        }

        public void close() {
            if (this.statement != null) {
                this.statement.close();
                this.statement = null;
            }
        }

        static <T> ResourceIterator<T> inUse(final KernelTransaction transaction, TokenAccess<T> access) {
            final SchemaReadCore schemaReadCore = transaction.schemaRead().snapshot();
            return new TokenIterator<T>(transaction, access){

                protected T fetchNextOrNull() {
                    while (this.tokens.hasNext()) {
                        NamedToken token = (NamedToken)this.tokens.next();
                        if (!this.access.inUse(transaction, schemaReadCore, token.id())) continue;
                        return this.access.token(token);
                    }
                    this.close();
                    return null;
                }
            };
        }

        static <T> ResourceIterator<T> all(KernelTransaction transaction, TokenAccess<T> access) {
            return new TokenIterator<T>(transaction, (TokenAccess)access){

                protected T fetchNextOrNull() {
                    if (this.tokens.hasNext()) {
                        return this.access.token((NamedToken)this.tokens.next());
                    }
                    this.close();
                    return null;
                }
            };
        }
    }
}

