/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.buffer;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.charset.Charset;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBufAllocator;
import org.neo4j.driver.internal.shaded.io.netty.buffer.Unpooled;
import org.neo4j.driver.internal.shaded.io.netty.util.ByteProcessor;
import org.neo4j.driver.internal.shaded.io.netty.util.internal.EmptyArrays;
import org.neo4j.driver.internal.shaded.io.netty.util.internal.PlatformDependent;
import org.neo4j.driver.internal.shaded.io.netty.util.internal.StringUtil;

public final class EmptyByteBuf
extends ByteBuf {
    private static final ByteBuffer EMPTY_BYTE_BUFFER = ByteBuffer.allocateDirect(0);
    private static final long EMPTY_BYTE_BUFFER_ADDRESS;
    private final ByteBufAllocator alloc;
    private final ByteOrder order;
    private final String str;
    private EmptyByteBuf swapped;

    public EmptyByteBuf(ByteBufAllocator alloc) {
        this(alloc, ByteOrder.BIG_ENDIAN);
    }

    private EmptyByteBuf(ByteBufAllocator alloc, ByteOrder order) {
        if (alloc == null) {
            throw new NullPointerException("alloc");
        }
        this.alloc = alloc;
        this.order = order;
        this.str = StringUtil.simpleClassName(this) + (order == ByteOrder.BIG_ENDIAN ? "BE" : "LE");
    }

    @Override
    public int capacity() {
        return 0;
    }

    @Override
    public ByteBuf capacity(int newCapacity) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.alloc;
    }

    @Override
    public ByteOrder order() {
        return this.order;
    }

    @Override
    public ByteBuf unwrap() {
        return null;
    }

    @Override
    public ByteBuf asReadOnly() {
        return Unpooled.unmodifiableBuffer((ByteBuf)this);
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    public int maxCapacity() {
        return 0;
    }

    @Override
    public ByteBuf order(ByteOrder endianness) {
        if (endianness == null) {
            throw new NullPointerException("endianness");
        }
        if (endianness == this.order()) {
            return this;
        }
        EmptyByteBuf swapped = this.swapped;
        if (swapped != null) {
            return swapped;
        }
        this.swapped = swapped = new EmptyByteBuf(this.alloc(), endianness);
        return swapped;
    }

    @Override
    public int readerIndex() {
        return 0;
    }

    @Override
    public ByteBuf readerIndex(int readerIndex) {
        return this.checkIndex(readerIndex);
    }

    @Override
    public int writerIndex() {
        return 0;
    }

    @Override
    public ByteBuf writerIndex(int writerIndex) {
        return this.checkIndex(writerIndex);
    }

    @Override
    public ByteBuf setIndex(int readerIndex, int writerIndex) {
        this.checkIndex(readerIndex);
        this.checkIndex(writerIndex);
        return this;
    }

    @Override
    public int readableBytes() {
        return 0;
    }

    @Override
    public int writableBytes() {
        return 0;
    }

    @Override
    public int maxWritableBytes() {
        return 0;
    }

    @Override
    public boolean isReadable() {
        return false;
    }

    @Override
    public boolean isWritable() {
        return false;
    }

    @Override
    public ByteBuf clear() {
        return this;
    }

    @Override
    public ByteBuf markReaderIndex() {
        return this;
    }

    @Override
    public ByteBuf resetReaderIndex() {
        return this;
    }

    @Override
    public ByteBuf markWriterIndex() {
        return this;
    }

    @Override
    public ByteBuf resetWriterIndex() {
        return this;
    }

    @Override
    public ByteBuf discardReadBytes() {
        return this;
    }

    @Override
    public ByteBuf discardSomeReadBytes() {
        return this;
    }

    @Override
    public ByteBuf ensureWritable(int minWritableBytes) {
        if (minWritableBytes < 0) {
            throw new IllegalArgumentException("minWritableBytes: " + minWritableBytes + " (expected: >= 0)");
        }
        if (minWritableBytes != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }

    @Override
    public int ensureWritable(int minWritableBytes, boolean force) {
        if (minWritableBytes < 0) {
            throw new IllegalArgumentException("minWritableBytes: " + minWritableBytes + " (expected: >= 0)");
        }
        if (minWritableBytes == 0) {
            return 0;
        }
        return 1;
    }

    @Override
    public boolean getBoolean(int index) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public byte getByte(int index) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public short getUnsignedByte(int index) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public short getShort(int index) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public short getShortLE(int index) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int getUnsignedShort(int index) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int getUnsignedShortLE(int index) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int getMedium(int index) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int getMediumLE(int index) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int getUnsignedMedium(int index) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int getUnsignedMediumLE(int index) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int getInt(int index) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int getIntLE(int index) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public long getUnsignedInt(int index) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public long getUnsignedIntLE(int index) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public long getLong(int index) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public long getLongLE(int index) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public char getChar(int index) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public float getFloat(int index) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public double getDouble(int index) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ByteBuf getBytes(int index, ByteBuf dst) {
        return this.checkIndex(index, dst.writableBytes());
    }

    @Override
    public ByteBuf getBytes(int index, ByteBuf dst, int length2) {
        return this.checkIndex(index, length2);
    }

    @Override
    public ByteBuf getBytes(int index, ByteBuf dst, int dstIndex, int length2) {
        return this.checkIndex(index, length2);
    }

    @Override
    public ByteBuf getBytes(int index, byte[] dst) {
        return this.checkIndex(index, dst.length);
    }

    @Override
    public ByteBuf getBytes(int index, byte[] dst, int dstIndex, int length2) {
        return this.checkIndex(index, length2);
    }

    @Override
    public ByteBuf getBytes(int index, ByteBuffer dst) {
        return this.checkIndex(index, dst.remaining());
    }

    @Override
    public ByteBuf getBytes(int index, OutputStream out, int length2) {
        return this.checkIndex(index, length2);
    }

    @Override
    public int getBytes(int index, GatheringByteChannel out, int length2) {
        this.checkIndex(index, length2);
        return 0;
    }

    @Override
    public int getBytes(int index, FileChannel out, long position2, int length2) {
        this.checkIndex(index, length2);
        return 0;
    }

    @Override
    public CharSequence getCharSequence(int index, int length2, Charset charset) {
        this.checkIndex(index, length2);
        return null;
    }

    @Override
    public ByteBuf setBoolean(int index, boolean value2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ByteBuf setByte(int index, int value2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ByteBuf setShort(int index, int value2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ByteBuf setShortLE(int index, int value2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ByteBuf setMedium(int index, int value2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ByteBuf setMediumLE(int index, int value2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ByteBuf setInt(int index, int value2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ByteBuf setIntLE(int index, int value2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ByteBuf setLong(int index, long value2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ByteBuf setLongLE(int index, long value2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ByteBuf setChar(int index, int value2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ByteBuf setFloat(int index, float value2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ByteBuf setDouble(int index, double value2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ByteBuf setBytes(int index, ByteBuf src) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ByteBuf setBytes(int index, ByteBuf src, int length2) {
        return this.checkIndex(index, length2);
    }

    @Override
    public ByteBuf setBytes(int index, ByteBuf src, int srcIndex, int length2) {
        return this.checkIndex(index, length2);
    }

    @Override
    public ByteBuf setBytes(int index, byte[] src) {
        return this.checkIndex(index, src.length);
    }

    @Override
    public ByteBuf setBytes(int index, byte[] src, int srcIndex, int length2) {
        return this.checkIndex(index, length2);
    }

    @Override
    public ByteBuf setBytes(int index, ByteBuffer src) {
        return this.checkIndex(index, src.remaining());
    }

    @Override
    public int setBytes(int index, InputStream in2, int length2) {
        this.checkIndex(index, length2);
        return 0;
    }

    @Override
    public int setBytes(int index, ScatteringByteChannel in2, int length2) {
        this.checkIndex(index, length2);
        return 0;
    }

    @Override
    public int setBytes(int index, FileChannel in2, long position2, int length2) {
        this.checkIndex(index, length2);
        return 0;
    }

    @Override
    public ByteBuf setZero(int index, int length2) {
        return this.checkIndex(index, length2);
    }

    @Override
    public int setCharSequence(int index, CharSequence sequence2, Charset charset) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public boolean readBoolean() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public byte readByte() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public short readUnsignedByte() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public short readShort() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public short readShortLE() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int readUnsignedShort() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int readUnsignedShortLE() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int readMedium() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int readMediumLE() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int readUnsignedMedium() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int readUnsignedMediumLE() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int readInt() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int readIntLE() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public long readUnsignedInt() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public long readUnsignedIntLE() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public long readLong() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public long readLongLE() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public char readChar() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public float readFloat() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public double readDouble() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ByteBuf readBytes(int length2) {
        return this.checkLength(length2);
    }

    @Override
    public ByteBuf readSlice(int length2) {
        return this.checkLength(length2);
    }

    @Override
    public ByteBuf readRetainedSlice(int length2) {
        return this.checkLength(length2);
    }

    @Override
    public ByteBuf readBytes(ByteBuf dst) {
        return this.checkLength(dst.writableBytes());
    }

    @Override
    public ByteBuf readBytes(ByteBuf dst, int length2) {
        return this.checkLength(length2);
    }

    @Override
    public ByteBuf readBytes(ByteBuf dst, int dstIndex, int length2) {
        return this.checkLength(length2);
    }

    @Override
    public ByteBuf readBytes(byte[] dst) {
        return this.checkLength(dst.length);
    }

    @Override
    public ByteBuf readBytes(byte[] dst, int dstIndex, int length2) {
        return this.checkLength(length2);
    }

    @Override
    public ByteBuf readBytes(ByteBuffer dst) {
        return this.checkLength(dst.remaining());
    }

    @Override
    public ByteBuf readBytes(OutputStream out, int length2) {
        return this.checkLength(length2);
    }

    @Override
    public int readBytes(GatheringByteChannel out, int length2) {
        this.checkLength(length2);
        return 0;
    }

    @Override
    public int readBytes(FileChannel out, long position2, int length2) {
        this.checkLength(length2);
        return 0;
    }

    @Override
    public CharSequence readCharSequence(int length2, Charset charset) {
        this.checkLength(length2);
        return null;
    }

    @Override
    public ByteBuf skipBytes(int length2) {
        return this.checkLength(length2);
    }

    @Override
    public ByteBuf writeBoolean(boolean value2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ByteBuf writeByte(int value2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ByteBuf writeShort(int value2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ByteBuf writeShortLE(int value2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ByteBuf writeMedium(int value2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ByteBuf writeMediumLE(int value2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ByteBuf writeInt(int value2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ByteBuf writeIntLE(int value2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ByteBuf writeLong(long value2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ByteBuf writeLongLE(long value2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ByteBuf writeChar(int value2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ByteBuf writeFloat(float value2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ByteBuf writeDouble(double value2) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ByteBuf writeBytes(ByteBuf src) {
        return this.checkLength(src.readableBytes());
    }

    @Override
    public ByteBuf writeBytes(ByteBuf src, int length2) {
        return this.checkLength(length2);
    }

    @Override
    public ByteBuf writeBytes(ByteBuf src, int srcIndex, int length2) {
        return this.checkLength(length2);
    }

    @Override
    public ByteBuf writeBytes(byte[] src) {
        return this.checkLength(src.length);
    }

    @Override
    public ByteBuf writeBytes(byte[] src, int srcIndex, int length2) {
        return this.checkLength(length2);
    }

    @Override
    public ByteBuf writeBytes(ByteBuffer src) {
        return this.checkLength(src.remaining());
    }

    @Override
    public int writeBytes(InputStream in2, int length2) {
        this.checkLength(length2);
        return 0;
    }

    @Override
    public int writeBytes(ScatteringByteChannel in2, int length2) {
        this.checkLength(length2);
        return 0;
    }

    @Override
    public int writeBytes(FileChannel in2, long position2, int length2) {
        this.checkLength(length2);
        return 0;
    }

    @Override
    public ByteBuf writeZero(int length2) {
        return this.checkLength(length2);
    }

    @Override
    public int writeCharSequence(CharSequence sequence2, Charset charset) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int indexOf(int fromIndex, int toIndex, byte value2) {
        this.checkIndex(fromIndex);
        this.checkIndex(toIndex);
        return -1;
    }

    @Override
    public int bytesBefore(byte value2) {
        return -1;
    }

    @Override
    public int bytesBefore(int length2, byte value2) {
        this.checkLength(length2);
        return -1;
    }

    @Override
    public int bytesBefore(int index, int length2, byte value2) {
        this.checkIndex(index, length2);
        return -1;
    }

    @Override
    public int forEachByte(ByteProcessor processor) {
        return -1;
    }

    @Override
    public int forEachByte(int index, int length2, ByteProcessor processor) {
        this.checkIndex(index, length2);
        return -1;
    }

    @Override
    public int forEachByteDesc(ByteProcessor processor) {
        return -1;
    }

    @Override
    public int forEachByteDesc(int index, int length2, ByteProcessor processor) {
        this.checkIndex(index, length2);
        return -1;
    }

    @Override
    public ByteBuf copy() {
        return this;
    }

    @Override
    public ByteBuf copy(int index, int length2) {
        return this.checkIndex(index, length2);
    }

    @Override
    public ByteBuf slice() {
        return this;
    }

    @Override
    public ByteBuf retainedSlice() {
        return this;
    }

    @Override
    public ByteBuf slice(int index, int length2) {
        return this.checkIndex(index, length2);
    }

    @Override
    public ByteBuf retainedSlice(int index, int length2) {
        return this.checkIndex(index, length2);
    }

    @Override
    public ByteBuf duplicate() {
        return this;
    }

    @Override
    public ByteBuf retainedDuplicate() {
        return this;
    }

    @Override
    public int nioBufferCount() {
        return 1;
    }

    @Override
    public ByteBuffer nioBuffer() {
        return EMPTY_BYTE_BUFFER;
    }

    @Override
    public ByteBuffer nioBuffer(int index, int length2) {
        this.checkIndex(index, length2);
        return this.nioBuffer();
    }

    @Override
    public ByteBuffer[] nioBuffers() {
        return new ByteBuffer[]{EMPTY_BYTE_BUFFER};
    }

    @Override
    public ByteBuffer[] nioBuffers(int index, int length2) {
        this.checkIndex(index, length2);
        return this.nioBuffers();
    }

    @Override
    public ByteBuffer internalNioBuffer(int index, int length2) {
        return EMPTY_BYTE_BUFFER;
    }

    @Override
    public boolean hasArray() {
        return true;
    }

    @Override
    public byte[] array() {
        return EmptyArrays.EMPTY_BYTES;
    }

    @Override
    public int arrayOffset() {
        return 0;
    }

    @Override
    public boolean hasMemoryAddress() {
        return EMPTY_BYTE_BUFFER_ADDRESS != 0L;
    }

    @Override
    public long memoryAddress() {
        if (this.hasMemoryAddress()) {
            return EMPTY_BYTE_BUFFER_ADDRESS;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString(Charset charset) {
        return "";
    }

    @Override
    public String toString(int index, int length2, Charset charset) {
        this.checkIndex(index, length2);
        return this.toString(charset);
    }

    @Override
    public int hashCode() {
        return 0;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof ByteBuf && !((ByteBuf)obj).isReadable();
    }

    @Override
    public int compareTo(ByteBuf buffer) {
        return buffer.isReadable() ? -1 : 0;
    }

    @Override
    public String toString() {
        return this.str;
    }

    @Override
    public boolean isReadable(int size2) {
        return false;
    }

    @Override
    public boolean isWritable(int size2) {
        return false;
    }

    @Override
    public int refCnt() {
        return 1;
    }

    @Override
    public ByteBuf retain() {
        return this;
    }

    @Override
    public ByteBuf retain(int increment) {
        return this;
    }

    @Override
    public ByteBuf touch() {
        return this;
    }

    @Override
    public ByteBuf touch(Object hint) {
        return this;
    }

    @Override
    public boolean release() {
        return false;
    }

    @Override
    public boolean release(int decrement) {
        return false;
    }

    private ByteBuf checkIndex(int index) {
        if (index != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }

    private ByteBuf checkIndex(int index, int length2) {
        if (length2 < 0) {
            throw new IllegalArgumentException("length: " + length2);
        }
        if (index != 0 || length2 != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }

    private ByteBuf checkLength(int length2) {
        if (length2 < 0) {
            throw new IllegalArgumentException("length: " + length2 + " (expected: >= 0)");
        }
        if (length2 != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }

    static {
        long emptyByteBufferAddress = 0L;
        try {
            if (PlatformDependent.hasUnsafe()) {
                emptyByteBufferAddress = PlatformDependent.directBufferAddress(EMPTY_BYTE_BUFFER);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        EMPTY_BYTE_BUFFER_ADDRESS = emptyByteBufferAddress;
    }
}

