/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.operations;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.cypher.internal.runtime.DbAccess;
import org.neo4j.cypher.internal.v3_5.util.CypherTypeException;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.values.AnyValue;
import org.neo4j.values.SequenceValue;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.ArrayValue;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.FloatingPointValue;
import org.neo4j.values.storable.IntegralValue;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.NodeValue;
import org.neo4j.values.virtual.PathValue;
import org.neo4j.values.virtual.RelationshipValue;
import org.neo4j.values.virtual.VirtualNodeValue;
import org.neo4j.values.virtual.VirtualRelationshipValue;
import org.neo4j.values.virtual.VirtualValues;

public final class CypherCoercions {
    private static final Map<Class<? extends Neo4jTypes.AnyType>, Coercer> CONVERTERS = new HashMap<Class<? extends Neo4jTypes.AnyType>, Coercer>();

    private CypherCoercions() {
        throw new UnsupportedOperationException("do not instantiate");
    }

    public static TextValue asTextValue(AnyValue value2) {
        if (!(value2 instanceof TextValue)) {
            throw CypherCoercions.cantCoerce(value2, "String");
        }
        return (TextValue)value2;
    }

    public static NodeValue asNodeValue(AnyValue value2) {
        if (!(value2 instanceof NodeValue)) {
            throw CypherCoercions.cantCoerce(value2, "Node");
        }
        return (NodeValue)value2;
    }

    public static RelationshipValue asRelationshipValue(AnyValue value2) {
        if (!(value2 instanceof RelationshipValue)) {
            throw CypherCoercions.cantCoerce(value2, "Relationship");
        }
        return (RelationshipValue)value2;
    }

    public static PathValue asPathValue(AnyValue value2) {
        if (!(value2 instanceof PathValue)) {
            throw CypherCoercions.cantCoerce(value2, "Path");
        }
        return (PathValue)value2;
    }

    public static IntegralValue asIntegralValue(AnyValue value2) {
        if (!(value2 instanceof NumberValue)) {
            throw CypherCoercions.cantCoerce(value2, "Integer");
        }
        return Values.longValue(((NumberValue)value2).longValue());
    }

    public static FloatingPointValue asFloatingPointValue(AnyValue value2) {
        if (!(value2 instanceof NumberValue)) {
            throw CypherCoercions.cantCoerce(value2, "Float");
        }
        return Values.doubleValue(((NumberValue)value2).doubleValue());
    }

    public static BooleanValue asBooleanValue(AnyValue value2) {
        if (!(value2 instanceof BooleanValue)) {
            throw CypherCoercions.cantCoerce(value2, "Boolean");
        }
        return (BooleanValue)value2;
    }

    public static NumberValue asNumberValue(AnyValue value2) {
        if (!(value2 instanceof NumberValue)) {
            throw CypherCoercions.cantCoerce(value2, "Number");
        }
        return (NumberValue)value2;
    }

    public static PointValue asPointValue(AnyValue value2) {
        if (!(value2 instanceof PointValue)) {
            throw CypherCoercions.cantCoerce(value2, "Point");
        }
        return (PointValue)value2;
    }

    public static DateValue asDateValue(AnyValue value2) {
        if (!(value2 instanceof DateValue)) {
            throw CypherCoercions.cantCoerce(value2, "Date");
        }
        return (DateValue)value2;
    }

    public static TimeValue asTimeValue(AnyValue value2) {
        if (!(value2 instanceof TimeValue)) {
            throw CypherCoercions.cantCoerce(value2, "Time");
        }
        return (TimeValue)value2;
    }

    public static LocalTimeValue asLocalTimeValue(AnyValue value2) {
        if (!(value2 instanceof LocalTimeValue)) {
            throw CypherCoercions.cantCoerce(value2, "LocalTime");
        }
        return (LocalTimeValue)value2;
    }

    public static LocalDateTimeValue asLocalDateTimeValue(AnyValue value2) {
        if (!(value2 instanceof LocalDateTimeValue)) {
            throw CypherCoercions.cantCoerce(value2, "LocalDateTime");
        }
        return (LocalDateTimeValue)value2;
    }

    public static DateTimeValue asDateTimeValue(AnyValue value2) {
        if (!(value2 instanceof DateTimeValue)) {
            throw CypherCoercions.cantCoerce(value2, "DateTime");
        }
        return (DateTimeValue)value2;
    }

    public static DurationValue asDurationValue(AnyValue value2) {
        if (!(value2 instanceof DurationValue)) {
            throw CypherCoercions.cantCoerce(value2, "Duration");
        }
        return (DurationValue)value2;
    }

    public static MapValue asMapValue(AnyValue value2, DbAccess access) {
        if (value2 instanceof MapValue) {
            return (MapValue)value2;
        }
        if (value2 instanceof NodeValue) {
            return access.nodeAsMap(((NodeValue)value2).id());
        }
        if (value2 instanceof RelationshipValue) {
            return access.relationshipAsMap(((RelationshipValue)value2).id());
        }
        throw CypherCoercions.cantCoerce(value2, "Map");
    }

    public static ListValue asList(AnyValue value2, Neo4jTypes.AnyType innerType, DbAccess access) {
        return new ListCoercer().apply(value2, innerType, access);
    }

    private static CypherTypeException cantCoerce(AnyValue value2, String type) {
        return new CypherTypeException(String.format("Can't coerce `%s` to %s", value2, type), null);
    }

    private AnyValue coerceTo(AnyValue value2, DbAccess access, Neo4jTypes.AnyType types2) {
        Coercer function = CONVERTERS.get(types2.getClass());
        return function.apply(value2, types2, access);
    }

    private static Neo4jTypes.AnyType nextInner(Neo4jTypes.AnyType type) {
        if (type instanceof Neo4jTypes.ListType) {
            return ((Neo4jTypes.ListType)type).innerType();
        }
        return type;
    }

    private static ListValue fastListConversion(AnyValue value2) {
        if (value2 instanceof ListValue) {
            return (ListValue)value2;
        }
        if (value2 instanceof ArrayValue) {
            return VirtualValues.fromArray((ArrayValue)value2);
        }
        if (value2 instanceof PathValue) {
            return ((PathValue)value2).asList();
        }
        throw CypherCoercions.cantCoerce(value2, "List");
    }

    static {
        CONVERTERS.put(Neo4jTypes.NTAny.getClass(), (a, ignore1, ignore2) -> a);
        CONVERTERS.put(Neo4jTypes.NTString.getClass(), (a, ignore1, ignore2) -> CypherCoercions.asTextValue(a));
        CONVERTERS.put(Neo4jTypes.NTNumber.getClass(), (a, ignore1, ignore2) -> CypherCoercions.asNumberValue(a));
        CONVERTERS.put(Neo4jTypes.NTInteger.getClass(), (a, ignore1, ignore2) -> CypherCoercions.asIntegralValue(a));
        CONVERTERS.put(Neo4jTypes.NTFloat.getClass(), (a, ignore1, ignore2) -> CypherCoercions.asFloatingPointValue(a));
        CONVERTERS.put(Neo4jTypes.NTBoolean.getClass(), (a, ignore1, ignore2) -> CypherCoercions.asBooleanValue(a));
        CONVERTERS.put(Neo4jTypes.NTMap.getClass(), (a, ignore, c) -> CypherCoercions.asMapValue(a, c));
        CONVERTERS.put(Neo4jTypes.NTNode.getClass(), (a, ignore1, ignore2) -> CypherCoercions.asNodeValue(a));
        CONVERTERS.put(Neo4jTypes.NTRelationship.getClass(), (a, ignore1, ignore2) -> CypherCoercions.asRelationshipValue(a));
        CONVERTERS.put(Neo4jTypes.NTPath.getClass(), (a, ignore1, ignore2) -> CypherCoercions.asPathValue(a));
        CONVERTERS.put(Neo4jTypes.NTGeometry.getClass(), (a, ignore1, ignore2) -> CypherCoercions.asPointValue(a));
        CONVERTERS.put(Neo4jTypes.NTPoint.getClass(), (a, ignore1, ignore2) -> CypherCoercions.asPointValue(a));
        CONVERTERS.put(Neo4jTypes.NTDateTime.getClass(), (a, ignore1, ignore2) -> CypherCoercions.asDateTimeValue(a));
        CONVERTERS.put(Neo4jTypes.NTLocalDateTime.getClass(), (a, ignore1, ignore2) -> CypherCoercions.asLocalDateTimeValue(a));
        CONVERTERS.put(Neo4jTypes.NTDate.getClass(), (a, ignore1, ignore2) -> CypherCoercions.asDateValue(a));
        CONVERTERS.put(Neo4jTypes.NTTime.getClass(), (a, ignore1, ignore2) -> CypherCoercions.asTimeValue(a));
        CONVERTERS.put(Neo4jTypes.NTLocalTime.getClass(), (a, ignore1, ignore2) -> CypherCoercions.asLocalTimeValue(a));
        CONVERTERS.put(Neo4jTypes.NTDuration.getClass(), (a, ignore1, ignore2) -> CypherCoercions.asDurationValue(a));
        CONVERTERS.put(Neo4jTypes.ListType.class, new ListCoercer());
    }

    private static class ListCoercer
    implements Coercer {
        private ListCoercer() {
        }

        @Override
        public ListValue apply(AnyValue value2, Neo4jTypes.AnyType innerType, DbAccess access) {
            if (innerType == Neo4jTypes.NTAny) {
                return CypherCoercions.fastListConversion(value2);
            }
            if (!(value2 instanceof SequenceValue)) {
                throw CypherCoercions.cantCoerce(value2, "List");
            }
            SequenceValue listValue = (SequenceValue)((Object)value2);
            Coercer innerCoercer = (Coercer)CONVERTERS.get(innerType.getClass());
            AnyValue[] coercedValues = new AnyValue[listValue.length()];
            Neo4jTypes.AnyType nextInner = CypherCoercions.nextInner(innerType);
            if (listValue.iterationPreference() == SequenceValue.IterationPreference.RANDOM_ACCESS) {
                for (int i = 0; i < coercedValues.length; ++i) {
                    AnyValue nextItem = listValue.value(i);
                    coercedValues[i] = nextItem == Values.NO_VALUE ? Values.NO_VALUE : innerCoercer.apply(nextItem, nextInner, access);
                }
            } else {
                int i = 0;
                for (AnyValue anyValue : listValue) {
                    AnyValue nextItem = listValue.value(i);
                    coercedValues[i++] = nextItem == Values.NO_VALUE ? Values.NO_VALUE : innerCoercer.apply(anyValue, nextInner, access);
                }
            }
            return VirtualValues.list(coercedValues);
        }
    }

    @FunctionalInterface
    static interface Coercer {
        public AnyValue apply(AnyValue var1, Neo4jTypes.AnyType var2, DbAccess var3);
    }

    private static class ListMapper
    implements ValueMapper<ListValue> {
        private ListMapper() {
        }

        @Override
        public ListValue mapPath(PathValue value2) {
            return null;
        }

        @Override
        public ListValue mapNode(VirtualNodeValue value2) {
            return null;
        }

        @Override
        public ListValue mapRelationship(VirtualRelationshipValue value2) {
            return null;
        }

        @Override
        public ListValue mapMap(MapValue value2) {
            return null;
        }

        @Override
        public ListValue mapNoValue() {
            return null;
        }

        @Override
        public ListValue mapSequence(SequenceValue value2) {
            return null;
        }

        @Override
        public ListValue mapText(TextValue value2) {
            return null;
        }

        @Override
        public ListValue mapBoolean(BooleanValue value2) {
            return null;
        }

        @Override
        public ListValue mapNumber(NumberValue value2) {
            return null;
        }

        @Override
        public ListValue mapDateTime(DateTimeValue value2) {
            return null;
        }

        @Override
        public ListValue mapLocalDateTime(LocalDateTimeValue value2) {
            return null;
        }

        @Override
        public ListValue mapDate(DateValue value2) {
            return null;
        }

        @Override
        public ListValue mapTime(TimeValue value2) {
            return null;
        }

        @Override
        public ListValue mapLocalTime(LocalTimeValue value2) {
            return null;
        }

        @Override
        public ListValue mapDuration(DurationValue value2) {
            return null;
        }

        @Override
        public ListValue mapPoint(PointValue value2) {
            return null;
        }
    }
}

