/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.argparse4j.impl.type;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import net.sourceforge.argparse4j.helper.TextHelper;
import net.sourceforge.argparse4j.inf.Argument;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.ArgumentType;
import net.sourceforge.argparse4j.inf.MetavarInference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectArgumentType<T>
implements ArgumentType<T>,
MetavarInference {
    private Class<T> type_;

    public ReflectArgumentType(Class<T> type) {
        this.type_ = type;
    }

    @Override
    public T convert(ArgumentParser parser, Argument arg, String value2) throws ArgumentParserException {
        if (this.type_.isEnum()) {
            try {
                return Enum.valueOf(this.type_, value2);
            }
            catch (IllegalArgumentException e) {
                throw new ArgumentParserException(String.format(TextHelper.LOCALE_ROOT, "could not convert '%s' (choose from %s)", value2, this.inferMetavar()[0]), parser, arg);
            }
        }
        Method m = null;
        try {
            m = this.type_.getMethod("valueOf", String.class);
        }
        catch (NoSuchMethodException e) {
            return this.convertUsingConstructor(parser, arg, value2);
        }
        catch (SecurityException e) {
            this.handleInstatiationError(e);
        }
        if (!Modifier.isStatic(m.getModifiers()) || !this.type_.isAssignableFrom(m.getReturnType())) {
            return this.convertUsingConstructor(parser, arg, value2);
        }
        Object obj = null;
        try {
            obj = m.invoke(null, value2);
        }
        catch (IllegalAccessException e) {
            return this.convertUsingConstructor(parser, arg, value2);
        }
        catch (IllegalArgumentException e) {
            this.handleInstatiationError(e);
        }
        catch (InvocationTargetException e) {
            this.throwArgumentParserException(parser, arg, value2, e.getCause() == null ? e : e.getCause());
        }
        return (T)obj;
    }

    private T convertUsingConstructor(ArgumentParser parser, Argument arg, String value2) throws ArgumentParserException {
        T obj = null;
        try {
            obj = this.type_.getConstructor(String.class).newInstance(value2);
        }
        catch (InstantiationException e) {
            this.handleInstatiationError(e);
        }
        catch (IllegalAccessException e) {
            this.handleInstatiationError(e);
        }
        catch (InvocationTargetException e) {
            this.throwArgumentParserException(parser, arg, value2, e.getCause() == null ? e : e.getCause());
        }
        catch (NoSuchMethodException e) {
            this.handleInstatiationError(e);
        }
        return obj;
    }

    private void throwArgumentParserException(ArgumentParser parser, Argument arg, String value2, Throwable t) throws ArgumentParserException {
        throw new ArgumentParserException(String.format(TextHelper.LOCALE_ROOT, "could not convert '%s' to %s (%s)", value2, this.type_.getSimpleName(), t.getMessage()), t, parser, arg);
    }

    private void handleInstatiationError(Exception e) {
        throw new IllegalArgumentException("reflect type conversion error", e);
    }

    @Override
    public String[] inferMetavar() {
        if (Boolean.class.equals(this.type_)) {
            return new String[]{TextHelper.concat(new String[]{"true", "false"}, 0, ",", "{", "}")};
        }
        if (this.type_.isEnum()) {
            T[] enumConstants = this.type_.getEnumConstants();
            String[] names = new String[enumConstants.length];
            int i = 0;
            for (T t : enumConstants) {
                names[i++] = ((Enum)t).name();
            }
            return new String[]{TextHelper.concat(names, 0, ",", "{", "}")};
        }
        return null;
    }
}

