/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import org.neo4j.io.pagecache.impl.muninn.MuninnPagedFile;
import org.neo4j.io.pagecache.impl.muninn.MuninnReadPageCursor;
import org.neo4j.io.pagecache.impl.muninn.MuninnWritePageCursor;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracerSupplier;
import org.neo4j.io.pagecache.tracing.cursor.context.VersionContextSupplier;

final class CursorFactory {
    private final MuninnPagedFile pagedFile;
    private final long victimPage;
    private final PageCursorTracerSupplier pageCursorTracerSupplier;
    private final PageCacheTracer pageCacheTracer;
    private final VersionContextSupplier versionContextSupplier;

    CursorFactory(MuninnPagedFile pagedFile, PageCursorTracerSupplier pageCursorTracerSupplier, PageCacheTracer pageCacheTracer, VersionContextSupplier versionContextSupplier) {
        this.pagedFile = pagedFile;
        this.victimPage = pagedFile.pageCache.victimPage;
        this.pageCursorTracerSupplier = pageCursorTracerSupplier;
        this.pageCacheTracer = pageCacheTracer;
        this.versionContextSupplier = versionContextSupplier;
    }

    MuninnReadPageCursor takeReadCursor(long pageId, int pf_flags) {
        MuninnReadPageCursor cursor = new MuninnReadPageCursor(this.victimPage, this.getPageCursorTracer(), this.versionContextSupplier);
        cursor.initialise(this.pagedFile, pageId, pf_flags);
        return cursor;
    }

    MuninnWritePageCursor takeWriteCursor(long pageId, int pf_flags) {
        MuninnWritePageCursor cursor = new MuninnWritePageCursor(this.victimPage, this.getPageCursorTracer(), this.versionContextSupplier);
        cursor.initialise(this.pagedFile, pageId, pf_flags);
        return cursor;
    }

    private PageCursorTracer getPageCursorTracer() {
        PageCursorTracer pageCursorTracer = (PageCursorTracer)this.pageCursorTracerSupplier.get();
        pageCursorTracer.init(this.pageCacheTracer);
        return pageCursorTracer;
    }
}

