/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import org.neo4j.io.IOUtils;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.storageengine.api.schema.IndexSample;
import org.neo4j.storageengine.api.schema.IndexSampler;

public class FusionIndexSampler
implements IndexSampler {
    private final IndexSampler[] samplers;

    public FusionIndexSampler(IndexSampler ... samplers) {
        this.samplers = samplers;
    }

    @Override
    public IndexSample sampleIndex() throws IndexNotFoundKernelException {
        IndexSample[] samples = new IndexSample[this.samplers.length];
        for (int i = 0; i < this.samplers.length; ++i) {
            samples[i] = this.samplers[i].sampleIndex();
        }
        return FusionIndexSampler.combineSamples(samples);
    }

    public static IndexSample combineSamples(IndexSample ... samples) {
        long indexSize = 0L;
        long uniqueValues = 0L;
        long sampleSize = 0L;
        for (IndexSample sample : samples) {
            indexSize += sample.indexSize();
            uniqueValues += sample.uniqueValues();
            sampleSize += sample.sampleSize();
        }
        return new IndexSample(indexSize, uniqueValues, sampleSize);
    }

    @Override
    public void close() {
        IOUtils.closeAllSilently((AutoCloseable[])this.samplers);
    }
}

