/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.diagnostics;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.neo4j.diagnostics.DiagnosticsOfflineReportProvider;
import org.neo4j.diagnostics.DiagnosticsReportSource;
import org.neo4j.diagnostics.DiagnosticsReportSources;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.info.DiagnosticsPhase;
import org.neo4j.kernel.internal.KernelDiagnostics;
import org.neo4j.logging.BufferingLog;

public class KernelDiagnosticsOfflineReportProvider
extends DiagnosticsOfflineReportProvider {
    private FileSystemAbstraction fs;
    private Config config;
    private File storeDirectory;

    public KernelDiagnosticsOfflineReportProvider() {
        super("kernel", "logs", new String[]{"plugins", "tree", "tx"});
    }

    @Override
    public void init(FileSystemAbstraction fs, Config config, File storeDirectory) {
        this.fs = fs;
        this.config = config;
        this.storeDirectory = storeDirectory;
    }

    @Override
    protected List<DiagnosticsReportSource> provideSources(Set<String> classifiers) {
        ArrayList<DiagnosticsReportSource> sources = new ArrayList<DiagnosticsReportSource>();
        if (classifiers.contains("logs")) {
            this.getLogFiles(sources);
        }
        if (classifiers.contains("plugins")) {
            this.listPlugins(sources);
        }
        if (classifiers.contains("tree")) {
            this.listDataDirectory(sources);
        }
        if (classifiers.contains("tx")) {
            this.getTransactionLogFiles(sources);
        }
        return sources;
    }

    private void listPlugins(List<DiagnosticsReportSource> sources) {
        File pluginDirectory = this.config.get(GraphDatabaseSettings.plugin_dir);
        if (this.fs.fileExists(pluginDirectory)) {
            StringBuilder sb = new StringBuilder();
            sb.append("List of plugin directory:").append(System.lineSeparator());
            this.listContentOfDirectory(pluginDirectory, "  ", sb);
            sources.add(DiagnosticsReportSources.newDiagnosticsString("plugins.txt", sb::toString));
        }
    }

    private void listContentOfDirectory(File directory, String prefix, StringBuilder sb) {
        File[] files;
        if (!this.fs.isDirectory(directory)) {
            return;
        }
        for (File file : files = this.fs.listFiles(directory)) {
            if (this.fs.isDirectory(file)) {
                this.listContentOfDirectory(file, prefix + File.separator + file.getName(), sb);
                continue;
            }
            sb.append(prefix).append(file.getName()).append(System.lineSeparator());
        }
    }

    private void listDataDirectory(List<DiagnosticsReportSource> sources) {
        KernelDiagnostics.StoreFiles storeFiles = new KernelDiagnostics.StoreFiles(this.storeDirectory);
        BufferingLog logger = new BufferingLog();
        storeFiles.dump(DiagnosticsPhase.INITIALIZED, logger.debugLogger());
        sources.add(DiagnosticsReportSources.newDiagnosticsString("tree.txt", () -> ((BufferingLog)logger).toString()));
    }

    private void getLogFiles(List<DiagnosticsReportSource> sources) {
        File gcRotationLog;
        File gcLog;
        File logDirectory;
        File ongdbLog;
        File debugLogFile = this.config.get(GraphDatabaseSettings.store_internal_log_path);
        if (this.fs.fileExists(debugLogFile)) {
            sources.addAll(DiagnosticsReportSources.newDiagnosticsRotatingFile("logs/debug.log", this.fs, debugLogFile));
        }
        if (this.fs.fileExists(ongdbLog = new File(logDirectory = this.config.get(GraphDatabaseSettings.logs_directory), "ongdb.log"))) {
            sources.add(DiagnosticsReportSources.newDiagnosticsFile("logs/ongdb.log", this.fs, ongdbLog));
        }
        if (this.fs.fileExists(gcLog = new File(logDirectory, "gc.log"))) {
            sources.add(DiagnosticsReportSources.newDiagnosticsFile("logs/gc.log", this.fs, gcLog));
        }
        int i = 0;
        while (this.fs.fileExists(gcRotationLog = new File(logDirectory, "gc.log." + i))) {
            sources.add(DiagnosticsReportSources.newDiagnosticsFile("logs/gc.log." + i, this.fs, gcRotationLog));
            ++i;
        }
    }

    private void getTransactionLogFiles(List<DiagnosticsReportSource> sources) {
        try {
            LogFiles logFiles = LogFilesBuilder.logFilesBasedOnlyBuilder(this.storeDirectory, this.fs).build();
            for (File file : logFiles.logFiles()) {
                sources.add(DiagnosticsReportSources.newDiagnosticsFile("tx/" + file.getName(), this.fs, file));
            }
        }
        catch (IOException e) {
            sources.add(DiagnosticsReportSources.newDiagnosticsString("tx.txt", () -> "Error getting tx logs: " + e.getMessage()));
        }
    }
}

