/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.diagnostics;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.neo4j.diagnostics.DiagnosticsOfflineReportProvider;
import org.neo4j.diagnostics.DiagnosticsReportSource;
import org.neo4j.diagnostics.DiagnosticsReportSources;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;

public class BoltDiagnosticsOfflineReportProvider
extends DiagnosticsOfflineReportProvider {
    private FileSystemAbstraction fs;
    private Config config;

    public BoltDiagnosticsOfflineReportProvider() {
        super("bolt", "logs", new String[0]);
    }

    public void init(FileSystemAbstraction fs, Config config, File storeDirectory) {
        this.fs = fs;
        this.config = config;
    }

    protected List<DiagnosticsReportSource> provideSources(Set<String> classifiers) {
        File boltLogFile;
        if (classifiers.contains("logs") && this.fs.fileExists(boltLogFile = (File)this.config.get(GraphDatabaseSettings.bolt_log_filename))) {
            return DiagnosticsReportSources.newDiagnosticsRotatingFile((String)"logs/bolt.log", (FileSystemAbstraction)this.fs, (File)boltLogFile);
        }
        return Collections.emptyList();
    }
}

