/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.primitive;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.LongFunction;
import java.util.function.LongPredicate;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveCommons;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.collection.primitive.PrimitiveLongObjectMap;
import org.neo4j.collection.primitive.PrimitiveLongResourceCollections;
import org.neo4j.collection.primitive.PrimitiveLongResourceIterator;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.collection.primitive.base.Empty;
import org.neo4j.graphdb.Resource;

public class PrimitiveLongCollections {
    public static final long[] EMPTY_LONG_ARRAY = new long[0];
    private static final PrimitiveLongIterator EMPTY = new PrimitiveLongBaseIterator(){

        @Override
        protected boolean fetchNext() {
            return false;
        }
    };

    private PrimitiveLongCollections() {
        throw new AssertionError((Object)"no instance");
    }

    public static PrimitiveLongIterator iterator(final long ... items) {
        return new PrimitiveLongResourceCollections.PrimitiveLongBaseResourceIterator(Resource.EMPTY){
            private int index;
            {
                super(resource);
                this.index = -1;
            }

            @Override
            protected boolean fetchNext() {
                return ++this.index < items.length && this.next(items[this.index]);
            }
        };
    }

    public static PrimitiveLongIterator concat(PrimitiveLongIterator ... primitiveLongIterators) {
        return PrimitiveLongCollections.concat(Arrays.asList(primitiveLongIterators));
    }

    public static PrimitiveLongIterator concat(Iterable<PrimitiveLongIterator> primitiveLongIterators) {
        return new PrimitiveLongConcatingIterator(primitiveLongIterators.iterator());
    }

    public static PrimitiveLongIterator filter(PrimitiveLongIterator source, final LongPredicate filter) {
        return new PrimitiveLongFilteringIterator(source){

            @Override
            public boolean test(long item) {
                return filter.test(item);
            }
        };
    }

    public static PrimitiveLongResourceIterator filter(PrimitiveLongResourceIterator source, final LongPredicate filter) {
        return new PrimitiveLongResourceFilteringIterator(source){

            @Override
            public boolean test(long item) {
                return filter.test(item);
            }
        };
    }

    public static PrimitiveLongIterator range(long start, long end) {
        return new PrimitiveLongRangeIterator(start, end);
    }

    public static long single(PrimitiveLongIterator iterator, long defaultItem) {
        try {
            if (!iterator.hasNext()) {
                PrimitiveCommons.closeSafely(iterator);
                return defaultItem;
            }
            long item = iterator.next();
            if (iterator.hasNext()) {
                throw new NoSuchElementException("More than one item in " + iterator + ", first:" + item + ", second:" + iterator.next());
            }
            PrimitiveCommons.closeSafely(iterator);
            return item;
        }
        catch (NoSuchElementException exception) {
            PrimitiveCommons.closeSafely(iterator, exception);
            throw exception;
        }
    }

    public static int indexOf(PrimitiveLongIterator iterator, long item) {
        int i = 0;
        while (iterator.hasNext()) {
            if (item == iterator.next()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static PrimitiveLongSet asSet(Collection<Long> collection) {
        PrimitiveLongSet set = Primitive.longSet(collection.size());
        for (Long next : collection) {
            set.add(next);
        }
        return set;
    }

    public static PrimitiveLongSet asSet(PrimitiveLongIterator iterator) {
        PrimitiveLongSet set = Primitive.longSet();
        while (iterator.hasNext()) {
            set.add(iterator.next());
        }
        return set;
    }

    public static PrimitiveLongSet asSet(PrimitiveLongSet set) {
        PrimitiveLongSet result = Primitive.longSet(set.size());
        PrimitiveLongIterator iterator = set.iterator();
        while (iterator.hasNext()) {
            result.add(iterator.next());
        }
        return result;
    }

    public static PrimitiveLongSet asSet(long ... values) {
        PrimitiveLongSet result = Primitive.longSet(values.length);
        for (long value : values) {
            result.add(value);
        }
        return result;
    }

    public static <T> PrimitiveLongObjectMap<T> copy(PrimitiveLongObjectMap<T> original) {
        PrimitiveLongObjectMap copy = Primitive.longObjectMap(original.size());
        original.visitEntries((key, value) -> {
            copy.put(key, value);
            return false;
        });
        return copy;
    }

    public static int count(PrimitiveLongIterator iterator) {
        int count = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++count;
        }
        return count;
    }

    public static long[] asArray(PrimitiveLongIterator iterator) {
        long[] array = new long[8];
        int i = 0;
        while (iterator.hasNext()) {
            if (i >= array.length) {
                array = Arrays.copyOf(array, i << 1);
            }
            array[i] = iterator.next();
            ++i;
        }
        if (i < array.length) {
            array = Arrays.copyOf(array, i);
        }
        return array;
    }

    public static long[] asArray(Iterator<Long> iterator) {
        long[] array = new long[8];
        int i = 0;
        while (iterator.hasNext()) {
            if (i >= array.length) {
                array = Arrays.copyOf(array, i << 1);
            }
            array[i] = iterator.next();
            ++i;
        }
        if (i < array.length) {
            array = Arrays.copyOf(array, i);
        }
        return array;
    }

    public static PrimitiveLongIterator emptyIterator() {
        return EMPTY;
    }

    public static PrimitiveLongIterator toPrimitiveIterator(final Iterator<Long> iterator) {
        return new PrimitiveLongBaseIterator(){

            @Override
            protected boolean fetchNext() {
                if (iterator.hasNext()) {
                    Long nextValue = (Long)iterator.next();
                    if (null == nextValue) {
                        throw new IllegalArgumentException("Cannot convert null Long to primitive long");
                    }
                    return this.next(nextValue);
                }
                return false;
            }
        };
    }

    public static PrimitiveLongSet emptySet() {
        return Empty.EMPTY_PRIMITIVE_LONG_SET;
    }

    public static PrimitiveLongSet setOf(long ... values) {
        Objects.requireNonNull(values, "Values array is null");
        PrimitiveLongSet set = Primitive.longSet(values.length);
        for (long value : values) {
            set.add(value);
        }
        return set;
    }

    public static <T> Iterator<T> map(final LongFunction<T> mapFunction, final PrimitiveLongIterator source) {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return source.hasNext();
            }

            @Override
            public T next() {
                return mapFunction.apply(source.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static List<Long> asList(PrimitiveLongIterator iterator) {
        ArrayList<Long> out = new ArrayList<Long>();
        while (iterator.hasNext()) {
            out.add(iterator.next());
        }
        return out;
    }

    public static Iterator<Long> toIterator(final PrimitiveLongIterator primIterator) {
        return new Iterator<Long>(){

            @Override
            public boolean hasNext() {
                return primIterator.hasNext();
            }

            @Override
            public Long next() {
                return primIterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static PrimitiveLongResourceIterator resourceIterator(final PrimitiveLongIterator iterator, final Resource resource) {
        return new PrimitiveLongResourceIterator(){

            public void close() {
                if (resource != null) {
                    resource.close();
                }
            }

            @Override
            public long next() {
                return iterator.next();
            }

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }
        };
    }

    public static Set<Long> toSet(PrimitiveLongSet set) {
        return PrimitiveLongCollections.toSet(set.iterator());
    }

    public static Set<Long> toSet(PrimitiveLongIterator iterator) {
        HashSet<Long> set = new HashSet<Long>();
        while (iterator.hasNext()) {
            PrimitiveLongCollections.addUnique(set, iterator.next());
        }
        return set;
    }

    private static <T, C extends Collection<T>> void addUnique(C collection, T item) {
        if (!collection.add(item)) {
            throw new IllegalStateException("Encountered an already added item:" + item + " when adding items uniquely to a collection:" + collection);
        }
    }

    public static long[] deduplicate(long[] values) {
        int unique = 0;
        for (int i = 0; i < values.length; ++i) {
            long value = values[i];
            for (int j = 0; j < unique; ++j) {
                if (value != values[j]) continue;
                value = -1L;
                break;
            }
            if (value == -1L) continue;
            values[unique++] = values[i];
        }
        return unique < values.length ? Arrays.copyOf(values, unique) : values;
    }

    public static class PrimitiveLongRangeIterator
    extends PrimitiveLongBaseIterator {
        private long current;
        private final long end;

        PrimitiveLongRangeIterator(long start, long end) {
            this.current = start;
            this.end = end;
        }

        @Override
        protected boolean fetchNext() {
            try {
                boolean bl = this.current <= this.end && this.next(this.current);
                return bl;
            }
            finally {
                ++this.current;
            }
        }
    }

    public static abstract class PrimitiveLongResourceFilteringIterator
    extends PrimitiveLongFilteringIterator
    implements PrimitiveLongResourceIterator {
        PrimitiveLongResourceFilteringIterator(PrimitiveLongIterator source) {
            super(source);
        }

        public void close() {
            if (this.source instanceof Resource) {
                ((Resource)this.source).close();
            }
        }
    }

    public static abstract class PrimitiveLongFilteringIterator
    extends PrimitiveLongBaseIterator
    implements LongPredicate {
        protected final PrimitiveLongIterator source;

        PrimitiveLongFilteringIterator(PrimitiveLongIterator source) {
            this.source = source;
        }

        @Override
        protected boolean fetchNext() {
            while (this.source.hasNext()) {
                long testItem = this.source.next();
                if (!this.test(testItem)) continue;
                return this.next(testItem);
            }
            return false;
        }

        @Override
        public abstract boolean test(long var1);
    }

    public static class PrimitiveLongConcatingIterator
    extends PrimitiveLongBaseIterator {
        private final Iterator<? extends PrimitiveLongIterator> iterators;
        private PrimitiveLongIterator currentIterator;

        public PrimitiveLongConcatingIterator(Iterator<? extends PrimitiveLongIterator> iterators) {
            this.iterators = iterators;
        }

        @Override
        protected boolean fetchNext() {
            if (this.currentIterator == null || !this.currentIterator.hasNext()) {
                while (this.iterators.hasNext()) {
                    this.currentIterator = this.iterators.next();
                    if (!this.currentIterator.hasNext()) continue;
                }
            }
            return this.currentIterator != null && this.currentIterator.hasNext() && this.next(this.currentIterator.next());
        }

        protected final PrimitiveLongIterator currentIterator() {
            return this.currentIterator;
        }
    }

    public static abstract class PrimitiveLongBaseIterator
    implements PrimitiveLongIterator {
        private boolean hasNextDecided;
        private boolean hasNext;
        protected long next;

        @Override
        public boolean hasNext() {
            if (!this.hasNextDecided) {
                this.hasNext = this.fetchNext();
                this.hasNextDecided = true;
            }
            return this.hasNext;
        }

        @Override
        public long next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more elements in " + this);
            }
            this.hasNextDecided = false;
            return this.next;
        }

        protected abstract boolean fetchNext();

        protected boolean next(long nextItem) {
            this.next = nextItem;
            this.hasNext = true;
            return true;
        }
    }
}

