/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.dbms;

import java.io.File;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import org.neo4j.commandline.Util;
import org.neo4j.commandline.admin.AdminCommand;
import org.neo4j.commandline.admin.CommandFailed;
import org.neo4j.commandline.admin.IncorrectUsage;
import org.neo4j.commandline.arguments.Arguments;
import org.neo4j.commandline.arguments.NamedArgument;
import org.neo4j.commandline.arguments.OptionalBooleanArg;
import org.neo4j.commandline.arguments.common.MandatoryCanonicalPath;
import org.neo4j.dbms.archive.IncorrectFormat;
import org.neo4j.dbms.archive.Loader;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.configuration.Config;

public class LoadCommand
implements AdminCommand {
    private static final Arguments arguments = new Arguments().withArgument((NamedArgument)new MandatoryCanonicalPath("from", "archive-path", "Path to archive created with the dump command.")).withDatabase().withArgument((NamedArgument)new OptionalBooleanArg("force", false, "If an existing database should be replaced."));
    private final Path homeDir;
    private final Path configDir;
    private final Loader loader;

    public LoadCommand(Path homeDir, Path configDir, Loader loader) {
        Objects.requireNonNull(homeDir);
        Objects.requireNonNull(configDir);
        Objects.requireNonNull(loader);
        this.homeDir = homeDir;
        this.configDir = configDir;
        this.loader = loader;
    }

    public void execute(String[] args) throws IncorrectUsage, CommandFailed {
        arguments.parse(args);
        Path archive = arguments.getMandatoryPath("from");
        String database = arguments.get("database");
        boolean force = arguments.getBoolean("force");
        Config config = this.buildConfig(database);
        Path databaseDirectory = Util.canonicalPath((Path)this.getDatabaseDirectory(config));
        Path transactionLogsDirectory = Util.canonicalPath((Path)this.getTransactionalLogsDirectory(config));
        this.deleteIfNecessary(databaseDirectory, transactionLogsDirectory, force);
        this.load(archive, database, databaseDirectory, transactionLogsDirectory);
    }

    private Path getDatabaseDirectory(Config config) {
        return ((File)config.get(GraphDatabaseSettings.database_path)).toPath();
    }

    private Path getTransactionalLogsDirectory(Config config) {
        return ((File)config.get(GraphDatabaseSettings.logical_logs_location)).toPath();
    }

    private Config buildConfig(String databaseName) {
        return Config.fromFile((Path)this.configDir.resolve("ongdb.conf")).withHome(this.homeDir).withConnectorsDisabled().withSetting(GraphDatabaseSettings.active_database, databaseName).build();
    }

    private void deleteIfNecessary(Path databaseDirectory, Path transactionLogsDirectory, boolean force) throws CommandFailed {
        try {
            if (force) {
                Util.checkLock((Path)databaseDirectory);
                FileUtils.deletePathRecursively((Path)databaseDirectory);
                if (!Util.isSameOrChildPath((Path)databaseDirectory, (Path)transactionLogsDirectory)) {
                    FileUtils.deletePathRecursively((Path)transactionLogsDirectory);
                }
            }
        }
        catch (IOException e) {
            Util.wrapIOException((IOException)e);
        }
    }

    private void load(Path archive, String database, Path databaseDirectory, Path transactionLogsDirectory) throws CommandFailed {
        try {
            this.loader.load(archive, databaseDirectory, transactionLogsDirectory);
        }
        catch (NoSuchFileException e) {
            if (Paths.get(e.getMessage(), new String[0]).toAbsolutePath().equals(archive.toAbsolutePath())) {
                throw new CommandFailed("archive does not exist: " + archive, (Throwable)e);
            }
            Util.wrapIOException((IOException)e);
        }
        catch (FileAlreadyExistsException e) {
            throw new CommandFailed("database already exists: " + database, (Throwable)e);
        }
        catch (AccessDeniedException e) {
            throw new CommandFailed("you do not have permission to load a database -- is ONgDB running as a different user?", (Throwable)e);
        }
        catch (IOException e) {
            Util.wrapIOException((IOException)e);
        }
        catch (IncorrectFormat incorrectFormat) {
            throw new CommandFailed("Not a valid ONgDB archive: " + archive, (Throwable)incorrectFormat);
        }
    }

    public static Arguments arguments() {
        return arguments;
    }
}

