/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.dbms;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.text.StringEscapeUtils;
import org.jutils.jprocesses.JProcesses;
import org.jutils.jprocesses.model.ProcessInfo;
import org.neo4j.commandline.admin.AdminCommand;
import org.neo4j.commandline.admin.CommandFailed;
import org.neo4j.commandline.admin.IncorrectUsage;
import org.neo4j.commandline.admin.OutsideWorld;
import org.neo4j.commandline.arguments.Arguments;
import org.neo4j.commandline.arguments.MandatoryNamedArg;
import org.neo4j.commandline.arguments.NamedArgument;
import org.neo4j.commandline.arguments.OptionalNamedArg;
import org.neo4j.commandline.arguments.PositionalArgument;
import org.neo4j.commandline.arguments.common.OptionalCanonicalPath;
import org.neo4j.dbms.diagnostics.jmx.JMXDumper;
import org.neo4j.dbms.diagnostics.jmx.JmxDump;
import org.neo4j.diagnostics.DiagnosticsReportSource;
import org.neo4j.diagnostics.DiagnosticsReportSources;
import org.neo4j.diagnostics.DiagnosticsReporter;
import org.neo4j.diagnostics.DiagnosticsReporterProgress;
import org.neo4j.diagnostics.InteractiveProgress;
import org.neo4j.diagnostics.NonInteractiveProgress;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Args;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;

public class DiagnosticsReportCommand
implements AdminCommand {
    private static final OptionalNamedArg destinationArgument = new OptionalCanonicalPath("to", System.getProperty("java.io.tmpdir"), "reports" + File.separator, "Destination directory for reports");
    public static final String PID_KEY = "pid";
    private static final long NO_PID = 0L;
    private static final Arguments arguments = new Arguments().withArgument((NamedArgument)new OptionalListArgument()).withArgument((NamedArgument)destinationArgument).withArgument((NamedArgument)new OptionalVerboseArgument()).withArgument((NamedArgument)new OptionalForceArgument()).withArgument((NamedArgument)new OptionalNamedArg("pid", "1234", "", "Specify process id of running ONgDB instance")).withPositionalArgument((PositionalArgument)new ClassifierFiltersArgument());
    private final Path homeDir;
    private final Path configDir;
    static final String[] DEFAULT_CLASSIFIERS = new String[]{"logs", "config", "plugins", "tree", "metrics", "threads", "env", "sysprop", "ps"};
    private JMXDumper jmxDumper;
    private boolean verbose;
    private final PrintStream out;
    private final FileSystemAbstraction fs;
    private final PrintStream err;
    private static final DateTimeFormatter filenameDateTimeFormatter = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd_HHmmss").toFormatter();
    private long pid;

    DiagnosticsReportCommand(Path homeDir, Path configDir, OutsideWorld outsideWorld) {
        this.homeDir = homeDir;
        this.configDir = configDir;
        this.fs = outsideWorld.fileSystem();
        this.out = outsideWorld.outStream();
        this.err = outsideWorld.errorStream();
    }

    public static Arguments allArguments() {
        return arguments;
    }

    public void execute(String[] stringArgs) throws IncorrectUsage, CommandFailed {
        Args args = Args.withFlags((String[])new String[]{"list", "to", "verbose", "force", PID_KEY}).parse(stringArgs);
        this.verbose = args.has("verbose");
        this.jmxDumper = new JMXDumper(this.homeDir, this.fs, this.out, this.err, this.verbose);
        this.pid = DiagnosticsReportCommand.parsePid(args);
        boolean force = args.has("force");
        DiagnosticsReporter reporter = this.createAndRegisterSources();
        Optional<Set<String>> classifiers = this.parseAndValidateArguments(args, reporter);
        if (!classifiers.isPresent()) {
            return;
        }
        DiagnosticsReporterProgress progress = this.buildProgress();
        Path destinationDir = new File(destinationArgument.parse(args)).toPath();
        try {
            Path reportFile = destinationDir.resolve(this.getDefaultFilename());
            this.out.println("Writing report to " + reportFile.toAbsolutePath().toString());
            reporter.dump(classifiers.get(), reportFile, progress, force);
        }
        catch (IOException e) {
            throw new CommandFailed("Creating archive failed", (Throwable)e);
        }
    }

    private static long parsePid(Args args) throws CommandFailed {
        if (args.has(PID_KEY)) {
            try {
                return Long.parseLong(args.get(PID_KEY, ""));
            }
            catch (NumberFormatException e) {
                throw new CommandFailed("Unable to parse --pid", (Throwable)e);
            }
        }
        return 0L;
    }

    private String getDefaultFilename() throws UnknownHostException {
        String hostName = InetAddress.getLocalHost().getHostName();
        String safeFilename = hostName.replaceAll("[^a-zA-Z0-9._]+", "_");
        return safeFilename + "-" + LocalDateTime.now().format(filenameDateTimeFormatter) + ".zip";
    }

    private DiagnosticsReporterProgress buildProgress() {
        Object progress = System.console() != null ? new InteractiveProgress(this.out, this.verbose) : new NonInteractiveProgress(this.out, this.verbose);
        return progress;
    }

    private Optional<Set<String>> parseAndValidateArguments(Args args, DiagnosticsReporter reporter) throws IncorrectUsage {
        Set availableClassifiers = reporter.getAvailableClassifiers();
        if (args.has("list")) {
            this.listClassifiers(availableClassifiers);
            return Optional.empty();
        }
        TreeSet<String> classifiers = new TreeSet<String>(args.orphans());
        if (classifiers.contains("all")) {
            if (classifiers.size() != 1) {
                classifiers.remove("all");
                throw new IncorrectUsage("If you specify 'all' this has to be the only classifier. Found ['" + String.join((CharSequence)"','", classifiers) + "'] as well.");
            }
        } else {
            if (classifiers.isEmpty()) {
                this.addDefaultClassifiers(availableClassifiers, classifiers);
            }
            this.validateClassifiers(availableClassifiers, classifiers);
        }
        return Optional.of(classifiers);
    }

    private void validateClassifiers(Set<String> availableClassifiers, Set<String> orphans) throws IncorrectUsage {
        for (String classifier : orphans) {
            if (availableClassifiers.contains(classifier)) continue;
            throw new IncorrectUsage("Unknown classifier: " + classifier);
        }
    }

    private void addDefaultClassifiers(Set<String> availableClassifiers, Set<String> orphans) {
        for (String classifier : DEFAULT_CLASSIFIERS) {
            if (!availableClassifiers.contains(classifier)) continue;
            orphans.add(classifier);
        }
    }

    private void listClassifiers(Set<String> availableClassifiers) {
        this.out.println("All available classifiers:");
        for (String classifier : availableClassifiers) {
            this.out.printf("  %-10s %s%n", classifier, DiagnosticsReportCommand.describeClassifier(classifier));
        }
    }

    private DiagnosticsReporter createAndRegisterSources() throws CommandFailed {
        DiagnosticsReporter reporter = new DiagnosticsReporter();
        File configFile = this.configDir.resolve("ongdb.conf").toFile();
        Config config = this.getConfig(configFile);
        File storeDirectory = (File)config.get(GraphDatabaseSettings.database_path);
        reporter.registerAllOfflineProviders(config, storeDirectory, this.fs);
        reporter.registerSource("config", DiagnosticsReportSources.newDiagnosticsFile((String)"ongdb.conf", (FileSystemAbstraction)this.fs, (File)configFile));
        reporter.registerSource("ps", DiagnosticsReportCommand.runningProcesses());
        this.registerJMXSources(reporter);
        return reporter;
    }

    private void registerJMXSources(DiagnosticsReporter reporter) {
        Optional<JmxDump> jmxDump = this.pid == 0L ? this.jmxDumper.getJMXDump() : this.jmxDumper.getJMXDump(this.pid);
        jmxDump.ifPresent(jmx -> {
            reporter.registerSource("threads", jmx.threadDump());
            reporter.registerSource("heap", jmx.heapDump());
            reporter.registerSource("sysprop", jmx.systemProperties());
            reporter.registerSource("env", jmx.environmentVariables());
            reporter.registerSource("activetxs", jmx.listTransactions());
        });
    }

    private Config getConfig(File configFile) throws CommandFailed {
        if (!this.fs.fileExists(configFile)) {
            throw new CommandFailed("Unable to find config file, tried: " + configFile.getAbsolutePath());
        }
        return Config.fromFile((File)configFile).withHome(this.homeDir).withConnectorsDisabled().build();
    }

    static String describeClassifier(String classifier) {
        switch (classifier) {
            case "logs": {
                return "include log files";
            }
            case "config": {
                return "include configuration file";
            }
            case "plugins": {
                return "include a view of the plugin directory";
            }
            case "tree": {
                return "include a view of the tree structure of the data directory";
            }
            case "tx": {
                return "include transaction logs";
            }
            case "metrics": {
                return "include metrics";
            }
            case "threads": {
                return "include a thread dump of the running instance";
            }
            case "heap": {
                return "include a heap dump";
            }
            case "env": {
                return "include a list of all environment variables";
            }
            case "sysprop": {
                return "include a list of java system properties";
            }
            case "raft": {
                return "include the raft log";
            }
            case "ccstate": {
                return "include the current cluster state";
            }
            case "activetxs": {
                return "include the output of dbms.listTransactions()";
            }
            case "ps": {
                return "include a list of running processes";
            }
        }
        throw new IllegalArgumentException("Unknown classifier: " + classifier);
    }

    private static DiagnosticsReportSource runningProcesses() {
        return DiagnosticsReportSources.newDiagnosticsString((String)"ps.csv", () -> {
            List processesList = JProcesses.getProcessList();
            StringBuilder sb = new StringBuilder();
            sb.append(StringEscapeUtils.escapeCsv((String)"Process PID")).append(',').append(StringEscapeUtils.escapeCsv((String)"Process Name")).append(',').append(StringEscapeUtils.escapeCsv((String)"Process Time")).append(',').append(StringEscapeUtils.escapeCsv((String)"User")).append(',').append(StringEscapeUtils.escapeCsv((String)"Virtual Memory")).append(',').append(StringEscapeUtils.escapeCsv((String)"Physical Memory")).append(',').append(StringEscapeUtils.escapeCsv((String)"CPU usage")).append(',').append(StringEscapeUtils.escapeCsv((String)"Start Time")).append(',').append(StringEscapeUtils.escapeCsv((String)"Priority")).append(',').append(StringEscapeUtils.escapeCsv((String)"Full command")).append('\n');
            for (ProcessInfo processInfo : processesList) {
                sb.append(processInfo.getPid()).append(',').append(StringEscapeUtils.escapeCsv((String)processInfo.getName())).append(',').append(processInfo.getTime()).append(',').append(StringEscapeUtils.escapeCsv((String)processInfo.getUser())).append(',').append(processInfo.getVirtualMemory()).append(',').append(processInfo.getPhysicalMemory()).append(',').append(processInfo.getCpuUsage()).append(',').append(processInfo.getStartTime()).append(',').append(processInfo.getStartTime()).append(',').append(StringEscapeUtils.escapeCsv((String)processInfo.getCommand())).append('\n');
            }
            return sb.toString();
        });
    }

    public static class ClassifierFiltersArgument
    implements PositionalArgument {
        public int position() {
            return 1;
        }

        public String usage() {
            return "[all] [<classifier1> <classifier2> ...]";
        }

        public String parse(Args parsedArgs) {
            throw new UnsupportedOperationException("no parser exists");
        }
    }

    public static class OptionalForceArgument
    extends MandatoryNamedArg {
        OptionalForceArgument() {
            super("force", "", "Ignore disk full warning");
        }

        public String optionsListing() {
            return "--force";
        }

        public String usage() {
            return "[--force]";
        }
    }

    public static class OptionalVerboseArgument
    extends MandatoryNamedArg {
        OptionalVerboseArgument() {
            super("verbose", "", "More verbose error messages");
        }

        public String optionsListing() {
            return "--verbose";
        }

        public String usage() {
            return "[--verbose]";
        }
    }

    public static class OptionalListArgument
    extends MandatoryNamedArg {
        OptionalListArgument() {
            super("list", "", "List all available classifiers");
        }

        public String optionsListing() {
            return "--list";
        }

        public String usage() {
            return "[--list]";
        }
    }
}

