/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency;

import org.neo4j.consistency.RecordType;
import org.neo4j.consistency.report.ConsistencySummaryStatistics;
import org.neo4j.kernel.impl.store.DataInconsistencyError;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;

public class ConsistencyCheckingError
extends DataInconsistencyError {
    private final ConsistencySummaryStatistics summary;

    public ConsistencyCheckingError(LogEntryStart startEntry, LogEntryCommit commitEntry, ConsistencySummaryStatistics summary) {
        super(String.format("Inconsistencies in transaction:\n\t%s\n\t%s\n\t%s", startEntry == null ? "NO START ENTRY" : startEntry.toString(), commitEntry == null ? "NO COMMIT ENTRY" : commitEntry.toString(), summary));
        this.summary = summary;
    }

    public int getInconsistencyCountForRecordType(RecordType recordType) {
        return this.summary.getInconsistencyCountForRecordType(recordType);
    }

    public int getTotalInconsistencyCount() {
        return this.summary.getTotalInconsistencyCount();
    }
}

