/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.dbms;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.neo4j.graphdb.security.AuthorizationViolationException;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.server.rest.dbms.AuthorizationFilter;
import org.neo4j.server.rest.dbms.AuthorizedRequestWrapper;

public class AuthorizationDisabledFilter
extends AuthorizationFilter {
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        this.validateRequestType(servletRequest);
        this.validateResponseType(servletResponse);
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        try {
            filterChain.doFilter((ServletRequest)new AuthorizedRequestWrapper("BASIC", "ongdb", request, this.getAuthDisabledLoginContext()), servletResponse);
        }
        catch (AuthorizationViolationException e) {
            AuthorizationDisabledFilter.unauthorizedAccess(e.getMessage()).accept((Object)response);
        }
    }

    protected LoginContext getAuthDisabledLoginContext() {
        return LoginContext.AUTH_DISABLED;
    }
}

