/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.diffsets;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Predicate;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.kernel.impl.util.VersionedHashMap;
import org.neo4j.storageengine.api.txstate.DiffSetsVisitor;
import org.neo4j.storageengine.api.txstate.SuperReadableDiffSets;

abstract class SuperDiffSets<T>
implements SuperReadableDiffSets<T> {
    private Set<T> addedElements;
    private Set<T> removedElements;
    private Predicate<T> filter;

    SuperDiffSets() {
        this(null, null);
    }

    SuperDiffSets(Set<T> addedElements, Set<T> removedElements) {
        this.addedElements = addedElements;
        this.removedElements = removedElements;
    }

    @Override
    public void accept(DiffSetsVisitor<T> visitor) throws ConstraintValidationException, CreateConstraintFailureException {
        for (T element : this.added(false)) {
            visitor.visitAdded(element);
        }
        for (T element : this.removed(false)) {
            visitor.visitRemoved(element);
        }
    }

    public boolean add(T elem) {
        boolean wasRemoved = this.removed(false).remove(elem);
        return wasRemoved || this.added(true).add(elem);
    }

    public void replace(T toRemove, T toAdd) {
        Set<T> added = this.added(true);
        boolean removedFromAdded = added.remove(toRemove);
        this.removed(false).remove(toAdd);
        added.add(toAdd);
        if (!removedFromAdded) {
            this.removed(true).add(toRemove);
        }
    }

    public boolean remove(T elem) {
        boolean removedFromAddedElements = this.added(false).remove(elem);
        return removedFromAddedElements || this.removed(true).add(elem);
    }

    public void addAll(Iterator<T> elems) {
        while (elems.hasNext()) {
            this.add(elems.next());
        }
    }

    public void removeAll(Iterator<T> elems) {
        while (elems.hasNext()) {
            this.remove(elems.next());
        }
    }

    @Override
    public boolean isAdded(T elem) {
        return this.added(false).contains(elem);
    }

    @Override
    public boolean isRemoved(T elem) {
        return this.removed(false).contains(elem);
    }

    @Override
    public Set<T> getAdded() {
        return this.resultSet(this.addedElements);
    }

    @Override
    public Set<T> getAddedSnapshot() {
        if (this.addedElements == null) {
            return Collections.emptySet();
        }
        return new HashSet<T>(this.addedElements);
    }

    @Override
    public Set<T> getRemoved() {
        return this.resultSet(this.removedElements);
    }

    @Override
    public boolean isEmpty() {
        return this.added(false).isEmpty() && this.removed(false).isEmpty();
    }

    @Override
    public Iterator<T> apply(Iterator<T> source) {
        Iterator result = source;
        if (this.removedElements != null && !this.removedElements.isEmpty() || this.addedElements != null && !this.addedElements.isEmpty()) {
            this.ensureFilterHasBeenCreated();
            result = Iterators.filter(this.filter, result);
        }
        if (this.addedElements != null && !this.addedElements.isEmpty()) {
            result = Iterators.concat((Iterator[])new Iterator[]{result, this.addedElements.iterator()});
        }
        return result;
    }

    protected Set<T> added(boolean create) {
        if (this.addedElements == null) {
            if (!create) {
                return Collections.emptySet();
            }
            this.addedElements = this.newSet();
        }
        return this.addedElements;
    }

    protected Set<T> removed(boolean create) {
        if (this.removedElements == null) {
            if (!create) {
                return Collections.emptySet();
            }
            this.removedElements = this.newSet();
        }
        return this.removedElements;
    }

    private void ensureFilterHasBeenCreated() {
        if (this.filter == null) {
            this.filter = item -> !this.removed(false).contains(item) && !this.added(false).contains(item);
        }
    }

    @Override
    public int delta() {
        return this.added(false).size() - this.removed(false).size();
    }

    private Set<T> newSet() {
        return Collections.newSetFromMap(new VersionedHashMap());
    }

    private Set<T> resultSet(Set<T> coll) {
        return coll == null ? Collections.emptySet() : Collections.unmodifiableSet(coll);
    }

    public boolean unRemove(T item) {
        return this.removed(false).remove(item);
    }

    public void clear() {
        if (this.addedElements != null) {
            this.addedElements.clear();
        }
        if (this.removedElements != null) {
            this.removedElements.clear();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SuperDiffSets diffSets = (SuperDiffSets)o;
        if (this.addedElements != null ? !this.addedElements.equals(diffSets.addedElements) : diffSets.addedElements != null) {
            return false;
        }
        if (this.filter != null ? !this.filter.equals(diffSets.filter) : diffSets.filter != null) {
            return false;
        }
        return this.removedElements != null ? this.removedElements.equals(diffSets.removedElements) : diffSets.removedElements == null;
    }

    public int hashCode() {
        int result = this.addedElements != null ? this.addedElements.hashCode() : 0;
        result = 31 * result + (this.removedElements != null ? this.removedElements.hashCode() : 0);
        result = 31 * result + (this.filter != null ? this.filter.hashCode() : 0);
        return result;
    }

    public String toString() {
        return String.format("{+%s, -%s}", this.added(false), this.removed(false));
    }
}

