/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.Flushable;
import java.io.IOException;
import org.neo4j.kernel.impl.transaction.log.FlushableChannel;
import org.neo4j.kernel.impl.transaction.log.FlushablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalFlushableChannel;

public class PositionAwarePhysicalFlushableChannel
implements FlushablePositionAwareChannel {
    private LogVersionedStoreChannel logVersionedStoreChannel;
    private final PhysicalFlushableChannel channel;

    public PositionAwarePhysicalFlushableChannel(LogVersionedStoreChannel logVersionedStoreChannel) {
        this.logVersionedStoreChannel = logVersionedStoreChannel;
        this.channel = new PhysicalFlushableChannel(logVersionedStoreChannel);
    }

    public PositionAwarePhysicalFlushableChannel(LogVersionedStoreChannel logVersionedStoreChannel, int bufferSize) {
        this.logVersionedStoreChannel = logVersionedStoreChannel;
        this.channel = new PhysicalFlushableChannel(logVersionedStoreChannel, bufferSize);
    }

    @Override
    public LogPositionMarker getCurrentPosition(LogPositionMarker positionMarker) throws IOException {
        positionMarker.mark(this.logVersionedStoreChannel.getVersion(), this.channel.position());
        return positionMarker;
    }

    @Override
    public Flushable prepareForFlush() throws IOException {
        return this.channel.prepareForFlush();
    }

    @Override
    public FlushableChannel put(byte value) throws IOException {
        return this.channel.put(value);
    }

    @Override
    public FlushableChannel putShort(short value) throws IOException {
        return this.channel.putShort(value);
    }

    @Override
    public FlushableChannel putInt(int value) throws IOException {
        return this.channel.putInt(value);
    }

    @Override
    public FlushableChannel putLong(long value) throws IOException {
        return this.channel.putLong(value);
    }

    @Override
    public FlushableChannel putFloat(float value) throws IOException {
        return this.channel.putFloat(value);
    }

    @Override
    public FlushableChannel putDouble(double value) throws IOException {
        return this.channel.putDouble(value);
    }

    @Override
    public FlushableChannel put(byte[] value, int length) throws IOException {
        return this.channel.put(value, length);
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    public void setChannel(LogVersionedStoreChannel channel) {
        this.logVersionedStoreChannel = channel;
        this.channel.setChannel(channel);
    }

    public void setCurrentPosition(LogPosition position) throws IOException, UnsupportedOperationException {
        this.channel.position(position.getByteOffset());
    }
}

