/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.Comparator;
import org.neo4j.internal.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.impl.index.schema.NativeSchemaKey;
import org.neo4j.kernel.impl.index.schema.SchemaLayout;
import org.neo4j.values.storable.Values;

class PropertyLookupFallbackComparator<KEY extends NativeSchemaKey<KEY>>
implements Comparator<KEY> {
    private final SchemaLayout<KEY> schemaLayout;
    private final PropertyAccessor propertyAccessor;
    private final int propertyKeyId;

    PropertyLookupFallbackComparator(SchemaLayout<KEY> schemaLayout, PropertyAccessor propertyAccessor, int propertyKeyId) {
        this.schemaLayout = schemaLayout;
        this.propertyAccessor = propertyAccessor;
        this.propertyKeyId = propertyKeyId;
    }

    @Override
    public int compare(KEY k1, KEY k2) {
        int comparison = this.schemaLayout.compareValue(k1, k2);
        if (comparison != 0) {
            return comparison;
        }
        try {
            return Values.COMPARATOR.compare(this.propertyAccessor.getPropertyValue(((NativeSchemaKey)((Object)k1)).getEntityId(), this.propertyKeyId), this.propertyAccessor.getPropertyValue(((NativeSchemaKey)((Object)k2)).getEntityId(), this.propertyKeyId));
        }
        catch (EntityNotFoundException e) {
            return comparison;
        }
    }
}

