/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jmx.impl;

import javax.management.ObjectName;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.jmx.impl.ManagementBeanProvider;
import org.neo4j.jmx.impl.ManagementSupport;
import org.neo4j.jmx.impl.Neo4jMBean;
import org.neo4j.kernel.internal.KernelData;

public final class ManagementData
extends DependencyResolver.Adapter {
    private final KernelData kernel;
    private final ManagementSupport support;
    final ManagementBeanProvider provider;

    public ManagementData(ManagementBeanProvider provider, KernelData kernel, ManagementSupport support) {
        this.provider = provider;
        this.kernel = kernel;
        this.support = support;
    }

    public KernelData getKernelData() {
        return this.kernel;
    }

    ObjectName getObjectName(String ... extraNaming) {
        ObjectName name = this.support.createObjectName(this.kernel.instanceId(), this.provider.beanInterface, extraNaming);
        if (name == null) {
            throw new IllegalArgumentException(this.provider.beanInterface + " is not a ONgDB Management Bean interface");
        }
        return name;
    }

    void validate(Class<? extends Neo4jMBean> implClass) {
        if (!this.provider.beanInterface.isAssignableFrom(implClass)) {
            throw new IllegalStateException(implClass + " does not implement " + this.provider.beanInterface);
        }
    }

    public <T> T resolveDependency(Class<T> type, DependencyResolver.SelectionStrategy selector) throws IllegalArgumentException {
        return (T)this.getKernelData().graphDatabase().getDependencyResolver().resolveDependency(type, selector);
    }
}

