/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input;

import java.io.IOException;
import java.util.Arrays;
import java.util.stream.Stream;
import org.neo4j.unsafe.impl.batchimport.input.InputEntityVisitor;
import org.neo4j.unsafe.impl.batchimport.input.csv.Decorator;

public class InputEntityDecorators {
    public static final Decorator NO_DECORATOR = value2 -> value2;

    private InputEntityDecorators() {
    }

    public static Decorator additiveLabels(String[] labelNamesToAdd) {
        if (labelNamesToAdd == null || labelNamesToAdd.length == 0) {
            return NO_DECORATOR;
        }
        return node -> new AdditiveLabelsDecorator((InputEntityVisitor)node, labelNamesToAdd);
    }

    public static Decorator defaultRelationshipType(String defaultType) {
        return defaultType == null ? NO_DECORATOR : relationship -> new RelationshipTypeDecorator((InputEntityVisitor)relationship, defaultType);
    }

    public static Decorator decorators(final Decorator ... decorators) {
        return new Decorator(){

            @Override
            public InputEntityVisitor apply(InputEntityVisitor from2) {
                for (Decorator decorator : decorators) {
                    from2 = (InputEntityVisitor)decorator.apply(from2);
                }
                return from2;
            }

            @Override
            public boolean isMutable() {
                return Stream.of(decorators).anyMatch(Decorator::isMutable);
            }
        };
    }

    private static final class RelationshipTypeDecorator
    extends InputEntityVisitor.Delegate {
        private final String defaultType;
        private boolean hasType;

        RelationshipTypeDecorator(InputEntityVisitor actual2, String defaultType) {
            super(actual2);
            this.defaultType = defaultType;
        }

        @Override
        public boolean type(int type) {
            this.hasType = true;
            return super.type(type);
        }

        @Override
        public boolean type(String type) {
            if (type != null) {
                this.hasType = true;
            }
            return super.type(type);
        }

        @Override
        public void endOfEntity() throws IOException {
            if (!this.hasType) {
                super.type(this.defaultType);
                this.hasType = false;
            }
            super.endOfEntity();
        }
    }

    private static final class AdditiveLabelsDecorator
    extends InputEntityVisitor.Delegate {
        private final String[] transport = new String[1];
        private final String[] labelNamesToAdd;
        private final boolean[] seenLabels;
        private boolean seenLabelField;

        AdditiveLabelsDecorator(InputEntityVisitor actual2, String[] labelNamesToAdd) {
            super(actual2);
            this.labelNamesToAdd = labelNamesToAdd;
            this.seenLabels = new boolean[labelNamesToAdd.length];
        }

        @Override
        public boolean labelField(long labelField) {
            this.seenLabelField = true;
            return super.labelField(labelField);
        }

        @Override
        public boolean labels(String[] labels2) {
            if (!this.seenLabelField) {
                for (String label : labels2) {
                    for (int i = 0; i < this.labelNamesToAdd.length; ++i) {
                        if (this.seenLabels[i] || !this.labelNamesToAdd[i].equals(label)) continue;
                        this.seenLabels[i] = true;
                    }
                }
            }
            return super.labels(labels2);
        }

        @Override
        public void endOfEntity() throws IOException {
            if (!this.seenLabelField) {
                for (int i = 0; i < this.seenLabels.length; ++i) {
                    if (this.seenLabels[i]) continue;
                    this.transport[0] = this.labelNamesToAdd[i];
                    super.labels(this.transport);
                }
            }
            Arrays.fill(this.seenLabels, false);
            this.seenLabelField = false;
            super.endOfEntity();
        }
    }
}

