/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.prettyprint;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public class CypherVariablesFormatter {
    private static final String BACKTICK = "`";
    private static final Pattern ALPHA_NUMERIC = Pattern.compile("^[\\p{L}_][\\p{L}0-9_]*");

    @Nonnull
    public static String escape(@Nonnull String string2) {
        Matcher alphaNumericMatcher = ALPHA_NUMERIC.matcher(string2);
        if (!alphaNumericMatcher.matches()) {
            String reEscapeBackTicks = string2.replaceAll(BACKTICK, "``");
            return BACKTICK + reEscapeBackTicks + BACKTICK;
        }
        return string2;
    }

    @Nonnull
    public static String unescapedCypherVariable(@Nonnull String string2) {
        Matcher alphaNumericMatcher = ALPHA_NUMERIC.matcher(string2);
        if (!alphaNumericMatcher.matches()) {
            String substring = string2.substring(1, string2.length() - 1);
            return substring.replace("``", BACKTICK);
        }
        return string2;
    }
}

