/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.commands;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import org.neo4j.shell.commands.Command;
import org.neo4j.shell.commands.CommandHelper;
import org.neo4j.shell.exception.CommandException;
import org.neo4j.shell.log.AnsiFormattedText;
import org.neo4j.shell.log.Logger;

public class Help
implements Command {
    public static final String COMMAND_NAME = ":help";
    private final Logger logger;
    private final CommandHelper commandHelper;
    public static String CYPHER_REFCARD_LINK = "https://neo4j.com/docs/developer-manual/current/cypher/";

    public Help(@Nonnull Logger shell, @Nonnull CommandHelper commandHelper) {
        this.logger = shell;
        this.commandHelper = commandHelper;
    }

    @Override
    @Nonnull
    public String getName() {
        return COMMAND_NAME;
    }

    @Override
    @Nonnull
    public String getDescription() {
        return "Show this help message";
    }

    @Override
    @Nonnull
    public String getUsage() {
        return "[command]";
    }

    @Override
    @Nonnull
    public String getHelp() {
        return "Show the list of available commands or help for a specific command.";
    }

    @Override
    @Nonnull
    public List<String> getAliases() {
        return Arrays.asList(":man");
    }

    @Override
    public void execute(@Nonnull String argString) throws CommandException {
        String[] args = CommandHelper.simpleArgParse(argString, 0, 1, COMMAND_NAME, this.getUsage());
        if (args.length == 0) {
            this.printGeneralHelp();
        } else {
            this.printHelpFor(args[0]);
        }
    }

    private void printHelpFor(@Nonnull String name) throws CommandException {
        Command cmd = this.commandHelper.getCommand(name);
        if (cmd == null && !name.startsWith(":")) {
            cmd = this.commandHelper.getCommand(":" + name);
        }
        if (cmd == null) {
            throw new CommandException(AnsiFormattedText.from("No such command: ").bold().append(name));
        }
        this.logger.printOut(AnsiFormattedText.from("\nusage: ").bold().append(cmd.getName()).boldOff().append(" ").append(cmd.getUsage()).append("\n\n").append(cmd.getHelp()).append("\n").formattedString());
    }

    private void printGeneralHelp() {
        this.logger.printOut("\nAvailable commands:");
        List<Command> allCommands = this.commandHelper.getAllCommands();
        int leftColWidth = this.longestCmdLength(allCommands);
        allCommands.stream().forEach(cmd -> this.logger.printOut(AnsiFormattedText.from("  ").bold().append(String.format("%-" + leftColWidth + "s", cmd.getName())).boldOff().append(" " + cmd.getDescription()).formattedString()));
        this.logger.printOut("\nFor help on a specific command type:");
        this.logger.printOut(AnsiFormattedText.from("    ").append(COMMAND_NAME).bold().append(" command").boldOff().append("\n").formattedString());
        this.logger.printOut("\nFor help on cypher please visit:");
        this.logger.printOut(AnsiFormattedText.from("    ").append(CYPHER_REFCARD_LINK).append("\n").formattedString());
    }

    private int longestCmdLength(List<Command> allCommands) {
        String longestCommand = allCommands.stream().map(Command::getName).reduce("", (s1, s2) -> s1.length() > s2.length() ? s1 : s2);
        return longestCommand.length();
    }
}

